/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.impl;

import com.bloxbean.cardano.client.plutus.annotation.Constr;
import com.bloxbean.cardano.client.plutus.annotation.PlutusField;
import com.bloxbean.cardano.client.plutus.api.PlutusObjectConverter;
import com.bloxbean.cardano.client.plutus.exception.PlutusDataConvertionException;
import com.bloxbean.cardano.client.transaction.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.transaction.spec.BytesPlutusData;
import com.bloxbean.cardano.client.transaction.spec.ConstrPlutusData;
import com.bloxbean.cardano.client.transaction.spec.ListPlutusData;
import com.bloxbean.cardano.client.transaction.spec.PlutusData;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlutusObjectConverter
implements PlutusObjectConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultPlutusObjectConverter.class);

    @Override
    public PlutusData toPlutusData(Object obj) {
        if (Objects.isNull(obj)) {
            throw new PlutusDataConvertionException("Can't convert a null object");
        }
        if (obj instanceof PlutusData) {
            return (PlutusData)obj;
        }
        if (obj instanceof Integer) {
            return BigIntPlutusData.of((Integer)obj);
        }
        if (obj instanceof BigInteger) {
            return BigIntPlutusData.of((BigInteger)obj);
        }
        if (obj instanceof Long) {
            return BigIntPlutusData.of((Long)obj);
        }
        if (obj instanceof byte[]) {
            return BytesPlutusData.of((byte[])obj);
        }
        if (obj instanceof String) {
            return BytesPlutusData.of((String)obj);
        }
        Class<?> clazz = obj.getClass();
        Constr constr = clazz.getAnnotation(Constr.class);
        if (constr == null) {
            throw new PlutusDataConvertionException("@Contr annotation not found in class : " + clazz.getName());
        }
        int alternative = constr.alternative();
        List fields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getAnnotation(PlutusField.class) != null).map(field -> new Tuple<Field, PlutusField>((Field)field, field.getDeclaredAnnotation(PlutusField.class))).collect(Collectors.toList());
        ListPlutusData listPlutusData = new ListPlutusData();
        ConstrPlutusData constrPlutusData = ConstrPlutusData.builder().alternative(alternative).data(listPlutusData).build();
        for (Tuple tuple : fields) {
            Object value;
            Field field2 = (Field)tuple._1;
            field2.setAccessible(true);
            try {
                value = field2.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new PlutusDataConvertionException("Unable to convert value for field : " + field2.getName());
            }
            PlutusData plutusData = this._toPlutusData(field2.getName(), value);
            constrPlutusData.getData().add(plutusData);
        }
        return constrPlutusData;
    }

    private PlutusData _toPlutusData(String fieldName, Object obj) {
        if (Objects.isNull(obj)) {
            throw new PlutusDataConvertionException("Can't convert a null object : " + fieldName);
        }
        Class<?> clazz = obj.getClass();
        PlutusData plutusData = null;
        if (clazz == byte[].class) {
            plutusData = BytesPlutusData.of((byte[])obj);
        } else if (clazz == String.class) {
            String value = (String)obj;
            if (value.startsWith("0x") || value.startsWith("0X")) {
                byte[] bytes = HexUtil.decodeHexString(value);
                plutusData = BytesPlutusData.of(bytes);
            } else {
                plutusData = BytesPlutusData.of(value);
            }
        } else if (clazz == BigInteger.class || clazz == Long.class || clazz == Integer.class) {
            Number value = (Number)obj;
            if (clazz == BigInteger.class) {
                plutusData = BigIntPlutusData.of((BigInteger)value);
            } else if (clazz == Long.class) {
                plutusData = BigIntPlutusData.of((Long)value);
            } else if (clazz == Integer.class) {
                plutusData = BigIntPlutusData.of((Integer)value);
            }
        } else if (Collection.class.isAssignableFrom(clazz)) {
            Collection values = (Collection)obj;
            plutusData = new ListPlutusData();
            for (Object value : values) {
                ((ListPlutusData)plutusData).add(this._toPlutusData(fieldName + "[x]", value));
            }
        } else {
            plutusData = this.toPlutusData(obj);
        }
        return plutusData;
    }
}

