/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.model;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.transaction.model.TransactionRequest;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Policy;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MintTransaction
extends TransactionRequest {
    private List<MultiAsset> mintAssets;
    @JsonIgnore
    private Policy policy;

    public MintTransaction(Account sender, String receiver, BigInteger fee, List<Account> additionalWitnessAccounts, List<Utxo> utxosToInclude, String datumHash, List<MultiAsset> mintAssets, @Deprecated NativeScript policyScript, @Deprecated List<SecretKey> policyKeys, Policy policy) {
        super(sender, receiver, fee, additionalWitnessAccounts, utxosToInclude, datumHash);
        if (mintAssets != null && mintAssets.size() > 1) {
            List<MultiAsset> multiAssets = new ArrayList<MultiAsset>();
            for (MultiAsset ma : mintAssets) {
                multiAssets = MultiAsset.mergeMultiAssetLists(multiAssets, List.of(ma));
            }
            this.mintAssets = multiAssets;
        } else {
            this.mintAssets = mintAssets;
        }
        this.policy = policy != null ? policy : new Policy(policyScript, policyKeys);
    }

    public static MintTransactionBuilder builder() {
        return new MintTransactionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MintTransaction)) {
            return false;
        }
        MintTransaction other = (MintTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<MultiAsset> this$mintAssets = this.getMintAssets();
        List<MultiAsset> other$mintAssets = other.getMintAssets();
        if (this$mintAssets == null ? other$mintAssets != null : !((Object)this$mintAssets).equals(other$mintAssets)) {
            return false;
        }
        Policy this$policy = this.getPolicy();
        Policy other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MintTransaction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<MultiAsset> $mintAssets = this.getMintAssets();
        result = result * 59 + ($mintAssets == null ? 43 : ((Object)$mintAssets).hashCode());
        Policy $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        return result;
    }

    public List<MultiAsset> getMintAssets() {
        return this.mintAssets;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setMintAssets(List<MultiAsset> mintAssets) {
        this.mintAssets = mintAssets;
    }

    @JsonIgnore
    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    @Override
    public String toString() {
        return "MintTransaction(mintAssets=" + this.getMintAssets() + ", policy=" + this.getPolicy() + ")";
    }

    public MintTransaction() {
    }

    public MintTransaction(List<MultiAsset> mintAssets, Policy policy) {
        this.mintAssets = mintAssets;
        this.policy = policy;
    }

    public static class MintTransactionBuilder {
        private Account sender;
        private String receiver;
        private BigInteger fee;
        private List<Account> additionalWitnessAccounts;
        private List<Utxo> utxosToInclude;
        private String datumHash;
        private List<MultiAsset> mintAssets;
        private NativeScript policyScript;
        private List<SecretKey> policyKeys;
        private Policy policy;

        MintTransactionBuilder() {
        }

        public MintTransactionBuilder sender(Account sender) {
            this.sender = sender;
            return this;
        }

        public MintTransactionBuilder receiver(String receiver) {
            this.receiver = receiver;
            return this;
        }

        public MintTransactionBuilder fee(BigInteger fee) {
            this.fee = fee;
            return this;
        }

        public MintTransactionBuilder additionalWitnessAccounts(List<Account> additionalWitnessAccounts) {
            this.additionalWitnessAccounts = additionalWitnessAccounts;
            return this;
        }

        public MintTransactionBuilder utxosToInclude(List<Utxo> utxosToInclude) {
            this.utxosToInclude = utxosToInclude;
            return this;
        }

        public MintTransactionBuilder datumHash(String datumHash) {
            this.datumHash = datumHash;
            return this;
        }

        public MintTransactionBuilder mintAssets(List<MultiAsset> mintAssets) {
            this.mintAssets = mintAssets;
            return this;
        }

        @Deprecated
        public MintTransactionBuilder policyScript(NativeScript policyScript) {
            this.policyScript = policyScript;
            return this;
        }

        @Deprecated
        public MintTransactionBuilder policyKeys(List<SecretKey> policyKeys) {
            this.policyKeys = policyKeys;
            return this;
        }

        public MintTransactionBuilder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public MintTransaction build() {
            return new MintTransaction(this.sender, this.receiver, this.fee, this.additionalWitnessAccounts, this.utxosToInclude, this.datumHash, this.mintAssets, this.policyScript, this.policyKeys, this.policy);
        }

        public String toString() {
            return "MintTransaction.MintTransactionBuilder(sender=" + this.sender + ", receiver=" + this.receiver + ", fee=" + this.fee + ", additionalWitnessAccounts=" + this.additionalWitnessAccounts + ", utxosToInclude=" + this.utxosToInclude + ", datumHash=" + this.datumHash + ", mintAssets=" + this.mintAssets + ", policyScript=" + this.policyScript + ", policyKeys=" + this.policyKeys + ", policy=" + this.policy + ")";
        }
    }
}

