/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class Asset {
    private String name;
    private BigInteger value;

    @JsonIgnore
    public byte[] getNameAsBytes() {
        byte[] assetNameBytes = null;
        assetNameBytes = this.name != null && !this.name.isEmpty() ? (this.name.startsWith("0x") ? HexUtil.decodeHexString(this.name.substring(2)) : this.name.getBytes(StandardCharsets.UTF_8)) : new byte[]{};
        return assetNameBytes;
    }

    @JsonIgnore
    public String getNameAsHex() {
        byte[] bytes = this.getNameAsBytes();
        if (bytes == null) {
            return null;
        }
        return HexUtil.encodeHexString(bytes, true);
    }

    public String toString() {
        try {
            return "Asset{name=" + this.name + ", value=" + this.value + "}";
        }
        catch (Exception e) {
            return "Asset { Error : " + e.getMessage() + " }";
        }
    }

    public Asset plus(Asset that) {
        if (!Arrays.equals(this.getNameAsBytes(), that.getNameAsBytes())) {
            throw new IllegalArgumentException("Trying to add Assets with different name");
        }
        return Asset.builder().name(this.getName()).value(this.getValue().add(that.getValue())).build();
    }

    public Asset minus(Asset that) {
        if (!Arrays.equals(this.getNameAsBytes(), that.getNameAsBytes())) {
            throw new IllegalArgumentException("Trying to add Assets with different name");
        }
        return Asset.builder().name(this.getName()).value(this.getValue().subtract(that.getValue())).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asset asset = (Asset)o;
        return Arrays.equals(this.getNameAsBytes(), asset.getNameAsBytes()) && Objects.equals(this.value, asset.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static AssetBuilder builder() {
        return new AssetBuilder();
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public Asset(String name, BigInteger value) {
        this.name = name;
        this.value = value;
    }

    public Asset() {
    }

    public static class AssetBuilder {
        private String name;
        private BigInteger value;

        AssetBuilder() {
        }

        public AssetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssetBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        public Asset build() {
            return new Asset(this.name, this.value);
        }

        public String toString() {
            return "Asset.AssetBuilder(name=" + this.name + ", value=" + this.value + ")";
        }
    }
}

