/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.Tag;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadata;
import com.bloxbean.cardano.client.metadata.exception.MetadataSerializationException;
import com.bloxbean.cardano.client.transaction.spec.PlutusV1Script;
import com.bloxbean.cardano.client.transaction.spec.PlutusV2Script;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;

public class AuxiliaryData {
    private Metadata metadata;
    private List<NativeScript> nativeScripts;
    private List<PlutusV1Script> plutusV1Scripts;
    private List<PlutusV2Script> plutusV2Scripts;

    public DataItem serialize() throws CborSerializationException {
        return this.getAuxiliaryData();
    }

    public static AuxiliaryData deserialize(Map map) throws CborDeserializationException {
        Tag mapTag = map.getTag();
        AuxiliaryData auxiliaryData = new AuxiliaryData();
        if (mapTag != null && mapTag.getValue() == 259L) {
            DataItem metadataValueDI = map.get((DataItem)new UnsignedInteger(0L));
            DataItem nativeScriptsValueDI = map.get((DataItem)new UnsignedInteger(1L));
            DataItem plutusV1ScriptsValueDI = map.get((DataItem)new UnsignedInteger(2L));
            DataItem plutusV2ScriptsValueDI = map.get((DataItem)new UnsignedInteger(3L));
            if (metadataValueDI != null) {
                CBORMetadata cborMetadata = CBORMetadata.deserialize((Map)metadataValueDI);
                auxiliaryData.setMetadata(cborMetadata);
            }
            if (nativeScriptsValueDI != null) {
                Array nativeScriptsArray = (Array)nativeScriptsValueDI;
                for (DataItem nativeScriptDI : nativeScriptsArray.getDataItems()) {
                    NativeScript nativeScript = NativeScript.deserialize((Array)nativeScriptDI);
                    auxiliaryData.getNativeScripts().add(nativeScript);
                }
            }
            if (plutusV1ScriptsValueDI != null) {
                Array plutusV1ScriptsArray = (Array)plutusV1ScriptsValueDI;
                for (DataItem plutusV1ScriptDI : plutusV1ScriptsArray.getDataItems()) {
                    PlutusV1Script plutusV1Script = PlutusV1Script.deserialize((ByteString)plutusV1ScriptDI);
                    auxiliaryData.getPlutusV1Scripts().add(plutusV1Script);
                }
            }
            if (plutusV2ScriptsValueDI != null) {
                Array plutusV2ScriptsArray = (Array)plutusV2ScriptsValueDI;
                for (DataItem plutusV2ScriptDI : plutusV2ScriptsArray.getDataItems()) {
                    PlutusV2Script plutusV2Script = PlutusV2Script.deserialize((ByteString)plutusV2ScriptDI);
                    auxiliaryData.getPlutusV2Scripts().add(plutusV2Script);
                }
            }
        } else {
            CBORMetadata metadata = CBORMetadata.deserialize(map);
            auxiliaryData.setMetadata(metadata);
        }
        return auxiliaryData;
    }

    @JsonIgnore
    public byte[] getAuxiliaryDataHash() throws MetadataSerializationException {
        try {
            Map map = this.getAuxiliaryData();
            byte[] encodedBytes = CborSerializationUtil.serialize((DataItem)map);
            return Blake2bUtil.blake2bHash256(encodedBytes);
        }
        catch (Exception ex) {
            throw new MetadataSerializationException("CBOR serialization exception ", ex);
        }
    }

    private Map getAuxiliaryData() throws CborSerializationException {
        Map map = new Map();
        if (!(this.metadata == null || this.nativeScripts != null && this.nativeScripts.size() != 0 || this.plutusV1Scripts != null && this.plutusV1Scripts.size() != 0 || this.plutusV2Scripts != null && this.plutusV2Scripts.size() != 0)) {
            return this.metadata.getData();
        }
        map.setTag(new Tag(259L));
        if (this.metadata != null) {
            map.put((DataItem)new UnsignedInteger(0L), (DataItem)this.metadata.getData());
        }
        if (this.nativeScripts != null && this.nativeScripts.size() > 0) {
            Array nativeScriptArray = new Array();
            for (NativeScript nativeScript : this.nativeScripts) {
                nativeScriptArray.add(nativeScript.serializeAsDataItem());
            }
            map.put((DataItem)new UnsignedInteger(1L), (DataItem)nativeScriptArray);
        }
        if (this.plutusV1Scripts != null && this.plutusV1Scripts.size() > 0) {
            Array plutusV1ScriptArray = new Array();
            for (PlutusV1Script plutusV1Script : this.plutusV1Scripts) {
                plutusV1ScriptArray.add((DataItem)plutusV1Script.serializeAsDataItem());
            }
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)plutusV1ScriptArray);
        }
        if (this.plutusV2Scripts != null && this.plutusV2Scripts.size() > 0) {
            Array plutusV2ScriptArray = new Array();
            for (PlutusV2Script plutusV2Script : this.plutusV2Scripts) {
                plutusV2ScriptArray.add((DataItem)plutusV2Script.serializeAsDataItem());
            }
            map.put((DataItem)new UnsignedInteger(3L), (DataItem)plutusV2ScriptArray);
        }
        return map;
    }

    private static List<NativeScript> $default$nativeScripts() {
        return new ArrayList<NativeScript>();
    }

    private static List<PlutusV1Script> $default$plutusV1Scripts() {
        return new ArrayList<PlutusV1Script>();
    }

    private static List<PlutusV2Script> $default$plutusV2Scripts() {
        return new ArrayList<PlutusV2Script>();
    }

    public static AuxiliaryDataBuilder builder() {
        return new AuxiliaryDataBuilder();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public List<NativeScript> getNativeScripts() {
        return this.nativeScripts;
    }

    public List<PlutusV1Script> getPlutusV1Scripts() {
        return this.plutusV1Scripts;
    }

    public List<PlutusV2Script> getPlutusV2Scripts() {
        return this.plutusV2Scripts;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setNativeScripts(List<NativeScript> nativeScripts) {
        this.nativeScripts = nativeScripts;
    }

    public void setPlutusV1Scripts(List<PlutusV1Script> plutusV1Scripts) {
        this.plutusV1Scripts = plutusV1Scripts;
    }

    public void setPlutusV2Scripts(List<PlutusV2Script> plutusV2Scripts) {
        this.plutusV2Scripts = plutusV2Scripts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuxiliaryData)) {
            return false;
        }
        AuxiliaryData other = (AuxiliaryData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        List<NativeScript> this$nativeScripts = this.getNativeScripts();
        List<NativeScript> other$nativeScripts = other.getNativeScripts();
        if (this$nativeScripts == null ? other$nativeScripts != null : !((Object)this$nativeScripts).equals(other$nativeScripts)) {
            return false;
        }
        List<PlutusV1Script> this$plutusV1Scripts = this.getPlutusV1Scripts();
        List<PlutusV1Script> other$plutusV1Scripts = other.getPlutusV1Scripts();
        if (this$plutusV1Scripts == null ? other$plutusV1Scripts != null : !((Object)this$plutusV1Scripts).equals(other$plutusV1Scripts)) {
            return false;
        }
        List<PlutusV2Script> this$plutusV2Scripts = this.getPlutusV2Scripts();
        List<PlutusV2Script> other$plutusV2Scripts = other.getPlutusV2Scripts();
        return !(this$plutusV2Scripts == null ? other$plutusV2Scripts != null : !((Object)this$plutusV2Scripts).equals(other$plutusV2Scripts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuxiliaryData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        List<NativeScript> $nativeScripts = this.getNativeScripts();
        result = result * 59 + ($nativeScripts == null ? 43 : ((Object)$nativeScripts).hashCode());
        List<PlutusV1Script> $plutusV1Scripts = this.getPlutusV1Scripts();
        result = result * 59 + ($plutusV1Scripts == null ? 43 : ((Object)$plutusV1Scripts).hashCode());
        List<PlutusV2Script> $plutusV2Scripts = this.getPlutusV2Scripts();
        result = result * 59 + ($plutusV2Scripts == null ? 43 : ((Object)$plutusV2Scripts).hashCode());
        return result;
    }

    public String toString() {
        return "AuxiliaryData(metadata=" + this.getMetadata() + ", nativeScripts=" + this.getNativeScripts() + ", plutusV1Scripts=" + this.getPlutusV1Scripts() + ", plutusV2Scripts=" + this.getPlutusV2Scripts() + ")";
    }

    public AuxiliaryData(Metadata metadata, List<NativeScript> nativeScripts, List<PlutusV1Script> plutusV1Scripts, List<PlutusV2Script> plutusV2Scripts) {
        this.metadata = metadata;
        this.nativeScripts = nativeScripts;
        this.plutusV1Scripts = plutusV1Scripts;
        this.plutusV2Scripts = plutusV2Scripts;
    }

    public AuxiliaryData() {
        this.nativeScripts = AuxiliaryData.$default$nativeScripts();
        this.plutusV1Scripts = AuxiliaryData.$default$plutusV1Scripts();
        this.plutusV2Scripts = AuxiliaryData.$default$plutusV2Scripts();
    }

    public static class AuxiliaryDataBuilder {
        private Metadata metadata;
        private boolean nativeScripts$set;
        private List<NativeScript> nativeScripts$value;
        private boolean plutusV1Scripts$set;
        private List<PlutusV1Script> plutusV1Scripts$value;
        private boolean plutusV2Scripts$set;
        private List<PlutusV2Script> plutusV2Scripts$value;

        AuxiliaryDataBuilder() {
        }

        public AuxiliaryDataBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public AuxiliaryDataBuilder nativeScripts(List<NativeScript> nativeScripts) {
            this.nativeScripts$value = nativeScripts;
            this.nativeScripts$set = true;
            return this;
        }

        public AuxiliaryDataBuilder plutusV1Scripts(List<PlutusV1Script> plutusV1Scripts) {
            this.plutusV1Scripts$value = plutusV1Scripts;
            this.plutusV1Scripts$set = true;
            return this;
        }

        public AuxiliaryDataBuilder plutusV2Scripts(List<PlutusV2Script> plutusV2Scripts) {
            this.plutusV2Scripts$value = plutusV2Scripts;
            this.plutusV2Scripts$set = true;
            return this;
        }

        public AuxiliaryData build() {
            List<NativeScript> nativeScripts$value = this.nativeScripts$value;
            if (!this.nativeScripts$set) {
                nativeScripts$value = AuxiliaryData.$default$nativeScripts();
            }
            List<PlutusV1Script> plutusV1Scripts$value = this.plutusV1Scripts$value;
            if (!this.plutusV1Scripts$set) {
                plutusV1Scripts$value = AuxiliaryData.$default$plutusV1Scripts();
            }
            List<PlutusV2Script> plutusV2Scripts$value = this.plutusV2Scripts$value;
            if (!this.plutusV2Scripts$set) {
                plutusV2Scripts$value = AuxiliaryData.$default$plutusV2Scripts();
            }
            return new AuxiliaryData(this.metadata, nativeScripts$value, plutusV1Scripts$value, plutusV2Scripts$value);
        }

        public String toString() {
            return "AuxiliaryData.AuxiliaryDataBuilder(metadata=" + this.metadata + ", nativeScripts$value=" + this.nativeScripts$value + ", plutusV1Scripts$value=" + this.plutusV1Scripts$value + ", plutusV2Scripts$value=" + this.plutusV2Scripts$value + ")";
        }
    }
}

