/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.PlutusData;
import java.math.BigInteger;

public class BigIntPlutusData
implements PlutusData {
    private BigInteger value;

    public static BigIntPlutusData deserialize(Number numberDI) throws CborDeserializationException {
        if (numberDI == null) {
            return null;
        }
        return new BigIntPlutusData(numberDI.getValue());
    }

    public static BigIntPlutusData of(int i) {
        return new BigIntPlutusData(BigInteger.valueOf(i));
    }

    public static BigIntPlutusData of(long l) {
        return new BigIntPlutusData(BigInteger.valueOf(l));
    }

    public static BigIntPlutusData of(BigInteger b) {
        return new BigIntPlutusData(b);
    }

    @Override
    public DataItem serialize() throws CborSerializationException {
        Object di = null;
        if (this.value != null) {
            di = this.value.compareTo(BigInteger.ZERO) == 0 || this.value.compareTo(BigInteger.ZERO) == 1 ? new UnsignedInteger(this.value) : new NegativeInteger(this.value);
        }
        return di;
    }

    public static BigIntPlutusDataBuilder builder() {
        return new BigIntPlutusDataBuilder();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigIntPlutusData(BigInteger value) {
        this.value = value;
    }

    public BigIntPlutusData() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigIntPlutusData)) {
            return false;
        }
        BigIntPlutusData other = (BigIntPlutusData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BigIntPlutusData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public static class BigIntPlutusDataBuilder {
        private BigInteger value;

        BigIntPlutusDataBuilder() {
        }

        public BigIntPlutusDataBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        public BigIntPlutusData build() {
            return new BigIntPlutusData(this.value);
        }

        public String toString() {
            return "BigIntPlutusData.BigIntPlutusDataBuilder(value=" + this.value + ")";
        }
    }
}

