/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import java.util.Arrays;
import java.util.List;

public class BootstrapWitness {
    private byte[] publicKey;
    private byte[] signature;
    public byte[] chainCode;
    public byte[] attributes;

    public Array serialize() {
        Array array = new Array();
        array.add((DataItem)new ByteString(this.publicKey));
        array.add((DataItem)new ByteString(this.signature));
        array.add((DataItem)new ByteString(this.chainCode));
        array.add((DataItem)new ByteString(this.attributes));
        return array;
    }

    public static BootstrapWitness deserialize(Array bootstrapWitnessArrayDI) throws CborDeserializationException {
        List dataItemList = bootstrapWitnessArrayDI.getDataItems();
        if (dataItemList == null || dataItemList.size() != 4) {
            throw new CborDeserializationException("BootstrapWitness deserialization error. Invalid no of DataItem");
        }
        DataItem vkeyDI = (DataItem)dataItemList.get(0);
        DataItem sigDI = (DataItem)dataItemList.get(1);
        DataItem chainCodeDI = (DataItem)dataItemList.get(2);
        DataItem attributesDI = (DataItem)dataItemList.get(3);
        BootstrapWitness bootstrapWitness = new BootstrapWitness();
        bootstrapWitness.setPublicKey(((ByteString)vkeyDI).getBytes());
        bootstrapWitness.setSignature(((ByteString)sigDI).getBytes());
        bootstrapWitness.setChainCode(((ByteString)chainCodeDI).getBytes());
        bootstrapWitness.setAttributes(((ByteString)attributesDI).getBytes());
        return bootstrapWitness;
    }

    public static BootstrapWitnessBuilder builder() {
        return new BootstrapWitnessBuilder();
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getChainCode() {
        return this.chainCode;
    }

    public byte[] getAttributes() {
        return this.attributes;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void setChainCode(byte[] chainCode) {
        this.chainCode = chainCode;
    }

    public void setAttributes(byte[] attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BootstrapWitness)) {
            return false;
        }
        BootstrapWitness other = (BootstrapWitness)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        if (!Arrays.equals(this.getChainCode(), other.getChainCode())) {
            return false;
        }
        return Arrays.equals(this.getAttributes(), other.getAttributes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BootstrapWitness;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        result = result * 59 + Arrays.hashCode(this.getChainCode());
        result = result * 59 + Arrays.hashCode(this.getAttributes());
        return result;
    }

    public String toString() {
        return "BootstrapWitness(publicKey=" + Arrays.toString(this.getPublicKey()) + ", signature=" + Arrays.toString(this.getSignature()) + ", chainCode=" + Arrays.toString(this.getChainCode()) + ", attributes=" + Arrays.toString(this.getAttributes()) + ")";
    }

    public BootstrapWitness(byte[] publicKey, byte[] signature, byte[] chainCode, byte[] attributes) {
        this.publicKey = publicKey;
        this.signature = signature;
        this.chainCode = chainCode;
        this.attributes = attributes;
    }

    public BootstrapWitness() {
    }

    public static class BootstrapWitnessBuilder {
        private byte[] publicKey;
        private byte[] signature;
        private byte[] chainCode;
        private byte[] attributes;

        BootstrapWitnessBuilder() {
        }

        public BootstrapWitnessBuilder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public BootstrapWitnessBuilder signature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public BootstrapWitnessBuilder chainCode(byte[] chainCode) {
            this.chainCode = chainCode;
            return this;
        }

        public BootstrapWitnessBuilder attributes(byte[] attributes) {
            this.attributes = attributes;
            return this;
        }

        public BootstrapWitness build() {
            return new BootstrapWitness(this.publicKey, this.signature, this.chainCode, this.attributes);
        }

        public String toString() {
            return "BootstrapWitness.BootstrapWitnessBuilder(publicKey=" + Arrays.toString(this.publicKey) + ", signature=" + Arrays.toString(this.signature) + ", chainCode=" + Arrays.toString(this.chainCode) + ", attributes=" + Arrays.toString(this.attributes) + ")";
        }
    }
}

