/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import com.bloxbean.cardano.client.transaction.spec.Language;
import java.util.Arrays;
import lombok.NonNull;

public class CostModel {
    private Language language;
    private long[] costs;

    public CostModel(@NonNull Language language, @NonNull long[] costs) {
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        if (costs == null) {
            throw new NullPointerException("costs is marked non-null but is null");
        }
        this.language = language;
        this.costs = costs;
    }

    public static CostModelBuilder builder() {
        return new CostModelBuilder();
    }

    public Language getLanguage() {
        return this.language;
    }

    public long[] getCosts() {
        return this.costs;
    }

    public static class CostModelBuilder {
        private Language language;
        private long[] costs;

        CostModelBuilder() {
        }

        public CostModelBuilder language(Language language) {
            this.language = language;
            return this;
        }

        public CostModelBuilder costs(long[] costs) {
            this.costs = costs;
            return this;
        }

        public CostModel build() {
            return new CostModel(this.language, this.costs);
        }

        public String toString() {
            return "CostModel.CostModelBuilder(language=" + this.language + ", costs=" + Arrays.toString(this.costs) + ")";
        }
    }
}

