/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Special;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.PlutusData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListPlutusData
implements PlutusData {
    private List<PlutusData> plutusDataList;
    private boolean isChunked;

    public static ListPlutusData of(PlutusData ... plutusDataList) {
        ListPlutusData listPlutusData = new ListPlutusData();
        Arrays.stream(plutusDataList).forEach(plutusData -> listPlutusData.add((PlutusData)plutusData));
        return listPlutusData;
    }

    public static ListPlutusData deserialize(Array arrayDI) throws CborDeserializationException {
        if (arrayDI == null) {
            return null;
        }
        boolean isChunked = false;
        ListPlutusData listPlutusData = new ListPlutusData();
        for (DataItem di : arrayDI.getDataItems()) {
            if (di == Special.BREAK) {
                isChunked = true;
                break;
            }
            PlutusData plutusData = PlutusData.deserialize(di);
            if (plutusData == null) {
                throw new CborDeserializationException("Null value found during PlutusData de-serialization");
            }
            listPlutusData.add(PlutusData.deserialize(di));
        }
        listPlutusData.isChunked = isChunked;
        return listPlutusData;
    }

    public void add(PlutusData plutusData) {
        if (this.plutusDataList == null) {
            this.plutusDataList = new ArrayList<PlutusData>();
        }
        this.plutusDataList.add(plutusData);
    }

    @Override
    public DataItem serialize() throws CborSerializationException {
        if (this.plutusDataList == null) {
            return null;
        }
        Array plutusDataArray = new Array();
        if (this.plutusDataList.size() == 0) {
            return plutusDataArray;
        }
        if (this.isChunked) {
            plutusDataArray.setChunked(true);
        }
        for (PlutusData plutusData : this.plutusDataList) {
            DataItem di = plutusData.serialize();
            if (di == null) {
                throw new CborSerializationException("Cbor Serialization failed for plutus data. NULL serialized value found in the list");
            }
            plutusDataArray.add(di);
        }
        if (this.isChunked) {
            plutusDataArray.add((DataItem)Special.BREAK);
        }
        return plutusDataArray;
    }

    private static List<PlutusData> $default$plutusDataList() {
        return new ArrayList<PlutusData>();
    }

    private static boolean $default$isChunked() {
        return true;
    }

    public static ListPlutusDataBuilder builder() {
        return new ListPlutusDataBuilder();
    }

    public List<PlutusData> getPlutusDataList() {
        return this.plutusDataList;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public ListPlutusData(List<PlutusData> plutusDataList, boolean isChunked) {
        this.plutusDataList = plutusDataList;
        this.isChunked = isChunked;
    }

    public ListPlutusData() {
        this.plutusDataList = ListPlutusData.$default$plutusDataList();
        this.isChunked = ListPlutusData.$default$isChunked();
    }

    public static class ListPlutusDataBuilder {
        private boolean plutusDataList$set;
        private List<PlutusData> plutusDataList$value;
        private boolean isChunked$set;
        private boolean isChunked$value;

        ListPlutusDataBuilder() {
        }

        public ListPlutusDataBuilder plutusDataList(List<PlutusData> plutusDataList) {
            this.plutusDataList$value = plutusDataList;
            this.plutusDataList$set = true;
            return this;
        }

        public ListPlutusDataBuilder isChunked(boolean isChunked) {
            this.isChunked$value = isChunked;
            this.isChunked$set = true;
            return this;
        }

        public ListPlutusData build() {
            List<PlutusData> plutusDataList$value = this.plutusDataList$value;
            if (!this.plutusDataList$set) {
                plutusDataList$value = ListPlutusData.$default$plutusDataList();
            }
            boolean isChunked$value = this.isChunked$value;
            if (!this.isChunked$set) {
                isChunked$value = ListPlutusData.$default$isChunked();
            }
            return new ListPlutusData(plutusDataList$value, isChunked$value);
        }

        public String toString() {
            return "ListPlutusData.ListPlutusDataBuilder(plutusDataList$value=" + this.plutusDataList$value + ", isChunked$value=" + this.isChunked$value + ")";
        }
    }
}

