/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.PlutusData;
import java.util.HashMap;
import java.util.Map;

public class MapPlutusData
implements PlutusData {
    private java.util.Map<PlutusData, PlutusData> map;

    public static MapPlutusData deserialize(Map mapDI) throws CborDeserializationException {
        if (mapDI == null) {
            return null;
        }
        MapPlutusData mapPlutusData = new MapPlutusData();
        for (DataItem keyDI : mapDI.getKeys()) {
            PlutusData key = PlutusData.deserialize(keyDI);
            PlutusData value = PlutusData.deserialize(mapDI.get(keyDI));
            mapPlutusData.put(key, value);
        }
        return mapPlutusData;
    }

    public MapPlutusData put(PlutusData key, PlutusData value) {
        if (this.map == null) {
            this.map = new HashMap<PlutusData, PlutusData>();
        }
        this.map.put(key, value);
        return this;
    }

    @Override
    public DataItem serialize() throws CborSerializationException {
        if (this.map == null) {
            return null;
        }
        Map plutusDataMap = new Map();
        for (Map.Entry<PlutusData, PlutusData> entry : this.map.entrySet()) {
            DataItem key = entry.getKey().serialize();
            DataItem value = entry.getValue().serialize();
            if (key == null) {
                throw new CborSerializationException("Cbor serialization failed for PlutusData.  NULL serialized value found for key");
            }
            if (value == null) {
                throw new CborSerializationException("Cbor serialization failed for PlutusData.  NULL serialized value found for value");
            }
            plutusDataMap.put(key, value);
        }
        return plutusDataMap;
    }

    private static java.util.Map<PlutusData, PlutusData> $default$map() {
        return new HashMap<PlutusData, PlutusData>();
    }

    public static MapPlutusDataBuilder builder() {
        return new MapPlutusDataBuilder();
    }

    public java.util.Map<PlutusData, PlutusData> getMap() {
        return this.map;
    }

    public MapPlutusData(java.util.Map<PlutusData, PlutusData> map) {
        this.map = map;
    }

    public MapPlutusData() {
        this.map = MapPlutusData.$default$map();
    }

    public static class MapPlutusDataBuilder {
        private boolean map$set;
        private java.util.Map<PlutusData, PlutusData> map$value;

        MapPlutusDataBuilder() {
        }

        public MapPlutusDataBuilder map(java.util.Map<PlutusData, PlutusData> map) {
            this.map$value = map;
            this.map$set = true;
            return this;
        }

        public MapPlutusData build() {
            java.util.Map<PlutusData, PlutusData> map$value = this.map$value;
            if (!this.map$set) {
                map$value = MapPlutusData.$default$map();
            }
            return new MapPlutusData(map$value);
        }

        public String toString() {
            return "MapPlutusData.MapPlutusDataBuilder(map$value=" + this.map$value + ")";
        }
    }
}

