/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.Comparators;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import com.bloxbean.cardano.client.transaction.util.cbor.SortedMap;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MultiAsset {
    private String policyId;
    private List<Asset> assets;

    public static MultiAsset deserialize(Map multiAssetsMap, DataItem key) {
        MultiAsset multiAsset = new MultiAsset();
        ByteString keyBS = (ByteString)key;
        multiAsset.setPolicyId(HexUtil.encodeHexString(keyBS.getBytes()));
        Map assetsMap = (Map)multiAssetsMap.get(key);
        for (DataItem assetKey : assetsMap.getKeys()) {
            ByteString assetNameBS = (ByteString)assetKey;
            DataItem valueDI = assetsMap.get(assetKey);
            BigInteger value = CborSerializationUtil.getBigInteger(valueDI);
            String name = HexUtil.encodeHexString(assetNameBS.getBytes(), true);
            multiAsset.getAssets().add(new Asset(name, value));
        }
        return multiAsset;
    }

    public static List<MultiAsset> mergeMultiAssetLists(List<MultiAsset> multiAssets1, List<MultiAsset> multiAssets2) {
        ArrayList<MultiAsset> tempMultiAssets = new ArrayList<MultiAsset>();
        if (multiAssets1 != null) {
            tempMultiAssets.addAll(multiAssets1);
        }
        if (multiAssets2 != null) {
            tempMultiAssets.addAll(multiAssets2);
        }
        return tempMultiAssets.stream().collect(Collectors.groupingBy(MultiAsset::getPolicyId)).entrySet().stream().map(entry -> ((List)entry.getValue()).stream().reduce(MultiAsset.builder().policyId((String)entry.getKey()).assets(Arrays.asList(new Asset[0])).build(), MultiAsset::plus)).collect(Collectors.toList());
    }

    public static List<MultiAsset> subtractMultiAssetLists(List<MultiAsset> multiAssets1, List<MultiAsset> multiAssets2) {
        ArrayList<MultiAsset> tempMultiAssets = new ArrayList<MultiAsset>();
        if (multiAssets1 != null) {
            tempMultiAssets.addAll(multiAssets1);
        }
        ArrayList<MultiAsset> multiAssetListResult = new ArrayList<MultiAsset>();
        java.util.Map<String, MultiAsset> thatMultiAssetsMap = MultiAsset.convertListToMap(multiAssets2);
        for (MultiAsset multiAsset : tempMultiAssets) {
            if (thatMultiAssetsMap.containsKey(multiAsset.getPolicyId())) {
                multiAssetListResult.add(multiAsset.minus(thatMultiAssetsMap.get(multiAsset.getPolicyId())));
                continue;
            }
            multiAssetListResult.add(multiAsset);
        }
        return multiAssetListResult;
    }

    private static java.util.Map<String, MultiAsset> convertListToMap(List<MultiAsset> multiAssets) {
        return multiAssets.stream().collect(Collectors.toMap(MultiAsset::getPolicyId, Function.identity()));
    }

    public void serialize(Map multiAssetMap) {
        SortedMap assetsMap = new SortedMap();
        ArrayList<Asset> cloneAssets = new ArrayList<Asset>(this.assets);
        Collections.sort(cloneAssets, Comparators.assetComparator);
        for (Asset asset : cloneAssets) {
            UnsignedInteger value;
            ByteString assetNameBytes = new ByteString(asset.getNameAsBytes());
            if (asset.getValue().compareTo(BigInteger.ZERO) == 0 || asset.getValue().compareTo(BigInteger.ZERO) == 1) {
                value = new UnsignedInteger(asset.getValue());
                assetsMap.put((DataItem)assetNameBytes, (DataItem)value);
                continue;
            }
            value = new NegativeInteger(asset.getValue());
            assetsMap.put((DataItem)assetNameBytes, (DataItem)value);
        }
        ByteString policyIdByte = new ByteString(HexUtil.decodeHexString(this.policyId));
        multiAssetMap.put((DataItem)policyIdByte, (DataItem)assetsMap);
    }

    public String toString() {
        try {
            return "MultiAsset{policyId=" + this.policyId + ", assets=" + this.assets + "}";
        }
        catch (Exception e) {
            return "MultiAsset { Error : " + e.getMessage() + " }";
        }
    }

    public MultiAsset plus(MultiAsset that) {
        if (!this.getPolicyId().equals(that.getPolicyId())) {
            throw new IllegalArgumentException("Trying to add MultiAssets with different policyId");
        }
        ArrayList<Asset> assetsClone = new ArrayList<Asset>(this.getAssets());
        assetsClone.addAll(that.getAssets());
        List<Asset> mergedAssets = assetsClone.stream().collect(Collectors.groupingBy(Asset::getName)).entrySet().stream().map(entry -> ((List)entry.getValue()).stream().reduce(Asset.builder().name((String)entry.getKey()).value(BigInteger.ZERO).build(), Asset::plus)).collect(Collectors.toList());
        return MultiAsset.builder().policyId(this.getPolicyId()).assets(mergedAssets).build();
    }

    public MultiAsset minus(MultiAsset that) {
        if (!this.getPolicyId().equals(that.getPolicyId())) {
            throw new IllegalArgumentException("Trying to add MultiAssets with different policyId");
        }
        ArrayList<Asset> assetsResult = new ArrayList<Asset>();
        java.util.Map<String, Asset> thatAssetsMap = this.convertToMap(that.assets);
        for (Asset asset : this.getAssets()) {
            if (thatAssetsMap.containsKey(asset.getNameAsHex())) {
                assetsResult.add(asset.minus(thatAssetsMap.get(asset.getNameAsHex())));
                continue;
            }
            assetsResult.add(asset);
        }
        return MultiAsset.builder().policyId(this.getPolicyId()).assets(assetsResult).build();
    }

    private java.util.Map<String, Asset> convertToMap(List<Asset> assets) {
        return assets.stream().collect(Collectors.toMap(Asset::getNameAsHex, Function.identity()));
    }

    private static List<Asset> $default$assets() {
        return new ArrayList<Asset>();
    }

    public static MultiAssetBuilder builder() {
        return new MultiAssetBuilder();
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setAssets(List<Asset> assets) {
        this.assets = assets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiAsset)) {
            return false;
        }
        MultiAsset other = (MultiAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$policyId = this.getPolicyId();
        String other$policyId = other.getPolicyId();
        if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
            return false;
        }
        List<Asset> this$assets = this.getAssets();
        List<Asset> other$assets = other.getAssets();
        return !(this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiAsset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $policyId = this.getPolicyId();
        result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
        List<Asset> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        return result;
    }

    public MultiAsset(String policyId, List<Asset> assets) {
        this.policyId = policyId;
        this.assets = assets;
    }

    public MultiAsset() {
        this.assets = MultiAsset.$default$assets();
    }

    public static class MultiAssetBuilder {
        private String policyId;
        private boolean assets$set;
        private List<Asset> assets$value;

        MultiAssetBuilder() {
        }

        public MultiAssetBuilder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public MultiAssetBuilder assets(List<Asset> assets) {
            this.assets$value = assets;
            this.assets$set = true;
            return this;
        }

        public MultiAsset build() {
            List<Asset> assets$value = this.assets$value;
            if (!this.assets$set) {
                assets$value = MultiAsset.$default$assets();
            }
            return new MultiAsset(this.policyId, assets$value);
        }

        public String toString() {
            return "MultiAsset.MultiAssetBuilder(policyId=" + this.policyId + ", assets$value=" + this.assets$value + ")";
        }
    }
}

