/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.Number;
import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.transaction.spec.BytesPlutusData;
import com.bloxbean.cardano.client.transaction.spec.ConstrPlutusData;
import com.bloxbean.cardano.client.transaction.spec.ListPlutusData;
import com.bloxbean.cardano.client.transaction.spec.MapPlutusData;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import com.bloxbean.cardano.client.util.HexUtil;
import lombok.NonNull;

public interface PlutusData {
    public DataItem serialize() throws CborSerializationException;

    public static PlutusData deserialize(DataItem dataItem) throws CborDeserializationException {
        if (dataItem == null) {
            return null;
        }
        if (dataItem instanceof Number) {
            return BigIntPlutusData.deserialize((Number)dataItem);
        }
        if (dataItem instanceof ByteString) {
            return BytesPlutusData.deserialize((ByteString)dataItem);
        }
        if (dataItem instanceof Array) {
            if (dataItem.getTag() == null) {
                return ListPlutusData.deserialize((Array)dataItem);
            }
            return ConstrPlutusData.deserialize(dataItem);
        }
        if (dataItem instanceof Map) {
            return MapPlutusData.deserialize((Map)dataItem);
        }
        throw new CborDeserializationException("Cbor deserialization failed. Invalid type. " + dataItem);
    }

    public static PlutusData deserialize(@NonNull byte[] serializedBytes) throws CborDeserializationException {
        if (serializedBytes == null) {
            throw new NullPointerException("serializedBytes is marked non-null but is null");
        }
        try {
            DataItem dataItem = (DataItem)CborDecoder.decode((byte[])serializedBytes).get(0);
            return PlutusData.deserialize(dataItem);
        }
        catch (CborException | CborDeserializationException e) {
            throw new CborDeserializationException("Cbor de-serialization error", (Exception)e);
        }
    }

    default public String getDatumHash() throws CborSerializationException, CborException {
        return HexUtil.encodeHexString(this.getDatumHashAsBytes());
    }

    default public byte[] getDatumHashAsBytes() throws CborSerializationException, CborException {
        return KeyGenUtil.blake2bHash256(CborSerializationUtil.serialize(this.serialize()));
    }

    default public String serializeToHex() {
        try {
            return HexUtil.encodeHexString(CborSerializationUtil.serialize(this.serialize()));
        }
        catch (Exception e) {
            throw new CborRuntimeException("Cbor serialization error", e);
        }
    }
}

