/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.RationalNumber;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.Nonce;
import com.bloxbean.cardano.client.transaction.spec.CostMdls;
import com.bloxbean.cardano.client.transaction.spec.ExUnitPrices;
import com.bloxbean.cardano.client.transaction.spec.ExUnits;
import com.bloxbean.cardano.client.transaction.spec.ProtocolVersion;
import com.bloxbean.cardano.client.transaction.spec.Rational;
import com.bloxbean.cardano.client.transaction.spec.UnitInterval;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import java.math.BigInteger;
import java.util.List;

public class ProtocolParamUpdate {
    private BigInteger minFeeA;
    private BigInteger minFeeB;
    private Integer maxBlockSize;
    private Integer maxTxSize;
    private Integer maxBlockHeaderSize;
    private BigInteger keyDeposit;
    private BigInteger poolDeposit;
    private Integer maxEpoch;
    private Integer nOpt;
    private Rational poolPledgeInfluence;
    private UnitInterval expansionRate;
    private UnitInterval treasuryGrowthRate;
    @Deprecated
    private UnitInterval decentralisationConstant;
    @Deprecated
    private Nonce extraEntropy;
    private ProtocolVersion protocolVersion;
    @Deprecated
    private BigInteger minUtxo;
    private BigInteger minPoolCost;
    private BigInteger adaPerUtxoByte;
    private CostMdls costModels;
    private ExUnitPrices executionCosts;
    private ExUnits maxTxExUnits;
    private ExUnits maxBlockExUnits;
    private Long maxValSize;
    private Integer collateralPercent;
    private Integer maxCollateralInputs;

    public DataItem serialize() throws CborSerializationException {
        Map map = new Map();
        try {
            if (this.minFeeA != null) {
                map.put((DataItem)new UnsignedInteger(0L), (DataItem)new UnsignedInteger(this.minFeeA));
            }
            if (this.minFeeB != null) {
                map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnsignedInteger(this.minFeeB));
            }
            if (this.maxBlockSize != null) {
                map.put((DataItem)new UnsignedInteger(2L), (DataItem)new UnsignedInteger((long)this.maxBlockSize.intValue()));
            }
            if (this.maxTxSize != null) {
                map.put((DataItem)new UnsignedInteger(3L), (DataItem)new UnsignedInteger((long)this.maxTxSize.intValue()));
            }
            if (this.maxBlockHeaderSize != null) {
                map.put((DataItem)new UnsignedInteger(4L), (DataItem)new UnsignedInteger((long)this.maxBlockHeaderSize.intValue()));
            }
            if (this.keyDeposit != null) {
                map.put((DataItem)new UnsignedInteger(5L), (DataItem)new UnsignedInteger(this.keyDeposit));
            }
            if (this.poolDeposit != null) {
                map.put((DataItem)new UnsignedInteger(6L), (DataItem)new UnsignedInteger(this.poolDeposit));
            }
            if (this.maxEpoch != null) {
                map.put((DataItem)new UnsignedInteger(7L), (DataItem)new UnsignedInteger((long)this.maxEpoch.intValue()));
            }
            if (this.nOpt != null) {
                map.put((DataItem)new UnsignedInteger(8L), (DataItem)new UnsignedInteger((long)this.nOpt.intValue()));
            }
            if (this.poolPledgeInfluence != null) {
                map.put((DataItem)new UnsignedInteger(9L), (DataItem)new RationalNumber(CborSerializationUtil.bigIntegerToDataItem(this.poolPledgeInfluence.getNumerator()), CborSerializationUtil.bigIntegerToDataItem(this.poolPledgeInfluence.getDenominator())));
            }
            if (this.expansionRate != null) {
                map.put((DataItem)new UnsignedInteger(10L), (DataItem)new RationalNumber(CborSerializationUtil.bigIntegerToDataItem(this.expansionRate.getNumerator()), CborSerializationUtil.bigIntegerToDataItem(this.expansionRate.getDenominator())));
            }
            if (this.treasuryGrowthRate != null) {
                map.put((DataItem)new UnsignedInteger(11L), (DataItem)new RationalNumber(CborSerializationUtil.bigIntegerToDataItem(this.treasuryGrowthRate.getNumerator()), CborSerializationUtil.bigIntegerToDataItem(this.treasuryGrowthRate.getDenominator())));
            }
            if (this.decentralisationConstant != null) {
                map.put((DataItem)new UnsignedInteger(12L), (DataItem)new RationalNumber(CborSerializationUtil.bigIntegerToDataItem(this.decentralisationConstant.getNumerator()), CborSerializationUtil.bigIntegerToDataItem(this.decentralisationConstant.getDenominator())));
            }
            if (this.extraEntropy != null) {
                map.put((DataItem)new UnsignedInteger(13L), this.extraEntropy.serialize());
            }
            if (this.protocolVersion != null) {
                Array protocolVersionArr = new Array();
                protocolVersionArr.add((DataItem)new UnsignedInteger((long)this.protocolVersion.getMajor()));
                protocolVersionArr.add((DataItem)new UnsignedInteger((long)this.protocolVersion.getMinor()));
                map.put((DataItem)new UnsignedInteger(14L), (DataItem)protocolVersionArr);
            }
            if (this.minUtxo != null) {
                map.put((DataItem)new UnsignedInteger(15L), (DataItem)new UnsignedInteger(this.minUtxo));
            }
            if (this.minPoolCost != null) {
                map.put((DataItem)new UnsignedInteger(16L), (DataItem)new UnsignedInteger(this.minPoolCost));
            }
            if (this.adaPerUtxoByte != null) {
                map.put((DataItem)new UnsignedInteger(17L), (DataItem)new UnsignedInteger(this.adaPerUtxoByte));
            }
            if (this.costModels != null) {
                map.put((DataItem)new UnsignedInteger(18L), (DataItem)this.costModels.serialize());
            }
            if (this.executionCosts != null) {
                map.put((DataItem)new UnsignedInteger(19L), this.executionCosts.serialize());
            }
            if (this.maxTxExUnits != null) {
                map.put((DataItem)new UnsignedInteger(20L), (DataItem)this.maxTxExUnits.serialize());
            }
            if (this.maxBlockExUnits != null) {
                map.put((DataItem)new UnsignedInteger(21L), (DataItem)this.maxBlockExUnits.serialize());
            }
            if (this.maxValSize != null) {
                map.put((DataItem)new UnsignedInteger(22L), (DataItem)new UnsignedInteger(this.maxValSize.longValue()));
            }
            if (this.collateralPercent != null) {
                map.put((DataItem)new UnsignedInteger(23L), (DataItem)new UnsignedInteger((long)this.collateralPercent.intValue()));
            }
            if (this.maxCollateralInputs != null) {
                map.put((DataItem)new UnsignedInteger(24L), (DataItem)new UnsignedInteger((long)this.maxCollateralInputs.intValue()));
            }
        }
        catch (Exception e) {
            throw new CborSerializationException("Serialization error", e);
        }
        return map;
    }

    public static ProtocolParamUpdate deserialize(DataItem din) throws CborDeserializationException {
        Map map = (Map)din;
        DataItem itemDI = map.get((DataItem)new UnsignedInteger(0L));
        BigInteger minFeeA = itemDI != null ? CborSerializationUtil.getBigInteger(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(1L));
        BigInteger minFeeB = itemDI != null ? CborSerializationUtil.getBigInteger(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(2L));
        Integer maxBlockSize = itemDI != null ? Integer.valueOf(CborSerializationUtil.toInt(itemDI)) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(3L));
        Integer maxTxSize = itemDI != null ? Integer.valueOf(CborSerializationUtil.toInt(itemDI)) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(4L));
        Integer maxBlockHeaderSize = itemDI != null ? Integer.valueOf(CborSerializationUtil.toInt(itemDI)) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(5L));
        BigInteger keyDeposit = itemDI != null ? CborSerializationUtil.getBigInteger(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(6L));
        BigInteger poolDeposit = itemDI != null ? CborSerializationUtil.getBigInteger(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(7L));
        Integer maxEpoch = itemDI != null ? Integer.valueOf(CborSerializationUtil.toInt(itemDI)) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(8L));
        Integer nOpt = itemDI != null ? Integer.valueOf(CborSerializationUtil.toInt(itemDI)) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(9L));
        Rational poolPledgeInfluence = itemDI != null ? CborSerializationUtil.toRational((RationalNumber)itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(10L));
        UnitInterval expansionRate = itemDI != null ? CborSerializationUtil.toUnitInterval((RationalNumber)itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(11L));
        UnitInterval treasuryGrowthRate = itemDI != null ? CborSerializationUtil.toUnitInterval((RationalNumber)itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(12L));
        UnitInterval decentralizationParam = itemDI != null ? CborSerializationUtil.toUnitInterval((RationalNumber)itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(13L));
        Nonce extraEntropy = itemDI != null ? Nonce.deserialize(itemDI) : null;
        ProtocolVersion protocolVersion = null;
        itemDI = map.get((DataItem)new UnsignedInteger(14L));
        if (itemDI != null) {
            List protocolVersionDIList = ((Array)itemDI).getDataItems();
            int majorVersion = CborSerializationUtil.toInt((DataItem)protocolVersionDIList.get(0));
            int minorVersion = CborSerializationUtil.toInt((DataItem)protocolVersionDIList.get(1));
            protocolVersion = new ProtocolVersion(majorVersion, minorVersion);
        }
        BigInteger minUtxo = (itemDI = map.get((DataItem)new UnsignedInteger(15L))) != null ? CborSerializationUtil.getBigInteger(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(16L));
        BigInteger minPoolCost = itemDI != null ? CborSerializationUtil.getBigInteger(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(17L));
        BigInteger adaPerUtxoBytes = itemDI != null ? CborSerializationUtil.getBigInteger(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(18L));
        CostMdls costMdls = itemDI != null ? CostMdls.deserialize(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(19L));
        ExUnitPrices executionCosts = itemDI != null ? ExUnitPrices.deserialize(itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(20L));
        ExUnits maxTxExUnits = itemDI != null ? ExUnits.deserialize((Array)itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(21L));
        ExUnits maxBlockExUnits = itemDI != null ? ExUnits.deserialize((Array)itemDI) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(22L));
        Long maxValueSize = itemDI != null ? Long.valueOf(CborSerializationUtil.toLong(itemDI)) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(23L));
        Integer collateralPercent = itemDI != null ? Integer.valueOf(CborSerializationUtil.toInt(itemDI)) : null;
        itemDI = map.get((DataItem)new UnsignedInteger(24L));
        Integer maxCollateralPercent = itemDI != null ? Integer.valueOf(CborSerializationUtil.toInt(itemDI)) : null;
        ProtocolParamUpdate protocolParamUpdate = ProtocolParamUpdate.builder().minFeeA(minFeeA).minFeeB(minFeeB).maxBlockSize(maxBlockSize).maxTxSize(maxTxSize).maxBlockHeaderSize(maxBlockHeaderSize).keyDeposit(keyDeposit).poolDeposit(poolDeposit).maxEpoch(maxEpoch).nOpt(nOpt).poolPledgeInfluence(poolPledgeInfluence).expansionRate(expansionRate).treasuryGrowthRate(treasuryGrowthRate).decentralisationConstant(decentralizationParam).extraEntropy(extraEntropy).protocolVersion(protocolVersion).minUtxo(minUtxo).minPoolCost(minPoolCost).adaPerUtxoByte(adaPerUtxoBytes).costModels(costMdls).executionCosts(executionCosts).maxTxExUnits(maxTxExUnits).maxBlockExUnits(maxBlockExUnits).maxValSize(maxValueSize).collateralPercent(collateralPercent).maxCollateralInputs(maxCollateralPercent).build();
        return protocolParamUpdate;
    }

    public static ProtocolParamUpdateBuilder builder() {
        return new ProtocolParamUpdateBuilder();
    }

    public BigInteger getMinFeeA() {
        return this.minFeeA;
    }

    public BigInteger getMinFeeB() {
        return this.minFeeB;
    }

    public Integer getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public Integer getMaxTxSize() {
        return this.maxTxSize;
    }

    public Integer getMaxBlockHeaderSize() {
        return this.maxBlockHeaderSize;
    }

    public BigInteger getKeyDeposit() {
        return this.keyDeposit;
    }

    public BigInteger getPoolDeposit() {
        return this.poolDeposit;
    }

    public Integer getMaxEpoch() {
        return this.maxEpoch;
    }

    public Integer getNOpt() {
        return this.nOpt;
    }

    public Rational getPoolPledgeInfluence() {
        return this.poolPledgeInfluence;
    }

    public UnitInterval getExpansionRate() {
        return this.expansionRate;
    }

    public UnitInterval getTreasuryGrowthRate() {
        return this.treasuryGrowthRate;
    }

    @Deprecated
    public UnitInterval getDecentralisationConstant() {
        return this.decentralisationConstant;
    }

    @Deprecated
    public Nonce getExtraEntropy() {
        return this.extraEntropy;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Deprecated
    public BigInteger getMinUtxo() {
        return this.minUtxo;
    }

    public BigInteger getMinPoolCost() {
        return this.minPoolCost;
    }

    public BigInteger getAdaPerUtxoByte() {
        return this.adaPerUtxoByte;
    }

    public CostMdls getCostModels() {
        return this.costModels;
    }

    public ExUnitPrices getExecutionCosts() {
        return this.executionCosts;
    }

    public ExUnits getMaxTxExUnits() {
        return this.maxTxExUnits;
    }

    public ExUnits getMaxBlockExUnits() {
        return this.maxBlockExUnits;
    }

    public Long getMaxValSize() {
        return this.maxValSize;
    }

    public Integer getCollateralPercent() {
        return this.collateralPercent;
    }

    public Integer getMaxCollateralInputs() {
        return this.maxCollateralInputs;
    }

    public ProtocolParamUpdate(BigInteger minFeeA, BigInteger minFeeB, Integer maxBlockSize, Integer maxTxSize, Integer maxBlockHeaderSize, BigInteger keyDeposit, BigInteger poolDeposit, Integer maxEpoch, Integer nOpt, Rational poolPledgeInfluence, UnitInterval expansionRate, UnitInterval treasuryGrowthRate, UnitInterval decentralisationConstant, Nonce extraEntropy, ProtocolVersion protocolVersion, BigInteger minUtxo, BigInteger minPoolCost, BigInteger adaPerUtxoByte, CostMdls costModels, ExUnitPrices executionCosts, ExUnits maxTxExUnits, ExUnits maxBlockExUnits, Long maxValSize, Integer collateralPercent, Integer maxCollateralInputs) {
        this.minFeeA = minFeeA;
        this.minFeeB = minFeeB;
        this.maxBlockSize = maxBlockSize;
        this.maxTxSize = maxTxSize;
        this.maxBlockHeaderSize = maxBlockHeaderSize;
        this.keyDeposit = keyDeposit;
        this.poolDeposit = poolDeposit;
        this.maxEpoch = maxEpoch;
        this.nOpt = nOpt;
        this.poolPledgeInfluence = poolPledgeInfluence;
        this.expansionRate = expansionRate;
        this.treasuryGrowthRate = treasuryGrowthRate;
        this.decentralisationConstant = decentralisationConstant;
        this.extraEntropy = extraEntropy;
        this.protocolVersion = protocolVersion;
        this.minUtxo = minUtxo;
        this.minPoolCost = minPoolCost;
        this.adaPerUtxoByte = adaPerUtxoByte;
        this.costModels = costModels;
        this.executionCosts = executionCosts;
        this.maxTxExUnits = maxTxExUnits;
        this.maxBlockExUnits = maxBlockExUnits;
        this.maxValSize = maxValSize;
        this.collateralPercent = collateralPercent;
        this.maxCollateralInputs = maxCollateralInputs;
    }

    public ProtocolParamUpdate() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocolParamUpdate)) {
            return false;
        }
        ProtocolParamUpdate other = (ProtocolParamUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxBlockSize = this.getMaxBlockSize();
        Integer other$maxBlockSize = other.getMaxBlockSize();
        if (this$maxBlockSize == null ? other$maxBlockSize != null : !((Object)this$maxBlockSize).equals(other$maxBlockSize)) {
            return false;
        }
        Integer this$maxTxSize = this.getMaxTxSize();
        Integer other$maxTxSize = other.getMaxTxSize();
        if (this$maxTxSize == null ? other$maxTxSize != null : !((Object)this$maxTxSize).equals(other$maxTxSize)) {
            return false;
        }
        Integer this$maxBlockHeaderSize = this.getMaxBlockHeaderSize();
        Integer other$maxBlockHeaderSize = other.getMaxBlockHeaderSize();
        if (this$maxBlockHeaderSize == null ? other$maxBlockHeaderSize != null : !((Object)this$maxBlockHeaderSize).equals(other$maxBlockHeaderSize)) {
            return false;
        }
        Integer this$maxEpoch = this.getMaxEpoch();
        Integer other$maxEpoch = other.getMaxEpoch();
        if (this$maxEpoch == null ? other$maxEpoch != null : !((Object)this$maxEpoch).equals(other$maxEpoch)) {
            return false;
        }
        Integer this$nOpt = this.getNOpt();
        Integer other$nOpt = other.getNOpt();
        if (this$nOpt == null ? other$nOpt != null : !((Object)this$nOpt).equals(other$nOpt)) {
            return false;
        }
        Long this$maxValSize = this.getMaxValSize();
        Long other$maxValSize = other.getMaxValSize();
        if (this$maxValSize == null ? other$maxValSize != null : !((Object)this$maxValSize).equals(other$maxValSize)) {
            return false;
        }
        Integer this$collateralPercent = this.getCollateralPercent();
        Integer other$collateralPercent = other.getCollateralPercent();
        if (this$collateralPercent == null ? other$collateralPercent != null : !((Object)this$collateralPercent).equals(other$collateralPercent)) {
            return false;
        }
        Integer this$maxCollateralInputs = this.getMaxCollateralInputs();
        Integer other$maxCollateralInputs = other.getMaxCollateralInputs();
        if (this$maxCollateralInputs == null ? other$maxCollateralInputs != null : !((Object)this$maxCollateralInputs).equals(other$maxCollateralInputs)) {
            return false;
        }
        BigInteger this$minFeeA = this.getMinFeeA();
        BigInteger other$minFeeA = other.getMinFeeA();
        if (this$minFeeA == null ? other$minFeeA != null : !((Object)this$minFeeA).equals(other$minFeeA)) {
            return false;
        }
        BigInteger this$minFeeB = this.getMinFeeB();
        BigInteger other$minFeeB = other.getMinFeeB();
        if (this$minFeeB == null ? other$minFeeB != null : !((Object)this$minFeeB).equals(other$minFeeB)) {
            return false;
        }
        BigInteger this$keyDeposit = this.getKeyDeposit();
        BigInteger other$keyDeposit = other.getKeyDeposit();
        if (this$keyDeposit == null ? other$keyDeposit != null : !((Object)this$keyDeposit).equals(other$keyDeposit)) {
            return false;
        }
        BigInteger this$poolDeposit = this.getPoolDeposit();
        BigInteger other$poolDeposit = other.getPoolDeposit();
        if (this$poolDeposit == null ? other$poolDeposit != null : !((Object)this$poolDeposit).equals(other$poolDeposit)) {
            return false;
        }
        Rational this$poolPledgeInfluence = this.getPoolPledgeInfluence();
        Rational other$poolPledgeInfluence = other.getPoolPledgeInfluence();
        if (this$poolPledgeInfluence == null ? other$poolPledgeInfluence != null : !((Object)this$poolPledgeInfluence).equals(other$poolPledgeInfluence)) {
            return false;
        }
        UnitInterval this$expansionRate = this.getExpansionRate();
        UnitInterval other$expansionRate = other.getExpansionRate();
        if (this$expansionRate == null ? other$expansionRate != null : !((Object)this$expansionRate).equals(other$expansionRate)) {
            return false;
        }
        UnitInterval this$treasuryGrowthRate = this.getTreasuryGrowthRate();
        UnitInterval other$treasuryGrowthRate = other.getTreasuryGrowthRate();
        if (this$treasuryGrowthRate == null ? other$treasuryGrowthRate != null : !((Object)this$treasuryGrowthRate).equals(other$treasuryGrowthRate)) {
            return false;
        }
        UnitInterval this$decentralisationConstant = this.getDecentralisationConstant();
        UnitInterval other$decentralisationConstant = other.getDecentralisationConstant();
        if (this$decentralisationConstant == null ? other$decentralisationConstant != null : !((Object)this$decentralisationConstant).equals(other$decentralisationConstant)) {
            return false;
        }
        Nonce this$extraEntropy = this.getExtraEntropy();
        Nonce other$extraEntropy = other.getExtraEntropy();
        if (this$extraEntropy == null ? other$extraEntropy != null : !this$extraEntropy.equals(other$extraEntropy)) {
            return false;
        }
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !((Object)this$protocolVersion).equals(other$protocolVersion)) {
            return false;
        }
        BigInteger this$minUtxo = this.getMinUtxo();
        BigInteger other$minUtxo = other.getMinUtxo();
        if (this$minUtxo == null ? other$minUtxo != null : !((Object)this$minUtxo).equals(other$minUtxo)) {
            return false;
        }
        BigInteger this$minPoolCost = this.getMinPoolCost();
        BigInteger other$minPoolCost = other.getMinPoolCost();
        if (this$minPoolCost == null ? other$minPoolCost != null : !((Object)this$minPoolCost).equals(other$minPoolCost)) {
            return false;
        }
        BigInteger this$adaPerUtxoByte = this.getAdaPerUtxoByte();
        BigInteger other$adaPerUtxoByte = other.getAdaPerUtxoByte();
        if (this$adaPerUtxoByte == null ? other$adaPerUtxoByte != null : !((Object)this$adaPerUtxoByte).equals(other$adaPerUtxoByte)) {
            return false;
        }
        CostMdls this$costModels = this.getCostModels();
        CostMdls other$costModels = other.getCostModels();
        if (this$costModels == null ? other$costModels != null : !this$costModels.equals(other$costModels)) {
            return false;
        }
        ExUnitPrices this$executionCosts = this.getExecutionCosts();
        ExUnitPrices other$executionCosts = other.getExecutionCosts();
        if (this$executionCosts == null ? other$executionCosts != null : !((Object)this$executionCosts).equals(other$executionCosts)) {
            return false;
        }
        ExUnits this$maxTxExUnits = this.getMaxTxExUnits();
        ExUnits other$maxTxExUnits = other.getMaxTxExUnits();
        if (this$maxTxExUnits == null ? other$maxTxExUnits != null : !((Object)this$maxTxExUnits).equals(other$maxTxExUnits)) {
            return false;
        }
        ExUnits this$maxBlockExUnits = this.getMaxBlockExUnits();
        ExUnits other$maxBlockExUnits = other.getMaxBlockExUnits();
        return !(this$maxBlockExUnits == null ? other$maxBlockExUnits != null : !((Object)this$maxBlockExUnits).equals(other$maxBlockExUnits));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtocolParamUpdate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxBlockSize = this.getMaxBlockSize();
        result = result * 59 + ($maxBlockSize == null ? 43 : ((Object)$maxBlockSize).hashCode());
        Integer $maxTxSize = this.getMaxTxSize();
        result = result * 59 + ($maxTxSize == null ? 43 : ((Object)$maxTxSize).hashCode());
        Integer $maxBlockHeaderSize = this.getMaxBlockHeaderSize();
        result = result * 59 + ($maxBlockHeaderSize == null ? 43 : ((Object)$maxBlockHeaderSize).hashCode());
        Integer $maxEpoch = this.getMaxEpoch();
        result = result * 59 + ($maxEpoch == null ? 43 : ((Object)$maxEpoch).hashCode());
        Integer $nOpt = this.getNOpt();
        result = result * 59 + ($nOpt == null ? 43 : ((Object)$nOpt).hashCode());
        Long $maxValSize = this.getMaxValSize();
        result = result * 59 + ($maxValSize == null ? 43 : ((Object)$maxValSize).hashCode());
        Integer $collateralPercent = this.getCollateralPercent();
        result = result * 59 + ($collateralPercent == null ? 43 : ((Object)$collateralPercent).hashCode());
        Integer $maxCollateralInputs = this.getMaxCollateralInputs();
        result = result * 59 + ($maxCollateralInputs == null ? 43 : ((Object)$maxCollateralInputs).hashCode());
        BigInteger $minFeeA = this.getMinFeeA();
        result = result * 59 + ($minFeeA == null ? 43 : ((Object)$minFeeA).hashCode());
        BigInteger $minFeeB = this.getMinFeeB();
        result = result * 59 + ($minFeeB == null ? 43 : ((Object)$minFeeB).hashCode());
        BigInteger $keyDeposit = this.getKeyDeposit();
        result = result * 59 + ($keyDeposit == null ? 43 : ((Object)$keyDeposit).hashCode());
        BigInteger $poolDeposit = this.getPoolDeposit();
        result = result * 59 + ($poolDeposit == null ? 43 : ((Object)$poolDeposit).hashCode());
        Rational $poolPledgeInfluence = this.getPoolPledgeInfluence();
        result = result * 59 + ($poolPledgeInfluence == null ? 43 : ((Object)$poolPledgeInfluence).hashCode());
        UnitInterval $expansionRate = this.getExpansionRate();
        result = result * 59 + ($expansionRate == null ? 43 : ((Object)$expansionRate).hashCode());
        UnitInterval $treasuryGrowthRate = this.getTreasuryGrowthRate();
        result = result * 59 + ($treasuryGrowthRate == null ? 43 : ((Object)$treasuryGrowthRate).hashCode());
        UnitInterval $decentralisationConstant = this.getDecentralisationConstant();
        result = result * 59 + ($decentralisationConstant == null ? 43 : ((Object)$decentralisationConstant).hashCode());
        Nonce $extraEntropy = this.getExtraEntropy();
        result = result * 59 + ($extraEntropy == null ? 43 : $extraEntropy.hashCode());
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : ((Object)$protocolVersion).hashCode());
        BigInteger $minUtxo = this.getMinUtxo();
        result = result * 59 + ($minUtxo == null ? 43 : ((Object)$minUtxo).hashCode());
        BigInteger $minPoolCost = this.getMinPoolCost();
        result = result * 59 + ($minPoolCost == null ? 43 : ((Object)$minPoolCost).hashCode());
        BigInteger $adaPerUtxoByte = this.getAdaPerUtxoByte();
        result = result * 59 + ($adaPerUtxoByte == null ? 43 : ((Object)$adaPerUtxoByte).hashCode());
        CostMdls $costModels = this.getCostModels();
        result = result * 59 + ($costModels == null ? 43 : $costModels.hashCode());
        ExUnitPrices $executionCosts = this.getExecutionCosts();
        result = result * 59 + ($executionCosts == null ? 43 : ((Object)$executionCosts).hashCode());
        ExUnits $maxTxExUnits = this.getMaxTxExUnits();
        result = result * 59 + ($maxTxExUnits == null ? 43 : ((Object)$maxTxExUnits).hashCode());
        ExUnits $maxBlockExUnits = this.getMaxBlockExUnits();
        result = result * 59 + ($maxBlockExUnits == null ? 43 : ((Object)$maxBlockExUnits).hashCode());
        return result;
    }

    public String toString() {
        return "ProtocolParamUpdate(minFeeA=" + this.getMinFeeA() + ", minFeeB=" + this.getMinFeeB() + ", maxBlockSize=" + this.getMaxBlockSize() + ", maxTxSize=" + this.getMaxTxSize() + ", maxBlockHeaderSize=" + this.getMaxBlockHeaderSize() + ", keyDeposit=" + this.getKeyDeposit() + ", poolDeposit=" + this.getPoolDeposit() + ", maxEpoch=" + this.getMaxEpoch() + ", nOpt=" + this.getNOpt() + ", poolPledgeInfluence=" + this.getPoolPledgeInfluence() + ", expansionRate=" + this.getExpansionRate() + ", treasuryGrowthRate=" + this.getTreasuryGrowthRate() + ", decentralisationConstant=" + this.getDecentralisationConstant() + ", extraEntropy=" + this.getExtraEntropy() + ", protocolVersion=" + this.getProtocolVersion() + ", minUtxo=" + this.getMinUtxo() + ", minPoolCost=" + this.getMinPoolCost() + ", adaPerUtxoByte=" + this.getAdaPerUtxoByte() + ", costModels=" + this.getCostModels() + ", executionCosts=" + this.getExecutionCosts() + ", maxTxExUnits=" + this.getMaxTxExUnits() + ", maxBlockExUnits=" + this.getMaxBlockExUnits() + ", maxValSize=" + this.getMaxValSize() + ", collateralPercent=" + this.getCollateralPercent() + ", maxCollateralInputs=" + this.getMaxCollateralInputs() + ")";
    }

    public static class ProtocolParamUpdateBuilder {
        private BigInteger minFeeA;
        private BigInteger minFeeB;
        private Integer maxBlockSize;
        private Integer maxTxSize;
        private Integer maxBlockHeaderSize;
        private BigInteger keyDeposit;
        private BigInteger poolDeposit;
        private Integer maxEpoch;
        private Integer nOpt;
        private Rational poolPledgeInfluence;
        private UnitInterval expansionRate;
        private UnitInterval treasuryGrowthRate;
        private UnitInterval decentralisationConstant;
        private Nonce extraEntropy;
        private ProtocolVersion protocolVersion;
        private BigInteger minUtxo;
        private BigInteger minPoolCost;
        private BigInteger adaPerUtxoByte;
        private CostMdls costModels;
        private ExUnitPrices executionCosts;
        private ExUnits maxTxExUnits;
        private ExUnits maxBlockExUnits;
        private Long maxValSize;
        private Integer collateralPercent;
        private Integer maxCollateralInputs;

        ProtocolParamUpdateBuilder() {
        }

        public ProtocolParamUpdateBuilder minFeeA(BigInteger minFeeA) {
            this.minFeeA = minFeeA;
            return this;
        }

        public ProtocolParamUpdateBuilder minFeeB(BigInteger minFeeB) {
            this.minFeeB = minFeeB;
            return this;
        }

        public ProtocolParamUpdateBuilder maxBlockSize(Integer maxBlockSize) {
            this.maxBlockSize = maxBlockSize;
            return this;
        }

        public ProtocolParamUpdateBuilder maxTxSize(Integer maxTxSize) {
            this.maxTxSize = maxTxSize;
            return this;
        }

        public ProtocolParamUpdateBuilder maxBlockHeaderSize(Integer maxBlockHeaderSize) {
            this.maxBlockHeaderSize = maxBlockHeaderSize;
            return this;
        }

        public ProtocolParamUpdateBuilder keyDeposit(BigInteger keyDeposit) {
            this.keyDeposit = keyDeposit;
            return this;
        }

        public ProtocolParamUpdateBuilder poolDeposit(BigInteger poolDeposit) {
            this.poolDeposit = poolDeposit;
            return this;
        }

        public ProtocolParamUpdateBuilder maxEpoch(Integer maxEpoch) {
            this.maxEpoch = maxEpoch;
            return this;
        }

        public ProtocolParamUpdateBuilder nOpt(Integer nOpt) {
            this.nOpt = nOpt;
            return this;
        }

        public ProtocolParamUpdateBuilder poolPledgeInfluence(Rational poolPledgeInfluence) {
            this.poolPledgeInfluence = poolPledgeInfluence;
            return this;
        }

        public ProtocolParamUpdateBuilder expansionRate(UnitInterval expansionRate) {
            this.expansionRate = expansionRate;
            return this;
        }

        public ProtocolParamUpdateBuilder treasuryGrowthRate(UnitInterval treasuryGrowthRate) {
            this.treasuryGrowthRate = treasuryGrowthRate;
            return this;
        }

        @Deprecated
        public ProtocolParamUpdateBuilder decentralisationConstant(UnitInterval decentralisationConstant) {
            this.decentralisationConstant = decentralisationConstant;
            return this;
        }

        @Deprecated
        public ProtocolParamUpdateBuilder extraEntropy(Nonce extraEntropy) {
            this.extraEntropy = extraEntropy;
            return this;
        }

        public ProtocolParamUpdateBuilder protocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        @Deprecated
        public ProtocolParamUpdateBuilder minUtxo(BigInteger minUtxo) {
            this.minUtxo = minUtxo;
            return this;
        }

        public ProtocolParamUpdateBuilder minPoolCost(BigInteger minPoolCost) {
            this.minPoolCost = minPoolCost;
            return this;
        }

        public ProtocolParamUpdateBuilder adaPerUtxoByte(BigInteger adaPerUtxoByte) {
            this.adaPerUtxoByte = adaPerUtxoByte;
            return this;
        }

        public ProtocolParamUpdateBuilder costModels(CostMdls costModels) {
            this.costModels = costModels;
            return this;
        }

        public ProtocolParamUpdateBuilder executionCosts(ExUnitPrices executionCosts) {
            this.executionCosts = executionCosts;
            return this;
        }

        public ProtocolParamUpdateBuilder maxTxExUnits(ExUnits maxTxExUnits) {
            this.maxTxExUnits = maxTxExUnits;
            return this;
        }

        public ProtocolParamUpdateBuilder maxBlockExUnits(ExUnits maxBlockExUnits) {
            this.maxBlockExUnits = maxBlockExUnits;
            return this;
        }

        public ProtocolParamUpdateBuilder maxValSize(Long maxValSize) {
            this.maxValSize = maxValSize;
            return this;
        }

        public ProtocolParamUpdateBuilder collateralPercent(Integer collateralPercent) {
            this.collateralPercent = collateralPercent;
            return this;
        }

        public ProtocolParamUpdateBuilder maxCollateralInputs(Integer maxCollateralInputs) {
            this.maxCollateralInputs = maxCollateralInputs;
            return this;
        }

        public ProtocolParamUpdate build() {
            return new ProtocolParamUpdate(this.minFeeA, this.minFeeB, this.maxBlockSize, this.maxTxSize, this.maxBlockHeaderSize, this.keyDeposit, this.poolDeposit, this.maxEpoch, this.nOpt, this.poolPledgeInfluence, this.expansionRate, this.treasuryGrowthRate, this.decentralisationConstant, this.extraEntropy, this.protocolVersion, this.minUtxo, this.minPoolCost, this.adaPerUtxoByte, this.costModels, this.executionCosts, this.maxTxExUnits, this.maxBlockExUnits, this.maxValSize, this.collateralPercent, this.maxCollateralInputs);
        }

        public String toString() {
            return "ProtocolParamUpdate.ProtocolParamUpdateBuilder(minFeeA=" + this.minFeeA + ", minFeeB=" + this.minFeeB + ", maxBlockSize=" + this.maxBlockSize + ", maxTxSize=" + this.maxTxSize + ", maxBlockHeaderSize=" + this.maxBlockHeaderSize + ", keyDeposit=" + this.keyDeposit + ", poolDeposit=" + this.poolDeposit + ", maxEpoch=" + this.maxEpoch + ", nOpt=" + this.nOpt + ", poolPledgeInfluence=" + this.poolPledgeInfluence + ", expansionRate=" + this.expansionRate + ", treasuryGrowthRate=" + this.treasuryGrowthRate + ", decentralisationConstant=" + this.decentralisationConstant + ", extraEntropy=" + this.extraEntropy + ", protocolVersion=" + this.protocolVersion + ", minUtxo=" + this.minUtxo + ", minPoolCost=" + this.minPoolCost + ", adaPerUtxoByte=" + this.adaPerUtxoByte + ", costModels=" + this.costModels + ", executionCosts=" + this.executionCosts + ", maxTxExUnits=" + this.maxTxExUnits + ", maxBlockExUnits=" + this.maxBlockExUnits + ", maxValSize=" + this.maxValSize + ", collateralPercent=" + this.collateralPercent + ", maxCollateralInputs=" + this.maxCollateralInputs + ")";
        }
    }
}

