/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.NetworkId;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Update;
import com.bloxbean.cardano.client.transaction.spec.Withdrawal;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TransactionBody {
    private List<TransactionInput> inputs;
    private List<TransactionOutput> outputs;
    private BigInteger fee;
    private long ttl;
    private List<Certificate> certs;
    private List<Withdrawal> withdrawals;
    private Update update;
    private byte[] auxiliaryDataHash;
    private long validityStartInterval;
    private List<MultiAsset> mint;
    private byte[] scriptDataHash;
    private List<TransactionInput> collateral;
    private List<byte[]> requiredSigners;
    private NetworkId networkId;
    private TransactionOutput collateralReturn;
    private BigInteger totalCollateral;
    private List<TransactionInput> referenceInputs;

    public Map serialize() throws CborSerializationException, AddressExcepion {
        Array input;
        Map bodyMap = new Map();
        Array inputsArray = new Array();
        for (TransactionInput transactionInput : this.inputs) {
            Array input2 = transactionInput.serialize();
            inputsArray.add((DataItem)input2);
        }
        bodyMap.put((DataItem)new UnsignedInteger(0L), (DataItem)inputsArray);
        Array outputsArray = new Array();
        for (TransactionOutput to : this.outputs) {
            DataItem output = to.serialize();
            outputsArray.add(output);
        }
        bodyMap.put((DataItem)new UnsignedInteger(1L), (DataItem)outputsArray);
        if (this.fee == null) {
            throw new CborSerializationException("Fee cannot be null");
        }
        bodyMap.put((DataItem)new UnsignedInteger(2L), (DataItem)new UnsignedInteger(this.fee));
        if (this.ttl != 0L) {
            bodyMap.put((DataItem)new UnsignedInteger(3L), (DataItem)new UnsignedInteger(this.ttl));
        }
        if (this.certs != null && this.certs.size() > 0) {
            Array array = new Array();
            for (Certificate cert : this.certs) {
                array.add((DataItem)cert.serialize());
            }
            bodyMap.put((DataItem)new UnsignedInteger(4L), (DataItem)array);
        }
        if (this.withdrawals != null && this.withdrawals.size() > 0) {
            Map map = new Map();
            for (Withdrawal withdrawal : this.withdrawals) {
                withdrawal.serialize(map);
            }
            bodyMap.put((DataItem)new UnsignedInteger(5L), (DataItem)map);
        }
        if (this.update != null) {
            bodyMap.put((DataItem)new UnsignedInteger(6L), this.update.serialize());
        }
        if (this.auxiliaryDataHash != null) {
            bodyMap.put((DataItem)new UnsignedInteger(7L), (DataItem)new ByteString(this.auxiliaryDataHash));
        }
        if (this.validityStartInterval != 0L) {
            bodyMap.put((DataItem)new UnsignedInteger(8L), (DataItem)new UnsignedInteger(this.validityStartInterval));
        }
        if (this.mint != null && this.mint.size() > 0) {
            Map map = new Map();
            for (MultiAsset multiAsset : this.mint) {
                multiAsset.serialize(map);
            }
            bodyMap.put((DataItem)new UnsignedInteger(9L), (DataItem)map);
        }
        if (this.scriptDataHash != null) {
            bodyMap.put((DataItem)new UnsignedInteger(11L), (DataItem)new ByteString(this.scriptDataHash));
        }
        if (this.collateral != null && this.collateral.size() > 0) {
            Array array = new Array();
            for (TransactionInput ti : this.collateral) {
                input = ti.serialize();
                array.add((DataItem)input);
            }
            bodyMap.put((DataItem)new UnsignedInteger(13L), (DataItem)array);
        }
        if (this.requiredSigners != null && this.requiredSigners.size() > 0) {
            Array array = new Array();
            for (byte[] requiredSigner : this.requiredSigners) {
                array.add((DataItem)new ByteString(requiredSigner));
            }
            bodyMap.put((DataItem)new UnsignedInteger(14L), (DataItem)array);
        }
        if (this.networkId != null) {
            switch (this.networkId) {
                case TESTNET: {
                    bodyMap.put((DataItem)new UnsignedInteger(15L), (DataItem)new UnsignedInteger(0L));
                    break;
                }
                case MAINNET: {
                    bodyMap.put((DataItem)new UnsignedInteger(15L), (DataItem)new UnsignedInteger(1L));
                }
            }
        }
        if (this.collateralReturn != null) {
            bodyMap.put((DataItem)new UnsignedInteger(16L), this.collateralReturn.serialize());
        }
        if (this.totalCollateral != null) {
            bodyMap.put((DataItem)new UnsignedInteger(17L), (DataItem)new UnsignedInteger(this.totalCollateral));
        }
        if (this.referenceInputs != null && this.referenceInputs.size() > 0) {
            Array array = new Array();
            for (TransactionInput ti : this.referenceInputs) {
                input = ti.serialize();
                array.add((DataItem)input);
            }
            bodyMap.put((DataItem)new UnsignedInteger(18L), (DataItem)array);
        }
        return bodyMap;
    }

    public static TransactionBody deserialize(Map bodyMap) throws CborDeserializationException {
        Array referenceInputsArray;
        UnsignedInteger totalCollateralUI;
        DataItem collateralReturnDI;
        UnsignedInteger networkIdUI;
        Array requiredSignerArray;
        Array collateralArray;
        ByteString scriptDataHashBS;
        Map mintMap;
        UnsignedInteger validityStartIntervalUI;
        ByteString metadataHashBS;
        DataItem updateDI;
        Map withdrawalMap;
        Array certArray;
        UnsignedInteger ttlUI;
        TransactionBody transactionBody = new TransactionBody();
        Array inputArray = (Array)bodyMap.get((DataItem)new UnsignedInteger(0L));
        ArrayList<TransactionInput> inputs = new ArrayList<TransactionInput>();
        for (DataItem inputItem : inputArray.getDataItems()) {
            if (inputItem == SimpleValue.BREAK) continue;
            TransactionInput ti = TransactionInput.deserialize((Array)inputItem);
            inputs.add(ti);
        }
        transactionBody.setInputs(inputs);
        Array outputArray = (Array)bodyMap.get((DataItem)new UnsignedInteger(1L));
        ArrayList<TransactionOutput> outputs = new ArrayList<TransactionOutput>();
        for (DataItem ouptutItem : outputArray.getDataItems()) {
            if (ouptutItem == SimpleValue.BREAK) continue;
            TransactionOutput to = TransactionOutput.deserialize(ouptutItem);
            outputs.add(to);
        }
        transactionBody.setOutputs(outputs);
        UnsignedInteger feeUI = (UnsignedInteger)bodyMap.get((DataItem)new UnsignedInteger(2L));
        if (feeUI != null) {
            transactionBody.setFee(feeUI.getValue());
        }
        if ((ttlUI = (UnsignedInteger)bodyMap.get((DataItem)new UnsignedInteger(3L))) != null) {
            transactionBody.setTtl(ttlUI.getValue().longValue());
        }
        if ((certArray = (Array)bodyMap.get((DataItem)new UnsignedInteger(4L))) != null && certArray.getDataItems() != null && certArray.getDataItems().size() > 0) {
            for (DataItem dataItem : certArray.getDataItems()) {
                if (dataItem == SimpleValue.BREAK) continue;
                Certificate cert = Certificate.deserialize((Array)dataItem);
                transactionBody.getCerts().add(cert);
            }
        }
        if ((withdrawalMap = (Map)bodyMap.get((DataItem)new UnsignedInteger(5L))) != null && withdrawalMap.getKeys() != null && withdrawalMap.getKeys().size() > 0) {
            Collection addrKeys = withdrawalMap.getKeys();
            for (DataItem addrKey : addrKeys) {
                Withdrawal withdrawal = Withdrawal.deserialize(withdrawalMap, addrKey);
                transactionBody.getWithdrawals().add(withdrawal);
            }
        }
        if ((updateDI = bodyMap.get((DataItem)new UnsignedInteger(6L))) != null) {
            Update update = Update.deserialize(updateDI);
            transactionBody.setUpdate(update);
        }
        if ((metadataHashBS = (ByteString)bodyMap.get((DataItem)new UnsignedInteger(7L))) != null) {
            transactionBody.setAuxiliaryDataHash(metadataHashBS.getBytes());
        }
        if ((validityStartIntervalUI = (UnsignedInteger)bodyMap.get((DataItem)new UnsignedInteger(8L))) != null) {
            transactionBody.setValidityStartInterval(validityStartIntervalUI.getValue().longValue());
        }
        if ((mintMap = (Map)bodyMap.get((DataItem)new UnsignedInteger(9L))) != null) {
            Collection mintDataItems = mintMap.getKeys();
            for (DataItem multiAssetKey : mintDataItems) {
                MultiAsset ma = MultiAsset.deserialize(mintMap, multiAssetKey);
                transactionBody.getMint().add(ma);
            }
        }
        if ((scriptDataHashBS = (ByteString)bodyMap.get((DataItem)new UnsignedInteger(11L))) != null) {
            transactionBody.setScriptDataHash(scriptDataHashBS.getBytes());
        }
        if ((collateralArray = (Array)bodyMap.get((DataItem)new UnsignedInteger(13L))) != null) {
            ArrayList<TransactionInput> collateral = new ArrayList<TransactionInput>();
            for (Object inputItem : collateralArray.getDataItems()) {
                if (inputItem == SimpleValue.BREAK) continue;
                TransactionInput ti = TransactionInput.deserialize((Array)inputItem);
                collateral.add(ti);
            }
            transactionBody.setCollateral(collateral);
        }
        if ((requiredSignerArray = (Array)bodyMap.get((DataItem)new UnsignedInteger(14L))) != null) {
            ArrayList<byte[]> requiredSigners = new ArrayList<byte[]>();
            for (DataItem requiredSigDI : requiredSignerArray.getDataItems()) {
                if (requiredSigDI == SimpleValue.BREAK) continue;
                ByteString requiredSigBS = (ByteString)requiredSigDI;
                requiredSigners.add(requiredSigBS.getBytes());
            }
            transactionBody.setRequiredSigners(requiredSigners);
        }
        if ((networkIdUI = (UnsignedInteger)bodyMap.get((DataItem)new UnsignedInteger(15L))) != null) {
            int networkIdInt = networkIdUI.getValue().intValue();
            if (networkIdInt == 0) {
                transactionBody.setNetworkId(NetworkId.TESTNET);
            } else if (networkIdInt == 1) {
                transactionBody.setNetworkId(NetworkId.MAINNET);
            } else {
                throw new CborDeserializationException("Invalid networkId value : " + networkIdInt);
            }
        }
        if ((collateralReturnDI = bodyMap.get((DataItem)new UnsignedInteger(16L))) != null) {
            TransactionOutput collateralReturn = TransactionOutput.deserialize(collateralReturnDI);
            transactionBody.setCollateralReturn(collateralReturn);
        }
        if ((totalCollateralUI = (UnsignedInteger)bodyMap.get((DataItem)new UnsignedInteger(17L))) != null) {
            transactionBody.setTotalCollateral(totalCollateralUI.getValue());
        }
        if ((referenceInputsArray = (Array)bodyMap.get((DataItem)new UnsignedInteger(18L))) != null) {
            ArrayList<TransactionInput> referenceInputs = new ArrayList<TransactionInput>();
            for (DataItem inputItem : referenceInputsArray.getDataItems()) {
                if (inputItem == SimpleValue.BREAK) continue;
                TransactionInput ti = TransactionInput.deserialize((Array)inputItem);
                referenceInputs.add(ti);
            }
            transactionBody.setReferenceInputs(referenceInputs);
        }
        return transactionBody;
    }

    private static List<TransactionInput> $default$inputs() {
        return new ArrayList<TransactionInput>();
    }

    private static List<TransactionOutput> $default$outputs() {
        return new ArrayList<TransactionOutput>();
    }

    private static BigInteger $default$fee() {
        return BigInteger.ZERO;
    }

    private static List<Certificate> $default$certs() {
        return new ArrayList<Certificate>();
    }

    private static List<Withdrawal> $default$withdrawals() {
        return new ArrayList<Withdrawal>();
    }

    private static List<MultiAsset> $default$mint() {
        return new ArrayList<MultiAsset>();
    }

    private static List<TransactionInput> $default$collateral() {
        return new ArrayList<TransactionInput>();
    }

    private static List<byte[]> $default$requiredSigners() {
        return new ArrayList<byte[]>();
    }

    private static List<TransactionInput> $default$referenceInputs() {
        return new ArrayList<TransactionInput>();
    }

    public static TransactionBodyBuilder builder() {
        return new TransactionBodyBuilder();
    }

    public List<TransactionInput> getInputs() {
        return this.inputs;
    }

    public List<TransactionOutput> getOutputs() {
        return this.outputs;
    }

    public BigInteger getFee() {
        return this.fee;
    }

    public long getTtl() {
        return this.ttl;
    }

    public List<Certificate> getCerts() {
        return this.certs;
    }

    public List<Withdrawal> getWithdrawals() {
        return this.withdrawals;
    }

    public Update getUpdate() {
        return this.update;
    }

    public byte[] getAuxiliaryDataHash() {
        return this.auxiliaryDataHash;
    }

    public long getValidityStartInterval() {
        return this.validityStartInterval;
    }

    public List<MultiAsset> getMint() {
        return this.mint;
    }

    public byte[] getScriptDataHash() {
        return this.scriptDataHash;
    }

    public List<TransactionInput> getCollateral() {
        return this.collateral;
    }

    public List<byte[]> getRequiredSigners() {
        return this.requiredSigners;
    }

    public NetworkId getNetworkId() {
        return this.networkId;
    }

    public TransactionOutput getCollateralReturn() {
        return this.collateralReturn;
    }

    public BigInteger getTotalCollateral() {
        return this.totalCollateral;
    }

    public List<TransactionInput> getReferenceInputs() {
        return this.referenceInputs;
    }

    public void setInputs(List<TransactionInput> inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(List<TransactionOutput> outputs) {
        this.outputs = outputs;
    }

    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setCerts(List<Certificate> certs) {
        this.certs = certs;
    }

    public void setWithdrawals(List<Withdrawal> withdrawals) {
        this.withdrawals = withdrawals;
    }

    public void setUpdate(Update update) {
        this.update = update;
    }

    public void setAuxiliaryDataHash(byte[] auxiliaryDataHash) {
        this.auxiliaryDataHash = auxiliaryDataHash;
    }

    public void setValidityStartInterval(long validityStartInterval) {
        this.validityStartInterval = validityStartInterval;
    }

    public void setMint(List<MultiAsset> mint) {
        this.mint = mint;
    }

    public void setScriptDataHash(byte[] scriptDataHash) {
        this.scriptDataHash = scriptDataHash;
    }

    public void setCollateral(List<TransactionInput> collateral) {
        this.collateral = collateral;
    }

    public void setRequiredSigners(List<byte[]> requiredSigners) {
        this.requiredSigners = requiredSigners;
    }

    public void setNetworkId(NetworkId networkId) {
        this.networkId = networkId;
    }

    public void setCollateralReturn(TransactionOutput collateralReturn) {
        this.collateralReturn = collateralReturn;
    }

    public void setTotalCollateral(BigInteger totalCollateral) {
        this.totalCollateral = totalCollateral;
    }

    public void setReferenceInputs(List<TransactionInput> referenceInputs) {
        this.referenceInputs = referenceInputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionBody)) {
            return false;
        }
        TransactionBody other = (TransactionBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        if (this.getValidityStartInterval() != other.getValidityStartInterval()) {
            return false;
        }
        List<TransactionInput> this$inputs = this.getInputs();
        List<TransactionInput> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<TransactionOutput> this$outputs = this.getOutputs();
        List<TransactionOutput> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        BigInteger this$fee = this.getFee();
        BigInteger other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        List<Certificate> this$certs = this.getCerts();
        List<Certificate> other$certs = other.getCerts();
        if (this$certs == null ? other$certs != null : !((Object)this$certs).equals(other$certs)) {
            return false;
        }
        List<Withdrawal> this$withdrawals = this.getWithdrawals();
        List<Withdrawal> other$withdrawals = other.getWithdrawals();
        if (this$withdrawals == null ? other$withdrawals != null : !((Object)this$withdrawals).equals(other$withdrawals)) {
            return false;
        }
        Update this$update = this.getUpdate();
        Update other$update = other.getUpdate();
        if (this$update == null ? other$update != null : !this$update.equals(other$update)) {
            return false;
        }
        if (!Arrays.equals(this.getAuxiliaryDataHash(), other.getAuxiliaryDataHash())) {
            return false;
        }
        List<MultiAsset> this$mint = this.getMint();
        List<MultiAsset> other$mint = other.getMint();
        if (this$mint == null ? other$mint != null : !((Object)this$mint).equals(other$mint)) {
            return false;
        }
        if (!Arrays.equals(this.getScriptDataHash(), other.getScriptDataHash())) {
            return false;
        }
        List<TransactionInput> this$collateral = this.getCollateral();
        List<TransactionInput> other$collateral = other.getCollateral();
        if (this$collateral == null ? other$collateral != null : !((Object)this$collateral).equals(other$collateral)) {
            return false;
        }
        List<byte[]> this$requiredSigners = this.getRequiredSigners();
        List<byte[]> other$requiredSigners = other.getRequiredSigners();
        if (this$requiredSigners == null ? other$requiredSigners != null : !((Object)this$requiredSigners).equals(other$requiredSigners)) {
            return false;
        }
        NetworkId this$networkId = this.getNetworkId();
        NetworkId other$networkId = other.getNetworkId();
        if (this$networkId == null ? other$networkId != null : !((Object)((Object)this$networkId)).equals((Object)other$networkId)) {
            return false;
        }
        TransactionOutput this$collateralReturn = this.getCollateralReturn();
        TransactionOutput other$collateralReturn = other.getCollateralReturn();
        if (this$collateralReturn == null ? other$collateralReturn != null : !((Object)this$collateralReturn).equals(other$collateralReturn)) {
            return false;
        }
        BigInteger this$totalCollateral = this.getTotalCollateral();
        BigInteger other$totalCollateral = other.getTotalCollateral();
        if (this$totalCollateral == null ? other$totalCollateral != null : !((Object)this$totalCollateral).equals(other$totalCollateral)) {
            return false;
        }
        List<TransactionInput> this$referenceInputs = this.getReferenceInputs();
        List<TransactionInput> other$referenceInputs = other.getReferenceInputs();
        return !(this$referenceInputs == null ? other$referenceInputs != null : !((Object)this$referenceInputs).equals(other$referenceInputs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        long $validityStartInterval = this.getValidityStartInterval();
        result = result * 59 + (int)($validityStartInterval >>> 32 ^ $validityStartInterval);
        List<TransactionInput> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<TransactionOutput> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        BigInteger $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        List<Certificate> $certs = this.getCerts();
        result = result * 59 + ($certs == null ? 43 : ((Object)$certs).hashCode());
        List<Withdrawal> $withdrawals = this.getWithdrawals();
        result = result * 59 + ($withdrawals == null ? 43 : ((Object)$withdrawals).hashCode());
        Update $update = this.getUpdate();
        result = result * 59 + ($update == null ? 43 : $update.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAuxiliaryDataHash());
        List<MultiAsset> $mint = this.getMint();
        result = result * 59 + ($mint == null ? 43 : ((Object)$mint).hashCode());
        result = result * 59 + Arrays.hashCode(this.getScriptDataHash());
        List<TransactionInput> $collateral = this.getCollateral();
        result = result * 59 + ($collateral == null ? 43 : ((Object)$collateral).hashCode());
        List<byte[]> $requiredSigners = this.getRequiredSigners();
        result = result * 59 + ($requiredSigners == null ? 43 : ((Object)$requiredSigners).hashCode());
        NetworkId $networkId = this.getNetworkId();
        result = result * 59 + ($networkId == null ? 43 : ((Object)((Object)$networkId)).hashCode());
        TransactionOutput $collateralReturn = this.getCollateralReturn();
        result = result * 59 + ($collateralReturn == null ? 43 : ((Object)$collateralReturn).hashCode());
        BigInteger $totalCollateral = this.getTotalCollateral();
        result = result * 59 + ($totalCollateral == null ? 43 : ((Object)$totalCollateral).hashCode());
        List<TransactionInput> $referenceInputs = this.getReferenceInputs();
        result = result * 59 + ($referenceInputs == null ? 43 : ((Object)$referenceInputs).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionBody(inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", fee=" + this.getFee() + ", ttl=" + this.getTtl() + ", certs=" + this.getCerts() + ", withdrawals=" + this.getWithdrawals() + ", update=" + this.getUpdate() + ", auxiliaryDataHash=" + Arrays.toString(this.getAuxiliaryDataHash()) + ", validityStartInterval=" + this.getValidityStartInterval() + ", mint=" + this.getMint() + ", scriptDataHash=" + Arrays.toString(this.getScriptDataHash()) + ", collateral=" + this.getCollateral() + ", requiredSigners=" + this.getRequiredSigners() + ", networkId=" + this.getNetworkId() + ", collateralReturn=" + this.getCollateralReturn() + ", totalCollateral=" + this.getTotalCollateral() + ", referenceInputs=" + this.getReferenceInputs() + ")";
    }

    public TransactionBody(List<TransactionInput> inputs, List<TransactionOutput> outputs, BigInteger fee, long ttl, List<Certificate> certs, List<Withdrawal> withdrawals, Update update, byte[] auxiliaryDataHash, long validityStartInterval, List<MultiAsset> mint, byte[] scriptDataHash, List<TransactionInput> collateral, List<byte[]> requiredSigners, NetworkId networkId, TransactionOutput collateralReturn, BigInteger totalCollateral, List<TransactionInput> referenceInputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.fee = fee;
        this.ttl = ttl;
        this.certs = certs;
        this.withdrawals = withdrawals;
        this.update = update;
        this.auxiliaryDataHash = auxiliaryDataHash;
        this.validityStartInterval = validityStartInterval;
        this.mint = mint;
        this.scriptDataHash = scriptDataHash;
        this.collateral = collateral;
        this.requiredSigners = requiredSigners;
        this.networkId = networkId;
        this.collateralReturn = collateralReturn;
        this.totalCollateral = totalCollateral;
        this.referenceInputs = referenceInputs;
    }

    public TransactionBody() {
        this.inputs = TransactionBody.$default$inputs();
        this.outputs = TransactionBody.$default$outputs();
        this.fee = TransactionBody.$default$fee();
        this.certs = TransactionBody.$default$certs();
        this.withdrawals = TransactionBody.$default$withdrawals();
        this.mint = TransactionBody.$default$mint();
        this.collateral = TransactionBody.$default$collateral();
        this.requiredSigners = TransactionBody.$default$requiredSigners();
        this.referenceInputs = TransactionBody.$default$referenceInputs();
    }

    public static class TransactionBodyBuilder {
        private boolean inputs$set;
        private List<TransactionInput> inputs$value;
        private boolean outputs$set;
        private List<TransactionOutput> outputs$value;
        private boolean fee$set;
        private BigInteger fee$value;
        private long ttl;
        private boolean certs$set;
        private List<Certificate> certs$value;
        private boolean withdrawals$set;
        private List<Withdrawal> withdrawals$value;
        private Update update;
        private byte[] auxiliaryDataHash;
        private long validityStartInterval;
        private boolean mint$set;
        private List<MultiAsset> mint$value;
        private byte[] scriptDataHash;
        private boolean collateral$set;
        private List<TransactionInput> collateral$value;
        private boolean requiredSigners$set;
        private List<byte[]> requiredSigners$value;
        private NetworkId networkId;
        private TransactionOutput collateralReturn;
        private BigInteger totalCollateral;
        private boolean referenceInputs$set;
        private List<TransactionInput> referenceInputs$value;

        TransactionBodyBuilder() {
        }

        public TransactionBodyBuilder inputs(List<TransactionInput> inputs) {
            this.inputs$value = inputs;
            this.inputs$set = true;
            return this;
        }

        public TransactionBodyBuilder outputs(List<TransactionOutput> outputs) {
            this.outputs$value = outputs;
            this.outputs$set = true;
            return this;
        }

        public TransactionBodyBuilder fee(BigInteger fee) {
            this.fee$value = fee;
            this.fee$set = true;
            return this;
        }

        public TransactionBodyBuilder ttl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public TransactionBodyBuilder certs(List<Certificate> certs) {
            this.certs$value = certs;
            this.certs$set = true;
            return this;
        }

        public TransactionBodyBuilder withdrawals(List<Withdrawal> withdrawals) {
            this.withdrawals$value = withdrawals;
            this.withdrawals$set = true;
            return this;
        }

        public TransactionBodyBuilder update(Update update) {
            this.update = update;
            return this;
        }

        public TransactionBodyBuilder auxiliaryDataHash(byte[] auxiliaryDataHash) {
            this.auxiliaryDataHash = auxiliaryDataHash;
            return this;
        }

        public TransactionBodyBuilder validityStartInterval(long validityStartInterval) {
            this.validityStartInterval = validityStartInterval;
            return this;
        }

        public TransactionBodyBuilder mint(List<MultiAsset> mint) {
            this.mint$value = mint;
            this.mint$set = true;
            return this;
        }

        public TransactionBodyBuilder scriptDataHash(byte[] scriptDataHash) {
            this.scriptDataHash = scriptDataHash;
            return this;
        }

        public TransactionBodyBuilder collateral(List<TransactionInput> collateral) {
            this.collateral$value = collateral;
            this.collateral$set = true;
            return this;
        }

        public TransactionBodyBuilder requiredSigners(List<byte[]> requiredSigners) {
            this.requiredSigners$value = requiredSigners;
            this.requiredSigners$set = true;
            return this;
        }

        public TransactionBodyBuilder networkId(NetworkId networkId) {
            this.networkId = networkId;
            return this;
        }

        public TransactionBodyBuilder collateralReturn(TransactionOutput collateralReturn) {
            this.collateralReturn = collateralReturn;
            return this;
        }

        public TransactionBodyBuilder totalCollateral(BigInteger totalCollateral) {
            this.totalCollateral = totalCollateral;
            return this;
        }

        public TransactionBodyBuilder referenceInputs(List<TransactionInput> referenceInputs) {
            this.referenceInputs$value = referenceInputs;
            this.referenceInputs$set = true;
            return this;
        }

        public TransactionBody build() {
            List<TransactionInput> inputs$value = this.inputs$value;
            if (!this.inputs$set) {
                inputs$value = TransactionBody.$default$inputs();
            }
            List<TransactionOutput> outputs$value = this.outputs$value;
            if (!this.outputs$set) {
                outputs$value = TransactionBody.$default$outputs();
            }
            BigInteger fee$value = this.fee$value;
            if (!this.fee$set) {
                fee$value = TransactionBody.$default$fee();
            }
            List<Certificate> certs$value = this.certs$value;
            if (!this.certs$set) {
                certs$value = TransactionBody.$default$certs();
            }
            List<Withdrawal> withdrawals$value = this.withdrawals$value;
            if (!this.withdrawals$set) {
                withdrawals$value = TransactionBody.$default$withdrawals();
            }
            List<MultiAsset> mint$value = this.mint$value;
            if (!this.mint$set) {
                mint$value = TransactionBody.$default$mint();
            }
            List<TransactionInput> collateral$value = this.collateral$value;
            if (!this.collateral$set) {
                collateral$value = TransactionBody.$default$collateral();
            }
            List<byte[]> requiredSigners$value = this.requiredSigners$value;
            if (!this.requiredSigners$set) {
                requiredSigners$value = TransactionBody.$default$requiredSigners();
            }
            List<TransactionInput> referenceInputs$value = this.referenceInputs$value;
            if (!this.referenceInputs$set) {
                referenceInputs$value = TransactionBody.$default$referenceInputs();
            }
            return new TransactionBody(inputs$value, outputs$value, fee$value, this.ttl, certs$value, withdrawals$value, this.update, this.auxiliaryDataHash, this.validityStartInterval, mint$value, this.scriptDataHash, collateral$value, requiredSigners$value, this.networkId, this.collateralReturn, this.totalCollateral, referenceInputs$value);
        }

        public String toString() {
            return "TransactionBody.TransactionBodyBuilder(inputs$value=" + this.inputs$value + ", outputs$value=" + this.outputs$value + ", fee$value=" + this.fee$value + ", ttl=" + this.ttl + ", certs$value=" + this.certs$value + ", withdrawals$value=" + this.withdrawals$value + ", update=" + this.update + ", auxiliaryDataHash=" + Arrays.toString(this.auxiliaryDataHash) + ", validityStartInterval=" + this.validityStartInterval + ", mint$value=" + this.mint$value + ", scriptDataHash=" + Arrays.toString(this.scriptDataHash) + ", collateral$value=" + this.collateral$value + ", requiredSigners$value=" + this.requiredSigners$value + ", networkId=" + this.networkId + ", collateralReturn=" + this.collateralReturn + ", totalCollateral=" + this.totalCollateral + ", referenceInputs$value=" + this.referenceInputs$value + ")";
        }
    }
}

