/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.Tag;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.util.AddressUtil;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.PlutusData;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.transaction.spec.script.Script;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class TransactionOutput {
    private String address;
    private Value value;
    private byte[] datumHash;
    private PlutusData inlineDatum;
    private byte[] scriptRef;

    public TransactionOutput(String address, Value value) {
        this.address = address;
        this.value = value;
    }

    public void setScriptRef(byte[] scriptRef) {
        this.scriptRef = scriptRef;
    }

    public void setScriptRef(Script script) {
        if (script == null) {
            return;
        }
        try {
            this.scriptRef = script.scriptRefBytes();
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException(e);
        }
    }

    public DataItem serialize() throws CborSerializationException, AddressExcepion {
        if (this.inlineDatum == null && this.scriptRef == null) {
            return this.serializeAlonzo();
        }
        return this.serializePostAlonzo();
    }

    private Map serializePostAlonzo() throws AddressExcepion, CborSerializationException {
        Map map = new Map();
        byte[] addressByte = AddressUtil.addressToBytes(this.address);
        map.put((DataItem)new UnsignedInteger(0L), (DataItem)new ByteString(addressByte));
        if (this.value == null) {
            throw new CborSerializationException("Value cannot be null");
        }
        if (this.value.getMultiAssets() != null && this.value.getMultiAssets().size() > 0) {
            Array coinAssetArray = new Array();
            if (this.value.getCoin() != null) {
                if (this.value.getCoin().compareTo(BigInteger.ZERO) == 0 || this.value.getCoin().compareTo(BigInteger.ZERO) == 1) {
                    coinAssetArray.add((DataItem)new UnsignedInteger(this.value.getCoin()));
                } else {
                    coinAssetArray.add((DataItem)new NegativeInteger(this.value.getCoin()));
                }
            } else {
                coinAssetArray.add((DataItem)new UnsignedInteger(BigInteger.ZERO));
            }
            Map valueMap = this.value.serialize();
            coinAssetArray.add((DataItem)valueMap);
            map.put((DataItem)new UnsignedInteger(1L), (DataItem)coinAssetArray);
        } else if (this.value.getCoin() != null) {
            if (this.value.getCoin().compareTo(BigInteger.ZERO) == 0 || this.value.getCoin().compareTo(BigInteger.ZERO) == 1) {
                map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnsignedInteger(this.value.getCoin()));
            } else {
                map.put((DataItem)new UnsignedInteger(1L), (DataItem)new NegativeInteger(this.value.getCoin()));
            }
        } else {
            map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnsignedInteger(BigInteger.ZERO));
        }
        if (this.datumHash != null && this.inlineDatum != null) {
            throw new CborSerializationException("Only one can be set. datumHash or datum");
        }
        Array datumArray = new Array();
        if (this.datumHash != null) {
            datumArray.add((DataItem)new UnsignedInteger(0L));
            datumArray.add((DataItem)new ByteString(this.datumHash));
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)datumArray);
        } else if (this.inlineDatum != null) {
            DataItem inlineDatumDI = this.inlineDatum.serialize();
            ByteString inlineDatumBS = null;
            try {
                inlineDatumBS = new ByteString(CborSerializationUtil.serialize(inlineDatumDI));
                inlineDatumBS.setTag(new Tag(24L));
            }
            catch (CborException e) {
                throw new CborSerializationException("Cbor serialization error", (Exception)((Object)e));
            }
            datumArray.add((DataItem)new UnsignedInteger(1L));
            datumArray.add((DataItem)inlineDatumBS);
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)datumArray);
        }
        if (this.scriptRef != null) {
            ByteString scriptRefBS = new ByteString(this.scriptRef);
            scriptRefBS.setTag(new Tag(24L));
            map.put((DataItem)new UnsignedInteger(3L), (DataItem)scriptRefBS);
        }
        return map;
    }

    private Array serializeAlonzo() throws CborSerializationException, AddressExcepion {
        Array array = new Array();
        byte[] addressByte = AddressUtil.addressToBytes(this.address);
        array.add((DataItem)new ByteString(addressByte));
        if (this.value == null) {
            throw new CborSerializationException("Value cannot be null");
        }
        if (this.value.getMultiAssets() != null && this.value.getMultiAssets().size() > 0) {
            Array coinAssetArray = new Array();
            if (this.value.getCoin() != null) {
                if (this.value.getCoin().compareTo(BigInteger.ZERO) == 0 || this.value.getCoin().compareTo(BigInteger.ZERO) == 1) {
                    coinAssetArray.add((DataItem)new UnsignedInteger(this.value.getCoin()));
                } else {
                    coinAssetArray.add((DataItem)new NegativeInteger(this.value.getCoin()));
                }
            } else {
                coinAssetArray.add((DataItem)new UnsignedInteger(BigInteger.ZERO));
            }
            Map valueMap = this.value.serialize();
            coinAssetArray.add((DataItem)valueMap);
            array.add((DataItem)coinAssetArray);
        } else if (this.value.getCoin() != null) {
            if (this.value.getCoin().compareTo(BigInteger.ZERO) == 0 || this.value.getCoin().compareTo(BigInteger.ZERO) == 1) {
                array.add((DataItem)new UnsignedInteger(this.value.getCoin()));
            } else {
                array.add((DataItem)new NegativeInteger(this.value.getCoin()));
            }
        } else {
            array.add((DataItem)new UnsignedInteger(BigInteger.ZERO));
        }
        if (this.datumHash != null) {
            array.add((DataItem)new ByteString(this.datumHash));
        }
        return array;
    }

    public static TransactionOutput deserialize(DataItem dataItem) throws CborDeserializationException {
        if (MajorType.ARRAY == dataItem.getMajorType()) {
            return TransactionOutput.deserializeAlonzo((Array)dataItem);
        }
        if (MajorType.MAP == dataItem.getMajorType()) {
            return TransactionOutput.deserializePostAlonzo((Map)dataItem);
        }
        throw new CborDeserializationException("Invalid type for TransactionOutput : " + dataItem.getMajorType());
    }

    private static TransactionOutput deserializePostAlonzo(Map ouptutItem) throws CborDeserializationException {
        TransactionOutput output = new TransactionOutput();
        ByteString addrByteStr = (ByteString)ouptutItem.get((DataItem)new UnsignedInteger(0L));
        if (addrByteStr != null) {
            try {
                output.setAddress(AddressUtil.bytesToAddress(addrByteStr.getBytes()));
            }
            catch (Exception e) {
                throw new CborDeserializationException("Bytes cannot be converted to bech32 address", e);
            }
        }
        Value value = null;
        DataItem valueItem = ouptutItem.get((DataItem)new UnsignedInteger(1L));
        if (MajorType.UNSIGNED_INTEGER.equals((Object)valueItem.getMajorType()) || MajorType.NEGATIVE_INTEGER.equals((Object)valueItem.getMajorType())) {
            value = new Value();
            value.setCoin(((Number)valueItem).getValue());
        } else if (MajorType.BYTE_STRING.equals((Object)valueItem.getMajorType())) {
            if (valueItem.getTag().getValue() == 2L) {
                value = new Value();
                value.setCoin(new BigInteger(((ByteString)valueItem).getBytes()));
            } else if (valueItem.getTag().getValue() == 3L) {
                value = new Value();
                value.setCoin(new BigInteger(((ByteString)valueItem).getBytes()).multiply(BigInteger.valueOf(-1L)));
            }
        } else if (MajorType.ARRAY.equals((Object)valueItem.getMajorType())) {
            Array coinAssetArray = (Array)valueItem;
            value = Value.deserialize(coinAssetArray);
        }
        output.setValue(value);
        byte[] datumHash = null;
        PlutusData inlineDatum = null;
        Array datumOptionsItem = (Array)ouptutItem.get((DataItem)new UnsignedInteger(2L));
        if (datumOptionsItem != null) {
            List datumOptionsList = datumOptionsItem.getDataItems();
            if (datumOptionsList.size() != 2) {
                throw new CborDeserializationException("Invalid size for datum_options : " + datumOptionsList.size());
            }
            if (new UnsignedInteger(0L).equals(datumOptionsList.get(0))) {
                datumHash = ((ByteString)datumOptionsList.get(1)).getBytes();
            } else if (new UnsignedInteger(1L).equals(datumOptionsList.get(0))) {
                ByteString inlineDatumBS = (ByteString)datumOptionsList.get(1);
                inlineDatum = PlutusData.deserialize(inlineDatumBS.getBytes());
            }
        }
        output.setDatumHash(datumHash);
        output.setInlineDatum(inlineDatum);
        ByteString scriptRefBs = (ByteString)ouptutItem.get((DataItem)new UnsignedInteger(3L));
        if (scriptRefBs != null) {
            output.setScriptRef(scriptRefBs.getBytes());
        }
        return output;
    }

    private static TransactionOutput deserializeAlonzo(Array ouptutItem) throws CborDeserializationException {
        ByteString datumBytes;
        List items = ouptutItem.getDataItems();
        TransactionOutput output = new TransactionOutput();
        if (items == null || items.size() != 2 && items.size() != 3) {
            throw new CborDeserializationException("TransactionOutput deserialization failed. Invalid no of DataItems");
        }
        ByteString addrByteStr = (ByteString)items.get(0);
        if (addrByteStr != null) {
            try {
                output.setAddress(AddressUtil.bytesToAddress(addrByteStr.getBytes()));
            }
            catch (Exception e) {
                throw new CborDeserializationException("Bytes cannot be converted to bech32 address", e);
            }
        }
        Value value = null;
        DataItem valueItem = (DataItem)items.get(1);
        if (MajorType.UNSIGNED_INTEGER.equals((Object)valueItem.getMajorType()) || MajorType.NEGATIVE_INTEGER.equals((Object)valueItem.getMajorType())) {
            value = new Value();
            value.setCoin(((Number)valueItem).getValue());
        } else if (MajorType.BYTE_STRING.equals((Object)valueItem.getMajorType())) {
            if (valueItem.getTag().getValue() == 2L) {
                value = new Value();
                value.setCoin(new BigInteger(((ByteString)valueItem).getBytes()));
            } else if (valueItem.getTag().getValue() == 3L) {
                value = new Value();
                value.setCoin(new BigInteger(((ByteString)valueItem).getBytes()).multiply(BigInteger.valueOf(-1L)));
            }
        } else if (MajorType.ARRAY.equals((Object)valueItem.getMajorType())) {
            Array coinAssetArray = (Array)valueItem;
            value = Value.deserialize(coinAssetArray);
        }
        if (items.size() == 3 && (datumBytes = (ByteString)items.get(2)) != null) {
            output.setDatumHash(datumBytes.getBytes());
        }
        output.setValue(value);
        return output;
    }

    public String toString() {
        return "TransactionOutput{address='" + this.address + "', value=" + this.value + ", datumHash=" + (this.datumHash == null ? null : HexUtil.encodeHexString(this.datumHash)) + ", inlineDatum=" + (this.inlineDatum == null ? null : this.inlineDatum.toString()) + ", scriptRef=" + (this.scriptRef == null ? null : this.scriptRef.toString()) + "}";
    }

    public static TransactionOutputBuilder builder() {
        return new TransactionOutputBuilder();
    }

    public TransactionOutputBuilder toBuilder() {
        return new TransactionOutputBuilder().address(this.address).value(this.value).datumHash(this.datumHash).inlineDatum(this.inlineDatum).scriptRef(this.scriptRef);
    }

    public String getAddress() {
        return this.address;
    }

    public Value getValue() {
        return this.value;
    }

    public byte[] getDatumHash() {
        return this.datumHash;
    }

    public PlutusData getInlineDatum() {
        return this.inlineDatum;
    }

    public byte[] getScriptRef() {
        return this.scriptRef;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setDatumHash(byte[] datumHash) {
        this.datumHash = datumHash;
    }

    public void setInlineDatum(PlutusData inlineDatum) {
        this.inlineDatum = inlineDatum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionOutput)) {
            return false;
        }
        TransactionOutput other = (TransactionOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Value this$value = this.getValue();
        Value other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        if (!Arrays.equals(this.getDatumHash(), other.getDatumHash())) {
            return false;
        }
        PlutusData this$inlineDatum = this.getInlineDatum();
        PlutusData other$inlineDatum = other.getInlineDatum();
        if (this$inlineDatum == null ? other$inlineDatum != null : !this$inlineDatum.equals(other$inlineDatum)) {
            return false;
        }
        return Arrays.equals(this.getScriptRef(), other.getScriptRef());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionOutput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Value $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        result = result * 59 + Arrays.hashCode(this.getDatumHash());
        PlutusData $inlineDatum = this.getInlineDatum();
        result = result * 59 + ($inlineDatum == null ? 43 : $inlineDatum.hashCode());
        result = result * 59 + Arrays.hashCode(this.getScriptRef());
        return result;
    }

    public TransactionOutput(String address, Value value, byte[] datumHash, PlutusData inlineDatum, byte[] scriptRef) {
        this.address = address;
        this.value = value;
        this.datumHash = datumHash;
        this.inlineDatum = inlineDatum;
        this.scriptRef = scriptRef;
    }

    public TransactionOutput() {
    }

    public static class TransactionOutputBuilder {
        private String address;
        private Value value;
        private byte[] datumHash;
        private PlutusData inlineDatum;
        private byte[] scriptRef;

        public TransactionOutputBuilder scriptRef(byte[] scriptRef) {
            this.scriptRef = scriptRef;
            return this;
        }

        public TransactionOutputBuilder scriptRef(Script script) {
            if (script == null) {
                return this;
            }
            try {
                this.scriptRef = script.scriptRefBytes();
            }
            catch (CborSerializationException e) {
                throw new CborRuntimeException(e);
            }
            return this;
        }

        TransactionOutputBuilder() {
        }

        public TransactionOutputBuilder address(String address) {
            this.address = address;
            return this;
        }

        public TransactionOutputBuilder value(Value value) {
            this.value = value;
            return this;
        }

        public TransactionOutputBuilder datumHash(byte[] datumHash) {
            this.datumHash = datumHash;
            return this;
        }

        public TransactionOutputBuilder inlineDatum(PlutusData inlineDatum) {
            this.inlineDatum = inlineDatum;
            return this;
        }

        public TransactionOutput build() {
            return new TransactionOutput(this.address, this.value, this.datumHash, this.inlineDatum, this.scriptRef);
        }

        public String toString() {
            return "TransactionOutput.TransactionOutputBuilder(address=" + this.address + ", value=" + this.value + ", datumHash=" + Arrays.toString(this.datumHash) + ", inlineDatum=" + this.inlineDatum + ", scriptRef=" + Arrays.toString(this.scriptRef) + ")";
        }
    }
}

