/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.BootstrapWitness;
import com.bloxbean.cardano.client.transaction.spec.PlutusData;
import com.bloxbean.cardano.client.transaction.spec.PlutusV1Script;
import com.bloxbean.cardano.client.transaction.spec.PlutusV2Script;
import com.bloxbean.cardano.client.transaction.spec.Redeemer;
import com.bloxbean.cardano.client.transaction.spec.VkeyWitness;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import java.util.ArrayList;
import java.util.List;

public class TransactionWitnessSet {
    private List<VkeyWitness> vkeyWitnesses;
    private List<NativeScript> nativeScripts;
    private List<BootstrapWitness> bootstrapWitnesses;
    private List<PlutusV1Script> plutusV1Scripts;
    private List<PlutusData> plutusDataList;
    private List<Redeemer> redeemers;
    private List<PlutusV2Script> plutusV2Scripts;

    public Map serialize() throws CborSerializationException {
        Map witnessMap = new Map();
        if (this.vkeyWitnesses != null && this.vkeyWitnesses.size() > 0) {
            Array vkeyWitnessArray = new Array();
            for (VkeyWitness vkeyWitness : this.vkeyWitnesses) {
                vkeyWitnessArray.add((DataItem)vkeyWitness.serialize());
            }
            witnessMap.put((DataItem)new UnsignedInteger(0L), (DataItem)vkeyWitnessArray);
        }
        if (this.nativeScripts != null && this.nativeScripts.size() > 0) {
            Array nativeScriptArray = new Array();
            for (NativeScript nativeScript : this.nativeScripts) {
                nativeScriptArray.add(nativeScript.serializeAsDataItem());
            }
            witnessMap.put((DataItem)new UnsignedInteger(1L), (DataItem)nativeScriptArray);
        }
        if (this.bootstrapWitnesses != null && this.bootstrapWitnesses.size() > 0) {
            Array bootstrapWitnessArray = new Array();
            for (BootstrapWitness bootstrapWitness : this.bootstrapWitnesses) {
                bootstrapWitnessArray.add((DataItem)bootstrapWitness.serialize());
            }
            witnessMap.put((DataItem)new UnsignedInteger(2L), (DataItem)bootstrapWitnessArray);
        }
        if (this.plutusV1Scripts != null && this.plutusV1Scripts.size() > 0) {
            Array plutusScriptArray = new Array();
            for (PlutusV1Script plutusScript : this.plutusV1Scripts) {
                plutusScriptArray.add((DataItem)plutusScript.serializeAsDataItem());
            }
            witnessMap.put((DataItem)new UnsignedInteger(3L), (DataItem)plutusScriptArray);
        }
        if (this.plutusDataList != null && this.plutusDataList.size() > 0) {
            Array plutusdataArray = new Array();
            for (PlutusData plutusData : this.plutusDataList) {
                plutusdataArray.add(plutusData.serialize());
            }
            witnessMap.put((DataItem)new UnsignedInteger(4L), (DataItem)plutusdataArray);
        }
        if (this.redeemers != null && this.redeemers.size() > 0) {
            Array redeemerArray = new Array();
            for (Redeemer redeemer : this.redeemers) {
                redeemerArray.add((DataItem)redeemer.serialize());
            }
            witnessMap.put((DataItem)new UnsignedInteger(5L), (DataItem)redeemerArray);
        }
        if (this.plutusV2Scripts != null && this.plutusV2Scripts.size() > 0) {
            Array plutusV2ScriptArray = new Array();
            for (PlutusV2Script plutusV2Script : this.plutusV2Scripts) {
                plutusV2ScriptArray.add((DataItem)plutusV2Script.serializeAsDataItem());
            }
            witnessMap.put((DataItem)new UnsignedInteger(6L), (DataItem)plutusV2ScriptArray);
        }
        return witnessMap;
    }

    public static TransactionWitnessSet deserialize(Map witnessMap) throws CborDeserializationException {
        TransactionWitnessSet transactionWitnessSet = new TransactionWitnessSet();
        DataItem vkWitnessesArray = witnessMap.get((DataItem)new UnsignedInteger(0L));
        DataItem nativeScriptArray = witnessMap.get((DataItem)new UnsignedInteger(1L));
        DataItem bootstrapWitnessArray = witnessMap.get((DataItem)new UnsignedInteger(2L));
        DataItem plutusScriptArray = witnessMap.get((DataItem)new UnsignedInteger(3L));
        DataItem plutusDataArray = witnessMap.get((DataItem)new UnsignedInteger(4L));
        DataItem redeemerArray = witnessMap.get((DataItem)new UnsignedInteger(5L));
        DataItem plutusV2ScriptArray = witnessMap.get((DataItem)new UnsignedInteger(6L));
        if (vkWitnessesArray != null) {
            List vkeyWitnessesDIList = ((Array)vkWitnessesArray).getDataItems();
            ArrayList<VkeyWitness> vkeyWitnesses = new ArrayList<VkeyWitness>();
            for (DataItem vkWitness : vkeyWitnessesDIList) {
                if (vkWitness == SimpleValue.BREAK) continue;
                VkeyWitness vkeyWitness = VkeyWitness.deserialize((Array)vkWitness);
                vkeyWitnesses.add(vkeyWitness);
            }
            if (vkeyWitnesses.size() > 0) {
                transactionWitnessSet.setVkeyWitnesses(vkeyWitnesses);
            }
        } else {
            transactionWitnessSet.setVkeyWitnesses(null);
        }
        if (nativeScriptArray != null) {
            List nativeScriptsDIList = ((Array)nativeScriptArray).getDataItems();
            ArrayList<NativeScript> nativeScripts = new ArrayList<NativeScript>();
            for (DataItem nativeScriptDI : nativeScriptsDIList) {
                NativeScript nativeScript;
                if (nativeScriptDI == SimpleValue.BREAK || (nativeScript = NativeScript.deserialize((Array)nativeScriptDI)) == null) continue;
                nativeScripts.add(nativeScript);
            }
            if (nativeScripts.size() > 0) {
                transactionWitnessSet.setNativeScripts(nativeScripts);
            }
        } else {
            transactionWitnessSet.setNativeScripts(null);
        }
        if (bootstrapWitnessArray != null) {
            List bootstrapWitnessDIList = ((Array)bootstrapWitnessArray).getDataItems();
            ArrayList<BootstrapWitness> bootstrapWitnesses = new ArrayList<BootstrapWitness>();
            for (DataItem bootstrapWitnessDI : bootstrapWitnessDIList) {
                BootstrapWitness bootstrapWitness;
                if (bootstrapWitnessDI == SimpleValue.BREAK || (bootstrapWitness = BootstrapWitness.deserialize((Array)bootstrapWitnessDI)) == null) continue;
                bootstrapWitnesses.add(bootstrapWitness);
            }
            if (bootstrapWitnesses.size() > 0) {
                transactionWitnessSet.setBootstrapWitnesses(bootstrapWitnesses);
            }
        } else {
            transactionWitnessSet.setBootstrapWitnesses(null);
        }
        if (plutusScriptArray != null) {
            List plutusV1ScriptDIList = ((Array)plutusScriptArray).getDataItems();
            ArrayList<PlutusV1Script> plutusV1Scripts = new ArrayList<PlutusV1Script>();
            for (DataItem plutusV1ScriptDI : plutusV1ScriptDIList) {
                PlutusV1Script plutusV1Script;
                if (plutusV1ScriptDI == SimpleValue.BREAK || (plutusV1Script = PlutusV1Script.deserialize((ByteString)plutusV1ScriptDI)) == null) continue;
                plutusV1Scripts.add(plutusV1Script);
            }
            if (plutusV1Scripts.size() > 0) {
                transactionWitnessSet.setPlutusV1Scripts(plutusV1Scripts);
            }
        } else {
            transactionWitnessSet.setPlutusV1Scripts(null);
        }
        if (plutusDataArray != null) {
            List plutusDataDIList = ((Array)plutusDataArray).getDataItems();
            ArrayList<PlutusData> plutusDataList = new ArrayList<PlutusData>();
            for (DataItem plutusDataDI : plutusDataDIList) {
                if (plutusDataDI == SimpleValue.BREAK) continue;
                plutusDataList.add(PlutusData.deserialize(plutusDataDI));
            }
            if (plutusDataList.size() > 0) {
                transactionWitnessSet.setPlutusDataList(plutusDataList);
            }
        } else {
            transactionWitnessSet.setPlutusDataList(null);
        }
        if (redeemerArray != null) {
            List redeemerDIList = ((Array)redeemerArray).getDataItems();
            ArrayList<Redeemer> redeemers = new ArrayList<Redeemer>();
            for (DataItem redeemerDI : redeemerDIList) {
                if (redeemerDI == SimpleValue.BREAK) continue;
                redeemers.add(Redeemer.deserialize((Array)redeemerDI));
            }
            if (redeemers.size() > 0) {
                transactionWitnessSet.setRedeemers(redeemers);
            }
        } else {
            transactionWitnessSet.setRedeemers(null);
        }
        if (plutusV2ScriptArray != null) {
            List plutusV2ScriptDIList = ((Array)plutusV2ScriptArray).getDataItems();
            ArrayList<PlutusV2Script> plutusV2Scripts = new ArrayList<PlutusV2Script>();
            for (DataItem plutusV2ScriptDI : plutusV2ScriptDIList) {
                PlutusV2Script plutusV2Script;
                if (plutusV2ScriptDI == SimpleValue.BREAK || (plutusV2Script = PlutusV2Script.deserialize((ByteString)plutusV2ScriptDI)) == null) continue;
                plutusV2Scripts.add(plutusV2Script);
            }
            if (plutusV2Scripts.size() > 0) {
                transactionWitnessSet.setPlutusV2Scripts(plutusV2Scripts);
            }
        } else {
            transactionWitnessSet.setPlutusV2Scripts(null);
        }
        if (transactionWitnessSet.getVkeyWitnesses() == null && transactionWitnessSet.getNativeScripts() == null && transactionWitnessSet.getBootstrapWitnesses() == null && transactionWitnessSet.getPlutusV1Scripts() == null && transactionWitnessSet.getPlutusV2Scripts() == null && transactionWitnessSet.getPlutusDataList() == null && transactionWitnessSet.getRedeemers() == null) {
            return null;
        }
        return transactionWitnessSet;
    }

    private static List<VkeyWitness> $default$vkeyWitnesses() {
        return new ArrayList<VkeyWitness>();
    }

    private static List<NativeScript> $default$nativeScripts() {
        return new ArrayList<NativeScript>();
    }

    private static List<BootstrapWitness> $default$bootstrapWitnesses() {
        return new ArrayList<BootstrapWitness>();
    }

    private static List<PlutusV1Script> $default$plutusV1Scripts() {
        return new ArrayList<PlutusV1Script>();
    }

    private static List<PlutusData> $default$plutusDataList() {
        return new ArrayList<PlutusData>();
    }

    private static List<Redeemer> $default$redeemers() {
        return new ArrayList<Redeemer>();
    }

    private static List<PlutusV2Script> $default$plutusV2Scripts() {
        return new ArrayList<PlutusV2Script>();
    }

    public static TransactionWitnessSetBuilder builder() {
        return new TransactionWitnessSetBuilder();
    }

    public List<VkeyWitness> getVkeyWitnesses() {
        return this.vkeyWitnesses;
    }

    public List<NativeScript> getNativeScripts() {
        return this.nativeScripts;
    }

    public List<BootstrapWitness> getBootstrapWitnesses() {
        return this.bootstrapWitnesses;
    }

    public List<PlutusV1Script> getPlutusV1Scripts() {
        return this.plutusV1Scripts;
    }

    public List<PlutusData> getPlutusDataList() {
        return this.plutusDataList;
    }

    public List<Redeemer> getRedeemers() {
        return this.redeemers;
    }

    public List<PlutusV2Script> getPlutusV2Scripts() {
        return this.plutusV2Scripts;
    }

    public void setVkeyWitnesses(List<VkeyWitness> vkeyWitnesses) {
        this.vkeyWitnesses = vkeyWitnesses;
    }

    public void setNativeScripts(List<NativeScript> nativeScripts) {
        this.nativeScripts = nativeScripts;
    }

    public void setBootstrapWitnesses(List<BootstrapWitness> bootstrapWitnesses) {
        this.bootstrapWitnesses = bootstrapWitnesses;
    }

    public void setPlutusV1Scripts(List<PlutusV1Script> plutusV1Scripts) {
        this.plutusV1Scripts = plutusV1Scripts;
    }

    public void setPlutusDataList(List<PlutusData> plutusDataList) {
        this.plutusDataList = plutusDataList;
    }

    public void setRedeemers(List<Redeemer> redeemers) {
        this.redeemers = redeemers;
    }

    public void setPlutusV2Scripts(List<PlutusV2Script> plutusV2Scripts) {
        this.plutusV2Scripts = plutusV2Scripts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionWitnessSet)) {
            return false;
        }
        TransactionWitnessSet other = (TransactionWitnessSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<VkeyWitness> this$vkeyWitnesses = this.getVkeyWitnesses();
        List<VkeyWitness> other$vkeyWitnesses = other.getVkeyWitnesses();
        if (this$vkeyWitnesses == null ? other$vkeyWitnesses != null : !((Object)this$vkeyWitnesses).equals(other$vkeyWitnesses)) {
            return false;
        }
        List<NativeScript> this$nativeScripts = this.getNativeScripts();
        List<NativeScript> other$nativeScripts = other.getNativeScripts();
        if (this$nativeScripts == null ? other$nativeScripts != null : !((Object)this$nativeScripts).equals(other$nativeScripts)) {
            return false;
        }
        List<BootstrapWitness> this$bootstrapWitnesses = this.getBootstrapWitnesses();
        List<BootstrapWitness> other$bootstrapWitnesses = other.getBootstrapWitnesses();
        if (this$bootstrapWitnesses == null ? other$bootstrapWitnesses != null : !((Object)this$bootstrapWitnesses).equals(other$bootstrapWitnesses)) {
            return false;
        }
        List<PlutusV1Script> this$plutusV1Scripts = this.getPlutusV1Scripts();
        List<PlutusV1Script> other$plutusV1Scripts = other.getPlutusV1Scripts();
        if (this$plutusV1Scripts == null ? other$plutusV1Scripts != null : !((Object)this$plutusV1Scripts).equals(other$plutusV1Scripts)) {
            return false;
        }
        List<PlutusData> this$plutusDataList = this.getPlutusDataList();
        List<PlutusData> other$plutusDataList = other.getPlutusDataList();
        if (this$plutusDataList == null ? other$plutusDataList != null : !((Object)this$plutusDataList).equals(other$plutusDataList)) {
            return false;
        }
        List<Redeemer> this$redeemers = this.getRedeemers();
        List<Redeemer> other$redeemers = other.getRedeemers();
        if (this$redeemers == null ? other$redeemers != null : !((Object)this$redeemers).equals(other$redeemers)) {
            return false;
        }
        List<PlutusV2Script> this$plutusV2Scripts = this.getPlutusV2Scripts();
        List<PlutusV2Script> other$plutusV2Scripts = other.getPlutusV2Scripts();
        return !(this$plutusV2Scripts == null ? other$plutusV2Scripts != null : !((Object)this$plutusV2Scripts).equals(other$plutusV2Scripts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionWitnessSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<VkeyWitness> $vkeyWitnesses = this.getVkeyWitnesses();
        result = result * 59 + ($vkeyWitnesses == null ? 43 : ((Object)$vkeyWitnesses).hashCode());
        List<NativeScript> $nativeScripts = this.getNativeScripts();
        result = result * 59 + ($nativeScripts == null ? 43 : ((Object)$nativeScripts).hashCode());
        List<BootstrapWitness> $bootstrapWitnesses = this.getBootstrapWitnesses();
        result = result * 59 + ($bootstrapWitnesses == null ? 43 : ((Object)$bootstrapWitnesses).hashCode());
        List<PlutusV1Script> $plutusV1Scripts = this.getPlutusV1Scripts();
        result = result * 59 + ($plutusV1Scripts == null ? 43 : ((Object)$plutusV1Scripts).hashCode());
        List<PlutusData> $plutusDataList = this.getPlutusDataList();
        result = result * 59 + ($plutusDataList == null ? 43 : ((Object)$plutusDataList).hashCode());
        List<Redeemer> $redeemers = this.getRedeemers();
        result = result * 59 + ($redeemers == null ? 43 : ((Object)$redeemers).hashCode());
        List<PlutusV2Script> $plutusV2Scripts = this.getPlutusV2Scripts();
        result = result * 59 + ($plutusV2Scripts == null ? 43 : ((Object)$plutusV2Scripts).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionWitnessSet(vkeyWitnesses=" + this.getVkeyWitnesses() + ", nativeScripts=" + this.getNativeScripts() + ", bootstrapWitnesses=" + this.getBootstrapWitnesses() + ", plutusV1Scripts=" + this.getPlutusV1Scripts() + ", plutusDataList=" + this.getPlutusDataList() + ", redeemers=" + this.getRedeemers() + ", plutusV2Scripts=" + this.getPlutusV2Scripts() + ")";
    }

    public TransactionWitnessSet(List<VkeyWitness> vkeyWitnesses, List<NativeScript> nativeScripts, List<BootstrapWitness> bootstrapWitnesses, List<PlutusV1Script> plutusV1Scripts, List<PlutusData> plutusDataList, List<Redeemer> redeemers, List<PlutusV2Script> plutusV2Scripts) {
        this.vkeyWitnesses = vkeyWitnesses;
        this.nativeScripts = nativeScripts;
        this.bootstrapWitnesses = bootstrapWitnesses;
        this.plutusV1Scripts = plutusV1Scripts;
        this.plutusDataList = plutusDataList;
        this.redeemers = redeemers;
        this.plutusV2Scripts = plutusV2Scripts;
    }

    public TransactionWitnessSet() {
        this.vkeyWitnesses = TransactionWitnessSet.$default$vkeyWitnesses();
        this.nativeScripts = TransactionWitnessSet.$default$nativeScripts();
        this.bootstrapWitnesses = TransactionWitnessSet.$default$bootstrapWitnesses();
        this.plutusV1Scripts = TransactionWitnessSet.$default$plutusV1Scripts();
        this.plutusDataList = TransactionWitnessSet.$default$plutusDataList();
        this.redeemers = TransactionWitnessSet.$default$redeemers();
        this.plutusV2Scripts = TransactionWitnessSet.$default$plutusV2Scripts();
    }

    public static class TransactionWitnessSetBuilder {
        private boolean vkeyWitnesses$set;
        private List<VkeyWitness> vkeyWitnesses$value;
        private boolean nativeScripts$set;
        private List<NativeScript> nativeScripts$value;
        private boolean bootstrapWitnesses$set;
        private List<BootstrapWitness> bootstrapWitnesses$value;
        private boolean plutusV1Scripts$set;
        private List<PlutusV1Script> plutusV1Scripts$value;
        private boolean plutusDataList$set;
        private List<PlutusData> plutusDataList$value;
        private boolean redeemers$set;
        private List<Redeemer> redeemers$value;
        private boolean plutusV2Scripts$set;
        private List<PlutusV2Script> plutusV2Scripts$value;

        TransactionWitnessSetBuilder() {
        }

        public TransactionWitnessSetBuilder vkeyWitnesses(List<VkeyWitness> vkeyWitnesses) {
            this.vkeyWitnesses$value = vkeyWitnesses;
            this.vkeyWitnesses$set = true;
            return this;
        }

        public TransactionWitnessSetBuilder nativeScripts(List<NativeScript> nativeScripts) {
            this.nativeScripts$value = nativeScripts;
            this.nativeScripts$set = true;
            return this;
        }

        public TransactionWitnessSetBuilder bootstrapWitnesses(List<BootstrapWitness> bootstrapWitnesses) {
            this.bootstrapWitnesses$value = bootstrapWitnesses;
            this.bootstrapWitnesses$set = true;
            return this;
        }

        public TransactionWitnessSetBuilder plutusV1Scripts(List<PlutusV1Script> plutusV1Scripts) {
            this.plutusV1Scripts$value = plutusV1Scripts;
            this.plutusV1Scripts$set = true;
            return this;
        }

        public TransactionWitnessSetBuilder plutusDataList(List<PlutusData> plutusDataList) {
            this.plutusDataList$value = plutusDataList;
            this.plutusDataList$set = true;
            return this;
        }

        public TransactionWitnessSetBuilder redeemers(List<Redeemer> redeemers) {
            this.redeemers$value = redeemers;
            this.redeemers$set = true;
            return this;
        }

        public TransactionWitnessSetBuilder plutusV2Scripts(List<PlutusV2Script> plutusV2Scripts) {
            this.plutusV2Scripts$value = plutusV2Scripts;
            this.plutusV2Scripts$set = true;
            return this;
        }

        public TransactionWitnessSet build() {
            List<VkeyWitness> vkeyWitnesses$value = this.vkeyWitnesses$value;
            if (!this.vkeyWitnesses$set) {
                vkeyWitnesses$value = TransactionWitnessSet.$default$vkeyWitnesses();
            }
            List<NativeScript> nativeScripts$value = this.nativeScripts$value;
            if (!this.nativeScripts$set) {
                nativeScripts$value = TransactionWitnessSet.$default$nativeScripts();
            }
            List<BootstrapWitness> bootstrapWitnesses$value = this.bootstrapWitnesses$value;
            if (!this.bootstrapWitnesses$set) {
                bootstrapWitnesses$value = TransactionWitnessSet.$default$bootstrapWitnesses();
            }
            List<PlutusV1Script> plutusV1Scripts$value = this.plutusV1Scripts$value;
            if (!this.plutusV1Scripts$set) {
                plutusV1Scripts$value = TransactionWitnessSet.$default$plutusV1Scripts();
            }
            List<PlutusData> plutusDataList$value = this.plutusDataList$value;
            if (!this.plutusDataList$set) {
                plutusDataList$value = TransactionWitnessSet.$default$plutusDataList();
            }
            List<Redeemer> redeemers$value = this.redeemers$value;
            if (!this.redeemers$set) {
                redeemers$value = TransactionWitnessSet.$default$redeemers();
            }
            List<PlutusV2Script> plutusV2Scripts$value = this.plutusV2Scripts$value;
            if (!this.plutusV2Scripts$set) {
                plutusV2Scripts$value = TransactionWitnessSet.$default$plutusV2Scripts();
            }
            return new TransactionWitnessSet(vkeyWitnesses$value, nativeScripts$value, bootstrapWitnesses$value, plutusV1Scripts$value, plutusDataList$value, redeemers$value, plutusV2Scripts$value);
        }

        public String toString() {
            return "TransactionWitnessSet.TransactionWitnessSetBuilder(vkeyWitnesses$value=" + this.vkeyWitnesses$value + ", nativeScripts$value=" + this.nativeScripts$value + ", bootstrapWitnesses$value=" + this.bootstrapWitnesses$value + ", plutusV1Scripts$value=" + this.plutusV1Scripts$value + ", plutusDataList$value=" + this.plutusDataList$value + ", redeemers$value=" + this.redeemers$value + ", plutusV2Scripts$value=" + this.plutusV2Scripts$value + ")";
        }
    }
}

