/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.ProtocolParamUpdate;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class Update {
    private java.util.Map<String, ProtocolParamUpdate> protocolParamUpdates;
    private int epoch;

    public void addProtocolParameterUpdate(String genesisHash, ProtocolParamUpdate protocolParamUpdate) {
        if (this.protocolParamUpdates == null) {
            this.protocolParamUpdates = new HashMap<String, ProtocolParamUpdate>();
        }
        this.protocolParamUpdates.put(genesisHash, protocolParamUpdate);
    }

    public DataItem serialize() throws CborSerializationException {
        Array updateArray = new Array();
        Map protoParamUpdatesMap = new Map();
        for (String genesisHash : this.protocolParamUpdates.keySet()) {
            ProtocolParamUpdate protocolParam = this.protocolParamUpdates.get(genesisHash);
            protoParamUpdatesMap.put((DataItem)new ByteString(HexUtil.decodeHexString(genesisHash)), protocolParam.serialize());
        }
        updateArray.add((DataItem)protoParamUpdatesMap);
        updateArray.add((DataItem)new UnsignedInteger((long)this.epoch));
        return updateArray;
    }

    public static Update deserialize(DataItem din) throws CborDeserializationException {
        Array updateArray = (Array)din;
        if (updateArray.getDataItems().size() != 2) {
            throw new CborDeserializationException("Invalid number of dataitems for update. Expected 2, found: " + updateArray.getDataItems().size());
        }
        LinkedHashMap<String, ProtocolParamUpdate> deProtoParamUpdatesMap = new LinkedHashMap<String, ProtocolParamUpdate>();
        Map protoParamUpdatesMap = (Map)updateArray.getDataItems().get(0);
        for (DataItem genhashDI : protoParamUpdatesMap.getKeys()) {
            String genesisHash = HexUtil.encodeHexString(((ByteString)genhashDI).getBytes());
            ProtocolParamUpdate protocolParamUpdate = ProtocolParamUpdate.deserialize(protoParamUpdatesMap.get(genhashDI));
            deProtoParamUpdatesMap.put(genesisHash, protocolParamUpdate);
        }
        int epoch = ((UnsignedInteger)updateArray.getDataItems().get(1)).getValue().intValue();
        return new Update(deProtoParamUpdatesMap, epoch);
    }

    public static UpdateBuilder builder() {
        return new UpdateBuilder();
    }

    public java.util.Map<String, ProtocolParamUpdate> getProtocolParamUpdates() {
        return this.protocolParamUpdates;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public Update(java.util.Map<String, ProtocolParamUpdate> protocolParamUpdates, int epoch) {
        this.protocolParamUpdates = protocolParamUpdates;
        this.epoch = epoch;
    }

    public Update() {
    }

    public static class UpdateBuilder {
        private java.util.Map<String, ProtocolParamUpdate> protocolParamUpdates;
        private int epoch;

        UpdateBuilder() {
        }

        public UpdateBuilder protocolParamUpdates(java.util.Map<String, ProtocolParamUpdate> protocolParamUpdates) {
            this.protocolParamUpdates = protocolParamUpdates;
            return this;
        }

        public UpdateBuilder epoch(int epoch) {
            this.epoch = epoch;
            return this;
        }

        public Update build() {
            return new Update(this.protocolParamUpdates, this.epoch);
        }

        public String toString() {
            return "Update.UpdateBuilder(protocolParamUpdates=" + this.protocolParamUpdates + ", epoch=" + this.epoch + ")";
        }
    }
}

