/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import com.bloxbean.cardano.client.transaction.util.cbor.SortedMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Value {
    private BigInteger coin;
    private List<MultiAsset> multiAssets;

    public static Value deserialize(Array valueArray) {
        Value value = new Value();
        List valueDataItems = valueArray.getDataItems();
        if (valueDataItems != null && valueDataItems.size() == 2) {
            DataItem valueDI = (DataItem)valueDataItems.get(0);
            BigInteger coin = CborSerializationUtil.getBigInteger(valueDI);
            value.setCoin(coin);
            Map multiAssetsMap = (Map)valueDataItems.get(1);
            if (multiAssetsMap != null) {
                for (DataItem key : multiAssetsMap.getKeys()) {
                    MultiAsset multiAsset = MultiAsset.deserialize(multiAssetsMap, key);
                    value.getMultiAssets().add(multiAsset);
                }
            }
        }
        return value;
    }

    public HashMap<String, HashMap<String, BigInteger>> toMap() {
        HashMap<String, HashMap<String, BigInteger>> multiAssetsMap = new HashMap<String, HashMap<String, BigInteger>>();
        for (MultiAsset multiAsset : this.multiAssets) {
            HashMap<String, BigInteger> assets = new HashMap<String, BigInteger>();
            for (Asset asset : multiAsset.getAssets()) {
                assets.put(asset.getName(), asset.getValue());
            }
            multiAssetsMap.put(multiAsset.getPolicyId(), assets);
        }
        return multiAssetsMap;
    }

    public Map serialize() throws CborSerializationException {
        SortedMap map = new SortedMap();
        if (this.multiAssets != null) {
            ArrayList<MultiAsset> cloneMultiAssets = new ArrayList<MultiAsset>(this.multiAssets);
            Collections.sort(cloneMultiAssets, (m1, m2) -> m1.getPolicyId().compareTo(m2.getPolicyId()));
            for (MultiAsset multiAsset : cloneMultiAssets) {
                multiAsset.serialize(map);
            }
        }
        return map;
    }

    public Value plus(Value that) {
        BigInteger sumCoin = this.getCoin() == null ? BigInteger.ZERO.add(that.getCoin()) : this.getCoin().add(that.getCoin());
        List<MultiAsset> sumMultiAssets = MultiAsset.mergeMultiAssetLists(this.getMultiAssets(), that.getMultiAssets());
        return Value.builder().coin(sumCoin).multiAssets(sumMultiAssets).build();
    }

    public Value minus(Value that) {
        BigInteger sumCoin = this.getCoin() == null ? BigInteger.ZERO.subtract(that.getCoin()) : this.getCoin().subtract(that.getCoin());
        List<MultiAsset> difMultiAssets = MultiAsset.subtractMultiAssetLists(this.getMultiAssets(), that.getMultiAssets());
        difMultiAssets.forEach(multiAsset -> multiAsset.getAssets().removeIf(asset -> BigInteger.ZERO.equals(asset.getValue())));
        difMultiAssets.removeIf(multiAsset -> multiAsset.getAssets() == null || multiAsset.getAssets().isEmpty());
        return Value.builder().coin(sumCoin).multiAssets(difMultiAssets).build();
    }

    private static BigInteger $default$coin() {
        return BigInteger.ZERO;
    }

    private static List<MultiAsset> $default$multiAssets() {
        return new ArrayList<MultiAsset>();
    }

    public static ValueBuilder builder() {
        return new ValueBuilder();
    }

    public ValueBuilder toBuilder() {
        return new ValueBuilder().coin(this.coin).multiAssets(this.multiAssets);
    }

    public BigInteger getCoin() {
        return this.coin;
    }

    public List<MultiAsset> getMultiAssets() {
        return this.multiAssets;
    }

    public void setCoin(BigInteger coin) {
        this.coin = coin;
    }

    public void setMultiAssets(List<MultiAsset> multiAssets) {
        this.multiAssets = multiAssets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$coin = this.getCoin();
        BigInteger other$coin = other.getCoin();
        if (this$coin == null ? other$coin != null : !((Object)this$coin).equals(other$coin)) {
            return false;
        }
        List<MultiAsset> this$multiAssets = this.getMultiAssets();
        List<MultiAsset> other$multiAssets = other.getMultiAssets();
        return !(this$multiAssets == null ? other$multiAssets != null : !((Object)this$multiAssets).equals(other$multiAssets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Value;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : ((Object)$coin).hashCode());
        List<MultiAsset> $multiAssets = this.getMultiAssets();
        result = result * 59 + ($multiAssets == null ? 43 : ((Object)$multiAssets).hashCode());
        return result;
    }

    public String toString() {
        return "Value(coin=" + this.getCoin() + ", multiAssets=" + this.getMultiAssets() + ")";
    }

    public Value(BigInteger coin, List<MultiAsset> multiAssets) {
        this.coin = coin;
        this.multiAssets = multiAssets;
    }

    public Value() {
        this.coin = Value.$default$coin();
        this.multiAssets = Value.$default$multiAssets();
    }

    public static class ValueBuilder {
        private boolean coin$set;
        private BigInteger coin$value;
        private boolean multiAssets$set;
        private List<MultiAsset> multiAssets$value;

        ValueBuilder() {
        }

        public ValueBuilder coin(BigInteger coin) {
            this.coin$value = coin;
            this.coin$set = true;
            return this;
        }

        public ValueBuilder multiAssets(List<MultiAsset> multiAssets) {
            this.multiAssets$value = multiAssets;
            this.multiAssets$set = true;
            return this;
        }

        public Value build() {
            BigInteger coin$value = this.coin$value;
            if (!this.coin$set) {
                coin$value = Value.$default$coin();
            }
            List<MultiAsset> multiAssets$value = this.multiAssets$value;
            if (!this.multiAssets$set) {
                multiAssets$value = Value.$default$multiAssets();
            }
            return new Value(coin$value, multiAssets$value);
        }

        public String toString() {
            return "Value.ValueBuilder(coin$value=" + this.coin$value + ", multiAssets$value=" + this.multiAssets$value + ")";
        }
    }
}

