/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.cert.Relay;

public class MultiHostName
implements Relay {
    private String dnsName;

    @Override
    public Array serialize() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(2L));
        if (this.dnsName == null || this.dnsName.isEmpty()) {
            throw new CborSerializationException("Serialization failed. DNS name can't be null for SingleHostName relay");
        }
        array.add((DataItem)new UnicodeString(this.dnsName));
        return array;
    }

    public static MultiHostNameBuilder builder() {
        return new MultiHostNameBuilder();
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public MultiHostName(String dnsName) {
        this.dnsName = dnsName;
    }

    public MultiHostName() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiHostName)) {
            return false;
        }
        MultiHostName other = (MultiHostName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dnsName = this.getDnsName();
        String other$dnsName = other.getDnsName();
        return !(this$dnsName == null ? other$dnsName != null : !this$dnsName.equals(other$dnsName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiHostName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dnsName = this.getDnsName();
        result = result * 59 + ($dnsName == null ? 43 : $dnsName.hashCode());
        return result;
    }

    public String toString() {
        return "MultiHostName(dnsName=" + this.getDnsName() + ")";
    }

    public static class MultiHostNameBuilder {
        private String dnsName;

        MultiHostNameBuilder() {
        }

        public MultiHostNameBuilder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public MultiHostName build() {
            return new MultiHostName(this.dnsName);
        }

        public String toString() {
            return "MultiHostName.MultiHostNameBuilder(dnsName=" + this.dnsName + ")";
        }
    }
}

