/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.cert.Relay;
import java.net.Inet4Address;
import java.net.Inet6Address;

public class SingleHostAddr
implements Relay {
    private int port;
    private Inet4Address ipv4;
    private Inet6Address ipv6;

    @Override
    public Array serialize() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(0L));
        if (this.port != 0) {
            array.add((DataItem)new UnsignedInteger((long)this.port));
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        if (this.ipv4 != null) {
            array.add((DataItem)new ByteString(this.ipv4.getAddress()));
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        if (this.ipv6 != null) {
            array.add((DataItem)new ByteString(this.ipv6.getAddress()));
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        return array;
    }

    public static SingleHostAddrBuilder builder() {
        return new SingleHostAddrBuilder();
    }

    public int getPort() {
        return this.port;
    }

    public Inet4Address getIpv4() {
        return this.ipv4;
    }

    public Inet6Address getIpv6() {
        return this.ipv6;
    }

    public SingleHostAddr() {
    }

    public SingleHostAddr(int port, Inet4Address ipv4, Inet6Address ipv6) {
        this.port = port;
        this.ipv4 = ipv4;
        this.ipv6 = ipv6;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleHostAddr)) {
            return false;
        }
        SingleHostAddr other = (SingleHostAddr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        Inet4Address this$ipv4 = this.getIpv4();
        Inet4Address other$ipv4 = other.getIpv4();
        if (this$ipv4 == null ? other$ipv4 != null : !((Object)this$ipv4).equals(other$ipv4)) {
            return false;
        }
        Inet6Address this$ipv6 = this.getIpv6();
        Inet6Address other$ipv6 = other.getIpv6();
        return !(this$ipv6 == null ? other$ipv6 != null : !((Object)this$ipv6).equals(other$ipv6));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SingleHostAddr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        Inet4Address $ipv4 = this.getIpv4();
        result = result * 59 + ($ipv4 == null ? 43 : ((Object)$ipv4).hashCode());
        Inet6Address $ipv6 = this.getIpv6();
        result = result * 59 + ($ipv6 == null ? 43 : ((Object)$ipv6).hashCode());
        return result;
    }

    public String toString() {
        return "SingleHostAddr(port=" + this.getPort() + ", ipv4=" + this.getIpv4() + ", ipv6=" + this.getIpv6() + ")";
    }

    public static class SingleHostAddrBuilder {
        private int port;
        private Inet4Address ipv4;
        private Inet6Address ipv6;

        SingleHostAddrBuilder() {
        }

        public SingleHostAddrBuilder port(int port) {
            this.port = port;
            return this;
        }

        public SingleHostAddrBuilder ipv4(Inet4Address ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public SingleHostAddrBuilder ipv6(Inet6Address ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public SingleHostAddr build() {
            return new SingleHostAddr(this.port, this.ipv4, this.ipv6);
        }

        public String toString() {
            return "SingleHostAddr.SingleHostAddrBuilder(port=" + this.port + ", ipv4=" + this.ipv4 + ", ipv6=" + this.ipv6 + ")";
        }
    }
}

