/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.cert.Relay;

public class SingleHostName
implements Relay {
    private int port;
    private String dnsName;

    @Override
    public Array serialize() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(1L));
        if (this.port != 0) {
            array.add((DataItem)new UnsignedInteger((long)this.port));
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        if (this.dnsName == null || this.dnsName.isEmpty()) {
            throw new CborSerializationException("Serialization failed. DNS name can't be null for SingleHostName relay");
        }
        array.add((DataItem)new UnicodeString(this.dnsName));
        return array;
    }

    public static SingleHostNameBuilder builder() {
        return new SingleHostNameBuilder();
    }

    public int getPort() {
        return this.port;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public SingleHostName() {
    }

    public SingleHostName(int port, String dnsName) {
        this.port = port;
        this.dnsName = dnsName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleHostName)) {
            return false;
        }
        SingleHostName other = (SingleHostName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$dnsName = this.getDnsName();
        String other$dnsName = other.getDnsName();
        return !(this$dnsName == null ? other$dnsName != null : !this$dnsName.equals(other$dnsName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SingleHostName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $dnsName = this.getDnsName();
        result = result * 59 + ($dnsName == null ? 43 : $dnsName.hashCode());
        return result;
    }

    public String toString() {
        return "SingleHostName(port=" + this.getPort() + ", dnsName=" + this.getDnsName() + ")";
    }

    public static class SingleHostNameBuilder {
        private int port;
        private String dnsName;

        SingleHostNameBuilder() {
        }

        public SingleHostNameBuilder port(int port) {
            this.port = port;
            return this;
        }

        public SingleHostNameBuilder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public SingleHostName build() {
            return new SingleHostName(this.port, this.dnsName);
        }

        public String toString() {
            return "SingleHostName.SingleHostNameBuilder(port=" + this.port + ", dnsName=" + this.dnsName + ")";
        }
    }
}

