/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.crypto.VerificationKey;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredType;
import com.bloxbean.cardano.client.transaction.spec.script.Script;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class StakeCredential {
    private StakeCredType type;
    private byte[] hash;

    private StakeCredential(StakeCredType type, byte[] hash) {
        this.type = type;
        this.hash = hash;
    }

    public static StakeCredential fromKey(VerificationKey vkey) {
        StakeCredential stakeCredential = StakeCredential.fromKey(vkey.getBytes());
        return stakeCredential;
    }

    public static StakeCredential fromKey(byte[] key) {
        byte[] keyHash = Blake2bUtil.blake2bHash224(key);
        StakeCredential stakeCredential = new StakeCredential(StakeCredType.ADDR_KEYHASH, keyHash);
        return stakeCredential;
    }

    public static StakeCredential fromKeyHash(byte[] keyHash) {
        StakeCredential stakeCredential = new StakeCredential(StakeCredType.ADDR_KEYHASH, keyHash);
        return stakeCredential;
    }

    public static StakeCredential fromScriptHash(byte[] scriptHash) {
        StakeCredential stakeCredential = new StakeCredential(StakeCredType.SCRIPTHASH, scriptHash);
        return stakeCredential;
    }

    public static StakeCredential fromScript(Script script) {
        try {
            return new StakeCredential(StakeCredType.SCRIPTHASH, script.getScriptHash());
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException("Cbor serialization failed for the script", e);
        }
    }

    public static StakeCredential deserialize(Array stakeCredArray) throws CborDeserializationException {
        List dataItemList = stakeCredArray.getDataItems();
        if (dataItemList == null || dataItemList.size() != 2) {
            throw new CborDeserializationException("StakeCredential deserialization failed. Invalid number of DataItem(s) : " + (dataItemList != null ? String.valueOf(dataItemList.size()) : null));
        }
        UnsignedInteger typeDI = (UnsignedInteger)dataItemList.get(0);
        ByteString hashDI = (ByteString)dataItemList.get(1);
        BigInteger typeBI = typeDI.getValue();
        if (typeBI.intValue() == 0) {
            return StakeCredential.fromKeyHash(hashDI.getBytes());
        }
        if (typeBI.intValue() == 1) {
            return StakeCredential.fromScriptHash(hashDI.getBytes());
        }
        throw new CborDeserializationException("StakeCredential deserialization failed. Invalid StakeCredType : " + typeBI.intValue());
    }

    public Array serialize() throws CborSerializationException {
        Array array = new Array();
        if (this.type == StakeCredType.ADDR_KEYHASH) {
            array.add((DataItem)new UnsignedInteger(0L));
        } else if (this.type == StakeCredType.SCRIPTHASH) {
            array.add((DataItem)new UnsignedInteger(1L));
        } else {
            throw new CborSerializationException("Invalid stake credential type : " + this.type);
        }
        array.add((DataItem)new ByteString(this.hash));
        return array;
    }

    public String getCborHex() throws CborSerializationException {
        try {
            return HexUtil.encodeHexString(CborSerializationUtil.serialize((DataItem)this.serialize()));
        }
        catch (CborException e) {
            throw new CborSerializationException("Cbor serialization error", (Exception)((Object)e));
        }
    }

    public StakeCredType getType() {
        return this.type;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StakeCredential)) {
            return false;
        }
        StakeCredential other = (StakeCredential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StakeCredType this$type = this.getType();
        StakeCredType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return Arrays.equals(this.getHash(), other.getHash());
    }

    protected boolean canEqual(Object other) {
        return other instanceof StakeCredential;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StakeCredType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getHash());
        return result;
    }
}

