/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.util;

import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.transaction.spec.CostMdls;
import com.bloxbean.cardano.client.transaction.spec.CostModel;
import com.bloxbean.cardano.client.transaction.spec.Language;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;

public class CostModelUtil {
    private static final long[] plutusV1Costs = new long[]{205665L, 812L, 1L, 1L, 1000L, 571L, 0L, 1L, 1000L, 24177L, 4L, 1L, 1000L, 32L, 117366L, 10475L, 4L, 23000L, 100L, 23000L, 100L, 23000L, 100L, 23000L, 100L, 23000L, 100L, 23000L, 100L, 100L, 100L, 23000L, 100L, 19537L, 32L, 175354L, 32L, 46417L, 4L, 221973L, 511L, 0L, 1L, 89141L, 32L, 497525L, 14068L, 4L, 2L, 196500L, 453240L, 220L, 0L, 1L, 1L, 1000L, 28662L, 4L, 2L, 245000L, 216773L, 62L, 1L, 1060367L, 12586L, 1L, 208512L, 421L, 1L, 187000L, 1000L, 52998L, 1L, 80436L, 32L, 43249L, 32L, 1000L, 32L, 80556L, 1L, 57667L, 4L, 1000L, 10L, 197145L, 156L, 1L, 197145L, 156L, 1L, 204924L, 473L, 1L, 208896L, 511L, 1L, 52467L, 32L, 64832L, 32L, 65493L, 32L, 22558L, 32L, 16563L, 32L, 76511L, 32L, 196500L, 453240L, 220L, 0L, 1L, 1L, 69522L, 11687L, 0L, 1L, 60091L, 32L, 196500L, 453240L, 220L, 0L, 1L, 1L, 196500L, 453240L, 220L, 0L, 1L, 1L, 806990L, 30482L, 4L, 1927926L, 82523L, 4L, 265318L, 0L, 4L, 0L, 85931L, 32L, 205665L, 812L, 1L, 1L, 41182L, 32L, 212342L, 32L, 31220L, 32L, 32696L, 32L, 43357L, 32L, 32247L, 32L, 38314L, 32L, 9462713L, 1021L, 10L};
    private static final long[] plutusV2Costs = new long[]{205665L, 812L, 1L, 1L, 1000L, 571L, 0L, 1L, 1000L, 24177L, 4L, 1L, 1000L, 32L, 117366L, 10475L, 4L, 23000L, 100L, 23000L, 100L, 23000L, 100L, 23000L, 100L, 23000L, 100L, 23000L, 100L, 100L, 100L, 23000L, 100L, 19537L, 32L, 175354L, 32L, 46417L, 4L, 221973L, 511L, 0L, 1L, 89141L, 32L, 497525L, 14068L, 4L, 2L, 196500L, 453240L, 220L, 0L, 1L, 1L, 1000L, 28662L, 4L, 2L, 245000L, 216773L, 62L, 1L, 1060367L, 12586L, 1L, 208512L, 421L, 1L, 187000L, 1000L, 52998L, 1L, 80436L, 32L, 43249L, 32L, 1000L, 32L, 80556L, 1L, 57667L, 4L, 1000L, 10L, 197145L, 156L, 1L, 197145L, 156L, 1L, 204924L, 473L, 1L, 208896L, 511L, 1L, 52467L, 32L, 64832L, 32L, 65493L, 32L, 22558L, 32L, 16563L, 32L, 76511L, 32L, 196500L, 453240L, 220L, 0L, 1L, 1L, 69522L, 11687L, 0L, 1L, 60091L, 32L, 196500L, 453240L, 220L, 0L, 1L, 1L, 196500L, 453240L, 220L, 0L, 1L, 1L, 1159724L, 392670L, 0L, 2L, 806990L, 30482L, 4L, 1927926L, 82523L, 4L, 265318L, 0L, 4L, 0L, 85931L, 32L, 205665L, 812L, 1L, 1L, 41182L, 32L, 212342L, 32L, 31220L, 32L, 32696L, 32L, 43357L, 32L, 32247L, 32L, 38314L, 32L, 20000000000L, 20000000000L, 9462713L, 1021L, 10L, 20000000000L, 0L, 20000000000L};
    public static final CostModel PlutusV1CostModel = new CostModel(Language.PLUTUS_V1, plutusV1Costs);
    public static final CostModel PlutusV2CostModel = new CostModel(Language.PLUTUS_V2, plutusV2Costs);

    public static byte[] getLanguageViewsEncoding(CostModel ... costModels) {
        CostMdls costMdls = new CostMdls();
        for (CostModel cm : costModels) {
            costMdls.add(cm);
        }
        return costMdls.getLanguageViewEncoding();
    }

    public static Optional<CostModel> getCostModelFromProtocolParams(ProtocolParams protocolParams, Language language) {
        String languageKey = null;
        if (language == Language.PLUTUS_V1) {
            languageKey = "PlutusV1";
        } else if (language == Language.PLUTUS_V2) {
            languageKey = "PlutusV2";
        }
        if (protocolParams.getCostModels() == null) {
            return Optional.empty();
        }
        Map<String, Map<String, Long>> costModels = protocolParams.getCostModels();
        Map<String, Long> costModelMap = costModels.get(languageKey);
        if (costModelMap == null) {
            return Optional.empty();
        }
        long[] costModel = costModelMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> (Long)e.getValue()).mapToLong(x -> x).toArray();
        return Optional.of(new CostModel(language, costModel));
    }
}

