/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.util;

import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.util.Bech32;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AssetUtil {
    public static Tuple<String, String> getPolicyIdAndAssetName(String assetId) {
        byte[] bytes = HexUtil.decodeHexString(assetId);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        byte[] policyId = new byte[28];
        byte[] assetName = new byte[bytes.length - 28];
        bb.get(policyId, 0, policyId.length);
        bb.get(assetName, 0, assetName.length);
        return new Tuple<String, String>(HexUtil.encodeHexString(policyId), HexUtil.encodeHexString(assetName, true));
    }

    public static String calculateFingerPrint(String policyIdHex, String assetNameHex) {
        if (assetNameHex.startsWith("0x")) {
            assetNameHex = assetNameHex.substring(2);
        }
        if (policyIdHex.startsWith("0x")) {
            policyIdHex = policyIdHex.substring(2);
        }
        String assetId = policyIdHex + assetNameHex;
        byte[] hashBytes = Blake2bUtil.blake2bHash160(HexUtil.decodeHexString(assetId));
        List<Integer> words = AssetUtil.convertBits(hashBytes, 8, 5, false);
        byte[] bytes = new byte[words.size()];
        for (int i = 0; i < words.size(); ++i) {
            bytes[i] = words.get(i).byteValue();
        }
        String hrp = "asset";
        return Bech32.encode(hrp, bytes);
    }

    public static String getUnit(String policyId, Asset asset) {
        return policyId + HexUtil.encodeHexString(asset.getNameAsBytes());
    }

    public static MultiAsset getMultiAssetFromUnitAndAmount(String unit, BigInteger qty) {
        Objects.requireNonNull(unit);
        Tuple<String, String> tuple = AssetUtil.getPolicyIdAndAssetName(unit);
        return MultiAsset.builder().policyId((String)tuple._1).assets(List.of(Asset.builder().name((String)tuple._2).value(qty).build())).build();
    }

    private static List<Integer> convertBits(byte[] data, int fromWidth, int toWidth, boolean pad) {
        int acc = 0;
        int bits = 0;
        int maxv = (1 << toWidth) - 1;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < data.length; ++i) {
            int value = data[i] & 0xFF;
            if (value < 0 || value >> fromWidth != 0) {
                return null;
            }
            acc = acc << fromWidth | value;
            bits += fromWidth;
            while (bits >= toWidth) {
                ret.add(acc >> (bits -= toWidth) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                ret.add(acc << toWidth - bits & maxv);
            } else if (bits >= fromWidth || (acc << toWidth - bits & maxv) != 0) {
                return null;
            }
        }
        return ret;
    }
}

