/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.cbor;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import com.bloxbean.cardano.client.metadata.cbor.MetadataHelper;
import com.bloxbean.cardano.client.util.JsonUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CBORMetadataList {
    Array array;

    public CBORMetadataList() {
        this.array = new Array();
    }

    public CBORMetadataList(Array array) {
        this.array = array;
    }

    public CBORMetadataList add(BigInteger value) {
        this.array.add((DataItem)new UnsignedInteger(value));
        return this;
    }

    public CBORMetadataList addNegative(BigInteger value) {
        this.array.add((DataItem)new NegativeInteger(value));
        return this;
    }

    public CBORMetadataList add(String value) {
        MetadataHelper.checkLength(value);
        this.array.add((DataItem)new UnicodeString(value));
        return this;
    }

    public CBORMetadataList addAll(String[] value) {
        for (String str : value) {
            MetadataHelper.checkLength(str);
            this.array.add((DataItem)new UnicodeString(str));
        }
        return this;
    }

    public CBORMetadataList add(byte[] value) {
        this.array.add((DataItem)new ByteString(value));
        return this;
    }

    public CBORMetadataList add(CBORMetadataMap map) {
        if (map != null) {
            this.array.add((DataItem)map.getMap());
        }
        return this;
    }

    public CBORMetadataList add(CBORMetadataList list) {
        if (list != null) {
            this.array.add((DataItem)list.getArray());
        }
        return this;
    }

    public void replaceAt(int index, BigInteger value) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(value));
    }

    public void replaceAt(int index, String value) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(value));
    }

    public void replaceAt(int index, byte[] value) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(value));
    }

    public void replaceAt(int index, CBORMetadataMap map) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(map));
    }

    public void replaceAt(int index, CBORMetadataList list) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(list));
    }

    public void removeItem(Object value) {
        this.array.getDataItems().remove(MetadataHelper.objectToDataItem(value));
    }

    public void removeItemAt(int index) {
        if (index != -1 && index < this.array.getDataItems().size()) {
            this.array.getDataItems().remove(index);
        }
    }

    public Object getValueAt(int index) {
        if (index != -1 && index < this.array.getDataItems().size()) {
            DataItem dataItem = (DataItem)this.array.getDataItems().get(index);
            return MetadataHelper.extractActualValue(dataItem);
        }
        return null;
    }

    public int size() {
        if (this.array.getDataItems() != null) {
            return this.array.getDataItems().size();
        }
        return 0;
    }

    public Array getArray() {
        return this.array;
    }

    private void replaceAt(int index, DataItem value) {
        if (index == -1) {
            return;
        }
        this.array.getDataItems().remove(index);
        this.array.getDataItems().add(index, value);
    }

    public String toJson() {
        List dataItemList = this.array.getDataItems();
        ArrayList<Object> list = new ArrayList<Object>();
        for (DataItem di : dataItemList) {
            list.add(MetadataHelper.extractActualValue(di));
        }
        return JsonUtil.getPrettyJson(list);
    }
}

