/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.cbor;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.metadata.MetadataList;
import com.bloxbean.cardano.client.metadata.MetadataMap;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import com.bloxbean.cardano.client.metadata.cbor.MetadataHelper;
import com.bloxbean.cardano.client.metadata.helper.MetadataToJsonNoSchemaConverter;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.bloxbean.cardano.client.util.StringUtils;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;

public class CBORMetadataMap
implements MetadataMap {
    private Map map;

    public CBORMetadataMap() {
        this.map = new Map();
    }

    public CBORMetadataMap(Map map) {
        this.map = map;
    }

    @Override
    public CBORMetadataMap put(BigInteger key, BigInteger value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new UnsignedInteger(value));
        return this;
    }

    @Override
    public CBORMetadataMap putNegative(BigInteger key, BigInteger value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new NegativeInteger(value));
        return this;
    }

    @Override
    public CBORMetadataMap put(BigInteger key, byte[] value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new ByteString(value));
        return this;
    }

    @Override
    public CBORMetadataMap put(BigInteger key, String value) {
        MetadataHelper.checkLength(value);
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new UnicodeString(value));
        return this;
    }

    @Override
    public CBORMetadataMap put(BigInteger key, MetadataMap value) {
        if (value != null) {
            this.map.put((DataItem)new UnsignedInteger(key), (DataItem)value.getMap());
        }
        return this;
    }

    @Override
    public CBORMetadataMap put(BigInteger key, MetadataList list) {
        if (list != null) {
            this.map.put((DataItem)new UnsignedInteger(key), (DataItem)list.getArray());
        }
        return this;
    }

    @Override
    public CBORMetadataMap put(String key, BigInteger value) {
        this.map.put((DataItem)new UnicodeString(key), (DataItem)new UnsignedInteger(value));
        return this;
    }

    @Override
    public CBORMetadataMap putNegative(String key, BigInteger value) {
        this.map.put((DataItem)new UnicodeString(key), (DataItem)new NegativeInteger(value));
        return this;
    }

    @Override
    public CBORMetadataMap put(String key, byte[] value) {
        this.map.put((DataItem)new UnicodeString(key), (DataItem)new ByteString(value));
        return this;
    }

    @Override
    public CBORMetadataMap put(String key, String value) {
        if (MetadataHelper.checkLength(value) > 64) {
            CBORMetadataList cborMetadataList = new CBORMetadataList();
            cborMetadataList.addAll(StringUtils.splitStringEveryNCharacters((String)value, (int)64));
            this.map.put((DataItem)new UnicodeString(key), (DataItem)cborMetadataList.getArray());
        } else {
            this.map.put((DataItem)new UnicodeString(key), (DataItem)new UnicodeString(value));
        }
        return this;
    }

    @Override
    public CBORMetadataMap put(String key, MetadataMap value) {
        if (value != null) {
            this.map.put((DataItem)new UnicodeString(key), (DataItem)value.getMap());
        }
        return this;
    }

    @Override
    public CBORMetadataMap put(String key, MetadataList list) {
        if (list != null) {
            this.map.put((DataItem)new UnicodeString(key), (DataItem)list.getArray());
        }
        return this;
    }

    @Override
    public CBORMetadataMap put(byte[] key, BigInteger value) {
        this.map.put((DataItem)new ByteString(key), (DataItem)new UnsignedInteger(value));
        return this;
    }

    @Override
    public CBORMetadataMap putNegative(byte[] key, BigInteger value) {
        this.map.put((DataItem)new ByteString(key), (DataItem)new NegativeInteger(value));
        return this;
    }

    @Override
    public CBORMetadataMap put(byte[] key, byte[] value) {
        this.map.put((DataItem)new ByteString(key), (DataItem)new ByteString(value));
        return this;
    }

    @Override
    public CBORMetadataMap put(byte[] key, String value) {
        MetadataHelper.checkLength(value);
        this.map.put((DataItem)new ByteString(key), (DataItem)new UnicodeString(value));
        return this;
    }

    @Override
    public CBORMetadataMap put(byte[] key, MetadataMap value) {
        if (value != null) {
            this.map.put((DataItem)new ByteString(key), (DataItem)value.getMap());
        }
        return this;
    }

    @Override
    public CBORMetadataMap put(byte[] key, MetadataList list) {
        if (list != null) {
            this.map.put((DataItem)new ByteString(key), (DataItem)list.getArray());
        }
        return this;
    }

    @Override
    public Object get(String key) {
        return MetadataHelper.extractActualValue(this.map.get(MetadataHelper.objectToDataItem(key)));
    }

    @Override
    public Object get(BigInteger key) {
        return MetadataHelper.extractActualValue(this.map.get(MetadataHelper.objectToDataItem(key)));
    }

    @Override
    public Object get(byte[] key) {
        return MetadataHelper.extractActualValue(this.map.get(MetadataHelper.objectToDataItem(key)));
    }

    @Override
    public void remove(String key) {
        this.map.remove(MetadataHelper.objectToDataItem(key));
    }

    @Override
    public void remove(BigInteger key) {
        this.map.remove(MetadataHelper.objectToDataItem(key));
    }

    @Override
    public void remove(byte[] key) {
        this.map.remove(MetadataHelper.objectToDataItem(key));
    }

    @Override
    public List keys() {
        return this.map.getKeys().stream().map(di -> MetadataHelper.extractActualValue(di)).collect(Collectors.toList());
    }

    @Override
    public Map getMap() {
        return this.map;
    }

    @Override
    public String toJson() throws CborException {
        byte[] bytes = CborSerializationUtil.serialize((DataItem)this.map);
        String json = MetadataToJsonNoSchemaConverter.cborBytesToJson(bytes);
        return JsonUtil.getPrettyJson((String)json);
    }
}

