/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.cbor;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataHelper {
    private static final Logger log = LoggerFactory.getLogger(MetadataHelper.class);

    public static Object extractActualValue(DataItem dataItem) {
        if (dataItem instanceof UnicodeString) {
            return ((UnicodeString)dataItem).getString();
        }
        if (dataItem instanceof UnsignedInteger) {
            return ((UnsignedInteger)dataItem).getValue();
        }
        if (dataItem instanceof NegativeInteger) {
            return ((NegativeInteger)dataItem).getValue();
        }
        if (dataItem instanceof ByteString) {
            return ((ByteString)dataItem).getBytes();
        }
        if (dataItem instanceof Map) {
            return new CBORMetadataMap((Map)dataItem);
        }
        if (dataItem instanceof Array) {
            return new CBORMetadataList((Array)dataItem);
        }
        return dataItem;
    }

    public static DataItem objectToDataItem(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new UnicodeString((String)value);
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).compareTo(BigInteger.ZERO) == -1) {
                return new NegativeInteger((BigInteger)value);
            }
            return new UnsignedInteger((BigInteger)value);
        }
        if (value instanceof byte[]) {
            return new ByteString((byte[])value);
        }
        if (value instanceof CBORMetadataMap) {
            return ((CBORMetadataMap)value).getMap();
        }
        if (value instanceof CBORMetadataList) {
            return ((CBORMetadataList)value).getArray();
        }
        throw new RuntimeException("Unknown object type : " + value.getClass());
    }

    public static int checkLength(String str) {
        if (str == null) {
            return 0;
        }
        if (str.getBytes(StandardCharsets.UTF_8).length > 64) {
            log.warn("Strings in metadata must be at most 64 bytes when UTF-8 encoded (auto converted to list of max 64 bytes). >> " + str);
        }
        return str.getBytes(StandardCharsets.UTF_8).length;
    }
}

