/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.helper;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.metadata.exception.MetadataDeSerializationException;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class MetadataToJsonNoSchemaConverter {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String cborBytesToJson(byte[] cborBytes) {
        try {
            return MetadataToJsonNoSchemaConverter.cborHexToJson(HexUtil.encodeHexString((byte[])cborBytes));
        }
        catch (Exception e) {
            throw new MetadataDeSerializationException("Deserialization error", e);
        }
    }

    public static String cborHexToJson(String hex) {
        try {
            java.util.Map result = MetadataToJsonNoSchemaConverter.cborHexToJavaMap(hex);
            return objectMapper.writeValueAsString((Object)result);
        }
        catch (Exception e) {
            throw new MetadataDeSerializationException("Deserialization error", e);
        }
    }

    private static java.util.Map cborHexToJavaMap(String hex) throws CborDeserializationException {
        byte[] cborBytes = HexUtil.decodeHexString((String)hex);
        List dataItemList = null;
        try {
            dataItemList = CborDecoder.decode((byte[])cborBytes);
        }
        catch (CborException e) {
            throw new CborDeserializationException("Cbor deserialization failed", (Exception)((Object)e));
        }
        if (dataItemList != null && dataItemList.size() > 1) {
            throw new MetadataDeSerializationException("Multiple DataItems found at top level. Should be zero : " + dataItemList.size());
        }
        java.util.Map result = new HashMap();
        DataItem dataItem = (DataItem)dataItemList.get(0);
        if (!(dataItem instanceof Map)) {
            throw new MetadataDeSerializationException("Top leve object should be a Map : " + dataItem.getMajorType().toString());
        }
        result = MetadataToJsonNoSchemaConverter.processMap((Map)dataItem);
        return result;
    }

    private static java.util.Map processMap(Map map) {
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        Collection keys = map.getKeys();
        for (DataItem keyItem : keys) {
            DataItem valueItem = map.get(keyItem);
            Object key = MetadataToJsonNoSchemaConverter.processKey(keyItem);
            Object value = MetadataToJsonNoSchemaConverter.processValue(valueItem);
            resultMap.put(key, value);
        }
        return resultMap;
    }

    private static Object processKey(DataItem keyItem) {
        if (MajorType.UNSIGNED_INTEGER.equals((Object)keyItem.getMajorType())) {
            return ((UnsignedInteger)keyItem).getValue();
        }
        if (MajorType.NEGATIVE_INTEGER.equals((Object)keyItem.getMajorType())) {
            return ((NegativeInteger)keyItem).getValue();
        }
        if (MajorType.BYTE_STRING.equals((Object)keyItem.getMajorType())) {
            byte[] bytes = ((ByteString)keyItem).getBytes();
            return "0x" + HexUtil.encodeHexString((byte[])bytes);
        }
        if (MajorType.UNICODE_STRING.equals((Object)keyItem.getMajorType())) {
            return ((UnicodeString)keyItem).getString();
        }
        throw new MetadataDeSerializationException("Invalid key type : " + keyItem.getMajorType());
    }

    private static Object processValue(DataItem valueItem) {
        if (MajorType.UNSIGNED_INTEGER.equals((Object)valueItem.getMajorType())) {
            return ((UnsignedInteger)valueItem).getValue();
        }
        if (MajorType.NEGATIVE_INTEGER.equals((Object)valueItem.getMajorType())) {
            return ((NegativeInteger)valueItem).getValue();
        }
        if (MajorType.BYTE_STRING.equals((Object)valueItem.getMajorType())) {
            byte[] bytes = ((ByteString)valueItem).getBytes();
            return "0x" + HexUtil.encodeHexString((byte[])bytes);
        }
        if (MajorType.UNICODE_STRING.equals((Object)valueItem.getMajorType())) {
            return ((UnicodeString)valueItem).getString();
        }
        if (MajorType.MAP.equals((Object)valueItem.getMajorType())) {
            return MetadataToJsonNoSchemaConverter.processMap((Map)valueItem);
        }
        if (MajorType.ARRAY.equals((Object)valueItem.getMajorType())) {
            return MetadataToJsonNoSchemaConverter.processArray((Array)valueItem);
        }
        throw new MetadataDeSerializationException("Unsupported type : " + valueItem.getMajorType());
    }

    private static Object processArray(Array array) {
        List dataItems = array.getDataItems();
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (DataItem valueItem : dataItems) {
            Object valueObj = MetadataToJsonNoSchemaConverter.processValue(valueItem);
            resultList.add(valueObj);
        }
        return resultList;
    }
}

