/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.cbor;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.metadata.MetadataList;
import com.bloxbean.cardano.client.metadata.MetadataMap;
import com.bloxbean.cardano.client.metadata.cbor.MetadataHelper;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.bloxbean.cardano.client.util.StringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CBORMetadataList
implements MetadataList {
    Array array;

    public CBORMetadataList() {
        this.array = new Array();
    }

    public CBORMetadataList(Array array) {
        this.array = array;
    }

    @Override
    public CBORMetadataList add(BigInteger value) {
        this.array.add((DataItem)new UnsignedInteger(value));
        return this;
    }

    @Override
    public CBORMetadataList addNegative(BigInteger value) {
        this.array.add((DataItem)new NegativeInteger(value));
        return this;
    }

    @Override
    public CBORMetadataList add(String value) {
        if (MetadataHelper.checkLength(value) > 64) {
            CBORMetadataList cborMetadataList = new CBORMetadataList();
            cborMetadataList.addAll(StringUtils.splitStringEveryNCharacters((String)value, (int)64));
            this.array.add((DataItem)cborMetadataList.getArray());
        } else {
            this.array.add((DataItem)new UnicodeString(value));
        }
        return this;
    }

    @Override
    public CBORMetadataList addAll(String[] value) {
        for (String str : value) {
            if (MetadataHelper.checkLength(str) > 64) {
                CBORMetadataList cborMetadataList = new CBORMetadataList();
                cborMetadataList.addAll(StringUtils.splitStringEveryNCharacters((String)str, (int)64));
                this.array.add((DataItem)cborMetadataList.getArray());
                continue;
            }
            this.array.add((DataItem)new UnicodeString(str));
        }
        return this;
    }

    @Override
    public CBORMetadataList add(byte[] value) {
        this.array.add((DataItem)new ByteString(value));
        return this;
    }

    @Override
    public CBORMetadataList add(MetadataMap map) {
        if (map != null) {
            this.array.add((DataItem)map.getMap());
        }
        return this;
    }

    @Override
    public CBORMetadataList add(MetadataList list) {
        if (list != null) {
            this.array.add((DataItem)list.getArray());
        }
        return this;
    }

    @Override
    public void replaceAt(int index, BigInteger value) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(value));
    }

    @Override
    public void replaceAt(int index, String value) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(value));
    }

    @Override
    public void replaceAt(int index, byte[] value) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(value));
    }

    @Override
    public void replaceAt(int index, MetadataMap map) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(map));
    }

    @Override
    public void replaceAt(int index, MetadataList list) {
        this.replaceAt(index, MetadataHelper.objectToDataItem(list));
    }

    @Override
    public void removeItem(Object value) {
        this.array.getDataItems().remove(MetadataHelper.objectToDataItem(value));
    }

    @Override
    public void removeItemAt(int index) {
        if (index != -1 && index < this.array.getDataItems().size()) {
            this.array.getDataItems().remove(index);
        }
    }

    @Override
    public Object getValueAt(int index) {
        if (index != -1 && index < this.array.getDataItems().size()) {
            DataItem dataItem = (DataItem)this.array.getDataItems().get(index);
            return MetadataHelper.extractActualValue(dataItem);
        }
        return null;
    }

    @Override
    public int size() {
        if (this.array.getDataItems() != null) {
            return this.array.getDataItems().size();
        }
        return 0;
    }

    @Override
    public Array getArray() {
        return this.array;
    }

    private void replaceAt(int index, DataItem value) {
        if (index == -1) {
            return;
        }
        this.array.getDataItems().remove(index);
        this.array.getDataItems().add(index, value);
    }

    @Override
    public String toJson() {
        List dataItemList = this.array.getDataItems();
        ArrayList<Object> list = new ArrayList<Object>();
        for (DataItem di : dataItemList) {
            list.add(MetadataHelper.extractActualValue(di));
        }
        return JsonUtil.getPrettyJson(list);
    }
}

