/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.serializers.BytesDataJsonDeserializer;
import com.bloxbean.cardano.client.plutus.spec.serializers.BytesDataJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@JsonSerialize(using=BytesDataJsonSerializer.class)
@JsonDeserialize(using=BytesDataJsonDeserializer.class)
public class BytesPlutusData
implements PlutusData {
    private byte[] value;

    public static BytesPlutusData deserialize(ByteString valueDI) throws CborDeserializationException {
        if (valueDI == null) {
            return null;
        }
        return new BytesPlutusData(valueDI.getBytes());
    }

    public static BytesPlutusData of(byte[] bytes) {
        return new BytesPlutusData(bytes);
    }

    public static BytesPlutusData of(String str) {
        return new BytesPlutusData(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public DataItem serialize() throws CborSerializationException {
        ByteString di = null;
        if (this.value != null) {
            di = new ByteString(this.value);
        }
        return di;
    }

    public static BytesPlutusDataBuilder builder() {
        return new BytesPlutusDataBuilder();
    }

    public byte[] getValue() {
        return this.value;
    }

    public BytesPlutusData(byte[] value) {
        this.value = value;
    }

    public BytesPlutusData() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BytesPlutusData)) {
            return false;
        }
        BytesPlutusData other = (BytesPlutusData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BytesPlutusData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    public static class BytesPlutusDataBuilder {
        private byte[] value;

        BytesPlutusDataBuilder() {
        }

        public BytesPlutusDataBuilder value(byte[] value) {
            this.value = value;
            return this;
        }

        public BytesPlutusData build() {
            return new BytesPlutusData(this.value);
        }

        public String toString() {
            return "BytesPlutusData.BytesPlutusDataBuilder(value=" + Arrays.toString(this.value) + ")";
        }
    }
}

