/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.Special;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.CostModel;
import com.bloxbean.cardano.client.plutus.spec.Language;
import java.util.HashMap;
import java.util.Map;

public class CostMdls {
    private java.util.Map<Language, CostModel> costMdlsMap = new HashMap<Language, CostModel>();

    public void add(CostModel costModel) {
        this.costMdlsMap.put(costModel.getLanguage(), costModel);
    }

    public CostModel get(Language language) {
        return this.costMdlsMap.get((Object)language);
    }

    public byte[] getLanguageViewEncoding() {
        try {
            Map cborMap = this.serialize();
            return CborSerializationUtil.serialize((DataItem)cborMap);
        }
        catch (Exception ex) {
            throw new CborRuntimeException("Language views encoding failed", ex);
        }
    }

    public boolean isEmpty() {
        return this.costMdlsMap.isEmpty();
    }

    public Map serialize() throws CborSerializationException {
        Map cborMap = new Map();
        try {
            for (Map.Entry<Language, CostModel> entry : this.costMdlsMap.entrySet()) {
                Language language = entry.getKey();
                CostModel costModel = entry.getValue();
                if (language == Language.PLUTUS_V1) {
                    this.serializeV1(cborMap, costModel);
                    continue;
                }
                if (language == Language.PLUTUS_V2) {
                    this.serializeV2(cborMap, costModel);
                    continue;
                }
                throw new CborSerializationException("Invalid language : " + language);
            }
        }
        catch (Exception e) {
            throw new CborSerializationException("Costmdls serialization error", e);
        }
        return cborMap;
    }

    private void serializeV2(Map cborMap, CostModel costModel) {
        UnsignedInteger key = new UnsignedInteger((long)costModel.getLanguage().getKey());
        Array valueArr = new Array();
        for (long cost : costModel.getCosts()) {
            if (cost >= 0L) {
                valueArr.add((DataItem)new UnsignedInteger(cost));
                continue;
            }
            valueArr.add((DataItem)new NegativeInteger(cost));
        }
        cborMap.put((DataItem)key, (DataItem)valueArr);
    }

    private void serializeV1(Map cborMap, CostModel costModel) throws CborException {
        UnsignedInteger key = new UnsignedInteger((long)costModel.getLanguage().getKey());
        ByteString keyByteStr = new ByteString(CborSerializationUtil.serialize((DataItem)key));
        Array valueArr = new Array();
        valueArr.setChunked(true);
        for (long cost : costModel.getCosts()) {
            if (cost >= 0L) {
                valueArr.add((DataItem)new UnsignedInteger(cost));
                continue;
            }
            valueArr.add((DataItem)new NegativeInteger(cost));
        }
        valueArr.add((DataItem)Special.BREAK);
        ByteString valueBS = new ByteString(CborSerializationUtil.serialize((DataItem)valueArr));
        cborMap.put((DataItem)keyByteStr, (DataItem)valueBS);
    }

    public static CostMdls deserialize(DataItem di) throws CborDeserializationException {
        Map map = (Map)di;
        CostMdls costMdls = new CostMdls();
        for (DataItem key : map.getKeys()) {
            Language language;
            Array costModelArr;
            int langKey;
            if (key.getMajorType() == MajorType.BYTE_STRING) {
                UnsignedInteger intKey = (UnsignedInteger)CborSerializationUtil.deserialize((byte[])((ByteString)key).getBytes());
                langKey = intKey.getValue().intValue();
                ByteString valueBS = (ByteString)map.get(key);
                costModelArr = (Array)CborSerializationUtil.deserialize((byte[])valueBS.getBytes());
            } else {
                langKey = ((UnsignedInteger)key).getValue().intValue();
                costModelArr = (Array)map.get(key);
            }
            long[] costs = new long[costModelArr.getDataItems().size()];
            int index = 0;
            for (DataItem costItem : costModelArr.getDataItems()) {
                long cost = 0L;
                if (costItem instanceof UnsignedInteger) {
                    cost = ((UnsignedInteger)costItem).getValue().longValue();
                } else if (costItem instanceof NegativeInteger) {
                    cost = ((NegativeInteger)costItem).getValue().longValue();
                }
                costs[index++] = cost;
            }
            if (langKey == 0) {
                language = Language.PLUTUS_V1;
            } else if (langKey == 1) {
                language = Language.PLUTUS_V2;
            } else {
                throw new CborDeserializationException("De-serialization failed. Invalid language key : " + langKey);
            }
            CostModel costModel = new CostModel(language, costs);
            costMdls.add(costModel);
        }
        return costMdls;
    }
}

