/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.RationalNumber;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.UnitInterval;
import java.math.BigInteger;
import java.util.List;

public class ExUnitPrices {
    private UnitInterval memPrice;
    private UnitInterval stepPrice;

    public DataItem serialize() throws CborSerializationException {
        Array array = new Array();
        try {
            RationalNumber memPriceRN = new RationalNumber(CborSerializationUtil.bigIntegerToDataItem((BigInteger)this.memPrice.getNumerator()), CborSerializationUtil.bigIntegerToDataItem((BigInteger)this.memPrice.getDenominator()));
            RationalNumber stepPriceRN = new RationalNumber(CborSerializationUtil.bigIntegerToDataItem((BigInteger)this.stepPrice.getNumerator()), CborSerializationUtil.bigIntegerToDataItem((BigInteger)this.stepPrice.getDenominator()));
            array.add((DataItem)memPriceRN);
            array.add((DataItem)stepPriceRN);
        }
        catch (Exception e) {
            throw new CborSerializationException("ExUnitPrices serialization error", e);
        }
        return array;
    }

    public static ExUnitPrices deserialize(DataItem di) throws CborDeserializationException {
        List dataItemList = ((Array)di).getDataItems();
        if (dataItemList.size() < 2) {
            throw new CborDeserializationException("Invalid no of items. Expected : 2, found : " + dataItemList.size());
        }
        RationalNumber memPriceRN = (RationalNumber)dataItemList.get(0);
        RationalNumber stepPriceRN = (RationalNumber)dataItemList.get(1);
        UnitInterval memPrice = new UnitInterval(memPriceRN.getNumerator().getValue(), memPriceRN.getDenominator().getValue());
        UnitInterval stepPrice = new UnitInterval(stepPriceRN.getNumerator().getValue(), stepPriceRN.getDenominator().getValue());
        return new ExUnitPrices(memPrice, stepPrice);
    }

    public static ExUnitPricesBuilder builder() {
        return new ExUnitPricesBuilder();
    }

    public UnitInterval getMemPrice() {
        return this.memPrice;
    }

    public UnitInterval getStepPrice() {
        return this.stepPrice;
    }

    public ExUnitPrices(UnitInterval memPrice, UnitInterval stepPrice) {
        this.memPrice = memPrice;
        this.stepPrice = stepPrice;
    }

    public ExUnitPrices() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExUnitPrices)) {
            return false;
        }
        ExUnitPrices other = (ExUnitPrices)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnitInterval this$memPrice = this.getMemPrice();
        UnitInterval other$memPrice = other.getMemPrice();
        if (this$memPrice == null ? other$memPrice != null : !this$memPrice.equals(other$memPrice)) {
            return false;
        }
        UnitInterval this$stepPrice = this.getStepPrice();
        UnitInterval other$stepPrice = other.getStepPrice();
        return !(this$stepPrice == null ? other$stepPrice != null : !this$stepPrice.equals(other$stepPrice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExUnitPrices;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnitInterval $memPrice = this.getMemPrice();
        result = result * 59 + ($memPrice == null ? 43 : $memPrice.hashCode());
        UnitInterval $stepPrice = this.getStepPrice();
        result = result * 59 + ($stepPrice == null ? 43 : $stepPrice.hashCode());
        return result;
    }

    public String toString() {
        return "ExUnitPrices(memPrice=" + this.getMemPrice() + ", stepPrice=" + this.getStepPrice() + ")";
    }

    public static class ExUnitPricesBuilder {
        private UnitInterval memPrice;
        private UnitInterval stepPrice;

        ExUnitPricesBuilder() {
        }

        public ExUnitPricesBuilder memPrice(UnitInterval memPrice) {
            this.memPrice = memPrice;
            return this;
        }

        public ExUnitPricesBuilder stepPrice(UnitInterval stepPrice) {
            this.stepPrice = stepPrice;
            return this;
        }

        public ExUnitPrices build() {
            return new ExUnitPrices(this.memPrice, this.stepPrice);
        }

        public String toString() {
            return "ExUnitPrices.ExUnitPricesBuilder(memPrice=" + this.memPrice + ", stepPrice=" + this.stepPrice + ")";
        }
    }
}

