/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import java.math.BigInteger;
import java.util.List;

public class ExUnits {
    private BigInteger mem;
    private BigInteger steps;

    public Array serialize() {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(this.mem));
        array.add((DataItem)new UnsignedInteger(this.steps));
        return array;
    }

    public static ExUnits deserialize(Array exUnitDI) throws CborDeserializationException {
        List dataItemList = exUnitDI.getDataItems();
        if (dataItemList == null || dataItemList.size() != 2) {
            throw new CborDeserializationException("ExUnits deserialization error. Invalid no of DataItem");
        }
        DataItem memDI = (DataItem)dataItemList.get(0);
        DataItem stepsDI = (DataItem)dataItemList.get(1);
        ExUnits exUnits = new ExUnits();
        exUnits.setMem(((UnsignedInteger)memDI).getValue());
        exUnits.setSteps(((UnsignedInteger)stepsDI).getValue());
        return exUnits;
    }

    public static ExUnitsBuilder builder() {
        return new ExUnitsBuilder();
    }

    public BigInteger getMem() {
        return this.mem;
    }

    public BigInteger getSteps() {
        return this.steps;
    }

    public void setMem(BigInteger mem) {
        this.mem = mem;
    }

    public void setSteps(BigInteger steps) {
        this.steps = steps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExUnits)) {
            return false;
        }
        ExUnits other = (ExUnits)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$mem = this.getMem();
        BigInteger other$mem = other.getMem();
        if (this$mem == null ? other$mem != null : !((Object)this$mem).equals(other$mem)) {
            return false;
        }
        BigInteger this$steps = this.getSteps();
        BigInteger other$steps = other.getSteps();
        return !(this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExUnits;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $mem = this.getMem();
        result = result * 59 + ($mem == null ? 43 : ((Object)$mem).hashCode());
        BigInteger $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        return result;
    }

    public String toString() {
        return "ExUnits(mem=" + this.getMem() + ", steps=" + this.getSteps() + ")";
    }

    public ExUnits(BigInteger mem, BigInteger steps) {
        this.mem = mem;
        this.steps = steps;
    }

    public ExUnits() {
    }

    public static class ExUnitsBuilder {
        private BigInteger mem;
        private BigInteger steps;

        ExUnitsBuilder() {
        }

        public ExUnitsBuilder mem(BigInteger mem) {
            this.mem = mem;
            return this;
        }

        public ExUnitsBuilder steps(BigInteger steps) {
            this.steps = steps;
            return this;
        }

        public ExUnits build() {
            return new ExUnits(this.mem, this.steps);
        }

        public String toString() {
            return "ExUnits.ExUnitsBuilder(mem=" + this.mem + ", steps=" + this.steps + ")";
        }
    }
}

