/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.util.HexUtil;

public class PlutusV1Script
extends PlutusScript {
    public PlutusV1Script() {
        this.type = "PlutusScriptV1";
    }

    public static PlutusV1Script deserialize(ByteString plutusScriptDI) throws CborDeserializationException {
        if (plutusScriptDI != null) {
            byte[] bytes;
            PlutusV1Script plutusScript = new PlutusV1Script();
            try {
                bytes = CborSerializationUtil.serialize((DataItem)plutusScriptDI);
            }
            catch (CborException e) {
                throw new CborDeserializationException("CBor deserialization error", (Exception)((Object)e));
            }
            plutusScript.setCborHex(HexUtil.encodeHexString((byte[])bytes));
            return plutusScript;
        }
        return null;
    }

    public byte[] getScriptTypeBytes() {
        return new byte[]{(byte)this.getScriptType()};
    }

    public int getScriptType() {
        return 1;
    }

    protected PlutusV1Script(PlutusV1ScriptBuilder<?, ?> b) {
        super(b);
    }

    public static PlutusV1ScriptBuilder<?, ?> builder() {
        return new PlutusV1ScriptBuilderImpl();
    }

    private static final class PlutusV1ScriptBuilderImpl
    extends PlutusV1ScriptBuilder<PlutusV1Script, PlutusV1ScriptBuilderImpl> {
        private PlutusV1ScriptBuilderImpl() {
        }

        @Override
        protected PlutusV1ScriptBuilderImpl self() {
            return this;
        }

        @Override
        public PlutusV1Script build() {
            return new PlutusV1Script(this);
        }
    }

    public static abstract class PlutusV1ScriptBuilder<C extends PlutusV1Script, B extends PlutusV1ScriptBuilder<C, B>>
    extends PlutusScript.PlutusScriptBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "PlutusV1Script.PlutusV1ScriptBuilder(super=" + super.toString() + ")";
        }
    }
}

