/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.util;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.client.plutus.util.Bytes;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;

public class ScriptDataHashGenerator {
    public static byte[] generate(List<Redeemer> redeemers, List<PlutusData> datums, String languageViewsHex) throws CborException, CborSerializationException {
        return ScriptDataHashGenerator.generate(redeemers, datums, HexUtil.decodeHexString((String)languageViewsHex));
    }

    public static byte[] generate(List<Redeemer> redeemers, List<PlutusData> datums, byte[] langViewsBytes) throws CborSerializationException, CborException {
        byte[] encodedBytes;
        Array datumArray = new Array();
        if (datums != null && datums.size() > 0) {
            for (PlutusData datum : datums) {
                datumArray.add(datum.serialize());
            }
        }
        byte[] plutusDataBytes = datumArray.getDataItems().size() != 0 ? CborSerializationUtil.serialize((DataItem)datumArray) : new byte[]{};
        if (redeemers != null && redeemers.size() > 0) {
            Array redeemerArray = new Array();
            for (Redeemer redeemer : redeemers) {
                redeemerArray.add((DataItem)redeemer.serialize());
            }
            byte[] redeemerBytes = CborSerializationUtil.serialize((DataItem)redeemerArray);
            encodedBytes = Bytes.concat(redeemerBytes, plutusDataBytes, langViewsBytes);
        } else {
            encodedBytes = Bytes.concat(HexUtil.decodeHexString((String)"0x80"), plutusDataBytes, HexUtil.decodeHexString((String)"0xA0"));
        }
        return Blake2bUtil.blake2bHash256((byte[])encodedBytes);
    }
}

