/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.blueprint.model;

import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintDatatype;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BlueprintSchema {
    @JsonAlias(value={"$ref", "ref"})
    private String ref;
    @JsonIgnore
    private BlueprintSchema refSchema;
    private List<BlueprintSchema> anyOf;
    private List<BlueprintSchema> oneOf;
    private List<BlueprintSchema> allOf;
    private List<BlueprintSchema> notOf;
    private String title;
    private String description;
    private BlueprintDatatype dataType;
    @JsonAlias(value={"$comment", "comment"})
    private String comment;
    @JsonAlias(value={"enum"})
    private String[] enumLiterals;
    private int maxLength;
    private int minLength;
    private int multipleOf;
    private int maximum;
    private int exclusiveMaximum;
    private int minimum;
    private int exclusiveMinimum;
    private BlueprintSchema items;
    private int maxItems;
    private int minItems;
    private boolean uniqueItems;
    private BlueprintSchema keys;
    private BlueprintSchema values;
    private int index;
    private List<BlueprintSchema> fields;
    private BlueprintSchema left;
    private BlueprintSchema right;

    public void copyFrom(BlueprintSchema blueprintSchema) {
        this.refSchema = blueprintSchema;
        this.anyOf = this.anyOf != null ? this.anyOf : blueprintSchema.anyOf;
        this.oneOf = this.oneOf != null ? this.oneOf : blueprintSchema.oneOf;
        this.allOf = this.allOf != null ? this.allOf : blueprintSchema.allOf;
        this.notOf = this.notOf != null ? this.notOf : blueprintSchema.notOf;
        this.title = this.title != null ? this.title : blueprintSchema.title;
        this.description = this.description != null ? this.description : blueprintSchema.description;
        this.dataType = this.dataType != null ? this.dataType : blueprintSchema.dataType;
        this.comment = this.comment != null ? this.comment : blueprintSchema.comment;
        this.enumLiterals = this.enumLiterals != null ? this.enumLiterals : blueprintSchema.enumLiterals;
        this.maxLength = this.maxLength != 0 ? this.maxLength : blueprintSchema.maxLength;
        this.minLength = this.minLength != 0 ? this.minLength : blueprintSchema.minLength;
        this.multipleOf = this.multipleOf != 0 ? this.multipleOf : blueprintSchema.multipleOf;
        this.maximum = this.maximum != 0 ? this.maximum : blueprintSchema.maximum;
        this.exclusiveMaximum = this.exclusiveMaximum != 0 ? this.exclusiveMaximum : blueprintSchema.exclusiveMaximum;
        this.minimum = this.minimum != 0 ? this.minimum : blueprintSchema.minimum;
        this.exclusiveMinimum = this.exclusiveMinimum != 0 ? this.exclusiveMinimum : blueprintSchema.exclusiveMinimum;
        this.items = this.items != null ? this.items : blueprintSchema.items;
        this.maxItems = this.maxItems != 0 ? this.maxItems : blueprintSchema.maxItems;
        this.minItems = this.minItems != 0 ? this.minItems : blueprintSchema.minItems;
        this.uniqueItems = this.uniqueItems || blueprintSchema.uniqueItems;
        this.keys = this.keys != null ? this.keys : blueprintSchema.keys;
        this.values = this.values != null ? this.values : blueprintSchema.values;
        this.index = this.index != 0 ? this.index : blueprintSchema.index;
        this.fields = this.fields != null ? this.fields : blueprintSchema.fields;
        this.left = this.left != null ? this.left : blueprintSchema.left;
        this.right = this.right != null ? this.right : blueprintSchema.right;
    }

    public String getRef() {
        return this.ref;
    }

    public BlueprintSchema getRefSchema() {
        return this.refSchema;
    }

    public List<BlueprintSchema> getAnyOf() {
        return this.anyOf;
    }

    public List<BlueprintSchema> getOneOf() {
        return this.oneOf;
    }

    public List<BlueprintSchema> getAllOf() {
        return this.allOf;
    }

    public List<BlueprintSchema> getNotOf() {
        return this.notOf;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public BlueprintDatatype getDataType() {
        return this.dataType;
    }

    public String getComment() {
        return this.comment;
    }

    public String[] getEnumLiterals() {
        return this.enumLiterals;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMultipleOf() {
        return this.multipleOf;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public BlueprintSchema getItems() {
        return this.items;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public int getMinItems() {
        return this.minItems;
    }

    public boolean isUniqueItems() {
        return this.uniqueItems;
    }

    public BlueprintSchema getKeys() {
        return this.keys;
    }

    public BlueprintSchema getValues() {
        return this.values;
    }

    public int getIndex() {
        return this.index;
    }

    public List<BlueprintSchema> getFields() {
        return this.fields;
    }

    public BlueprintSchema getLeft() {
        return this.left;
    }

    public BlueprintSchema getRight() {
        return this.right;
    }

    @JsonAlias(value={"$ref", "ref"})
    public void setRef(String ref) {
        this.ref = ref;
    }

    @JsonIgnore
    public void setRefSchema(BlueprintSchema refSchema) {
        this.refSchema = refSchema;
    }

    public void setAnyOf(List<BlueprintSchema> anyOf) {
        this.anyOf = anyOf;
    }

    public void setOneOf(List<BlueprintSchema> oneOf) {
        this.oneOf = oneOf;
    }

    public void setAllOf(List<BlueprintSchema> allOf) {
        this.allOf = allOf;
    }

    public void setNotOf(List<BlueprintSchema> notOf) {
        this.notOf = notOf;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDataType(BlueprintDatatype dataType) {
        this.dataType = dataType;
    }

    @JsonAlias(value={"$comment", "comment"})
    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonAlias(value={"enum"})
    public void setEnumLiterals(String[] enumLiterals) {
        this.enumLiterals = enumLiterals;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMultipleOf(int multipleOf) {
        this.multipleOf = multipleOf;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public void setExclusiveMaximum(int exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public void setExclusiveMinimum(int exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public void setItems(BlueprintSchema items) {
        this.items = items;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setMinItems(int minItems) {
        this.minItems = minItems;
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    public void setKeys(BlueprintSchema keys) {
        this.keys = keys;
    }

    public void setValues(BlueprintSchema values) {
        this.values = values;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setFields(List<BlueprintSchema> fields) {
        this.fields = fields;
    }

    public void setLeft(BlueprintSchema left) {
        this.left = left;
    }

    public void setRight(BlueprintSchema right) {
        this.right = right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlueprintSchema)) {
            return false;
        }
        BlueprintSchema other = (BlueprintSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        if (this.getMinLength() != other.getMinLength()) {
            return false;
        }
        if (this.getMultipleOf() != other.getMultipleOf()) {
            return false;
        }
        if (this.getMaximum() != other.getMaximum()) {
            return false;
        }
        if (this.getExclusiveMaximum() != other.getExclusiveMaximum()) {
            return false;
        }
        if (this.getMinimum() != other.getMinimum()) {
            return false;
        }
        if (this.getExclusiveMinimum() != other.getExclusiveMinimum()) {
            return false;
        }
        if (this.getMaxItems() != other.getMaxItems()) {
            return false;
        }
        if (this.getMinItems() != other.getMinItems()) {
            return false;
        }
        if (this.isUniqueItems() != other.isUniqueItems()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        BlueprintSchema this$refSchema = this.getRefSchema();
        BlueprintSchema other$refSchema = other.getRefSchema();
        if (this$refSchema == null ? other$refSchema != null : !((Object)this$refSchema).equals(other$refSchema)) {
            return false;
        }
        List<BlueprintSchema> this$anyOf = this.getAnyOf();
        List<BlueprintSchema> other$anyOf = other.getAnyOf();
        if (this$anyOf == null ? other$anyOf != null : !((Object)this$anyOf).equals(other$anyOf)) {
            return false;
        }
        List<BlueprintSchema> this$oneOf = this.getOneOf();
        List<BlueprintSchema> other$oneOf = other.getOneOf();
        if (this$oneOf == null ? other$oneOf != null : !((Object)this$oneOf).equals(other$oneOf)) {
            return false;
        }
        List<BlueprintSchema> this$allOf = this.getAllOf();
        List<BlueprintSchema> other$allOf = other.getAllOf();
        if (this$allOf == null ? other$allOf != null : !((Object)this$allOf).equals(other$allOf)) {
            return false;
        }
        List<BlueprintSchema> this$notOf = this.getNotOf();
        List<BlueprintSchema> other$notOf = other.getNotOf();
        if (this$notOf == null ? other$notOf != null : !((Object)this$notOf).equals(other$notOf)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        BlueprintDatatype this$dataType = this.getDataType();
        BlueprintDatatype other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEnumLiterals(), other.getEnumLiterals())) {
            return false;
        }
        BlueprintSchema this$items = this.getItems();
        BlueprintSchema other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        BlueprintSchema this$keys = this.getKeys();
        BlueprintSchema other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        BlueprintSchema this$values = this.getValues();
        BlueprintSchema other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        List<BlueprintSchema> this$fields = this.getFields();
        List<BlueprintSchema> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        BlueprintSchema this$left = this.getLeft();
        BlueprintSchema other$left = other.getLeft();
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        BlueprintSchema this$right = this.getRight();
        BlueprintSchema other$right = other.getRight();
        return !(this$right == null ? other$right != null : !((Object)this$right).equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlueprintSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLength();
        result = result * 59 + this.getMinLength();
        result = result * 59 + this.getMultipleOf();
        result = result * 59 + this.getMaximum();
        result = result * 59 + this.getExclusiveMaximum();
        result = result * 59 + this.getMinimum();
        result = result * 59 + this.getExclusiveMinimum();
        result = result * 59 + this.getMaxItems();
        result = result * 59 + this.getMinItems();
        result = result * 59 + (this.isUniqueItems() ? 79 : 97);
        result = result * 59 + this.getIndex();
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        BlueprintSchema $refSchema = this.getRefSchema();
        result = result * 59 + ($refSchema == null ? 43 : ((Object)$refSchema).hashCode());
        List<BlueprintSchema> $anyOf = this.getAnyOf();
        result = result * 59 + ($anyOf == null ? 43 : ((Object)$anyOf).hashCode());
        List<BlueprintSchema> $oneOf = this.getOneOf();
        result = result * 59 + ($oneOf == null ? 43 : ((Object)$oneOf).hashCode());
        List<BlueprintSchema> $allOf = this.getAllOf();
        result = result * 59 + ($allOf == null ? 43 : ((Object)$allOf).hashCode());
        List<BlueprintSchema> $notOf = this.getNotOf();
        result = result * 59 + ($notOf == null ? 43 : ((Object)$notOf).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        BlueprintDatatype $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEnumLiterals());
        BlueprintSchema $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        BlueprintSchema $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        BlueprintSchema $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        List<BlueprintSchema> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        BlueprintSchema $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        BlueprintSchema $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
        return result;
    }

    public String toString() {
        return "BlueprintSchema(ref=" + this.getRef() + ", refSchema=" + this.getRefSchema() + ", anyOf=" + this.getAnyOf() + ", oneOf=" + this.getOneOf() + ", allOf=" + this.getAllOf() + ", notOf=" + this.getNotOf() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", dataType=" + this.getDataType() + ", comment=" + this.getComment() + ", enumLiterals=" + Arrays.deepToString(this.getEnumLiterals()) + ", maxLength=" + this.getMaxLength() + ", minLength=" + this.getMinLength() + ", multipleOf=" + this.getMultipleOf() + ", maximum=" + this.getMaximum() + ", exclusiveMaximum=" + this.getExclusiveMaximum() + ", minimum=" + this.getMinimum() + ", exclusiveMinimum=" + this.getExclusiveMinimum() + ", items=" + this.getItems() + ", maxItems=" + this.getMaxItems() + ", minItems=" + this.getMinItems() + ", uniqueItems=" + this.isUniqueItems() + ", keys=" + this.getKeys() + ", values=" + this.getValues() + ", index=" + this.getIndex() + ", fields=" + this.getFields() + ", left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }
}

