/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.blueprint.model;

import com.bloxbean.cardano.client.plutus.blueprint.PlutusBlueprintUtil;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintSchema;
import com.bloxbean.cardano.client.plutus.blueprint.model.PlutusVersion;
import com.bloxbean.cardano.client.plutus.blueprint.model.Preamble;
import com.bloxbean.cardano.client.plutus.blueprint.model.Validator;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PlutusContractBlueprint {
    private Preamble preamble;
    private List<Validator> validators;
    private Map<String, BlueprintSchema> definitions;

    @JsonIgnore
    public PlutusScript getPlutusScript(String title) {
        if (this.validators == null || this.validators.isEmpty()) {
            return null;
        }
        return this.validators.stream().filter(v -> v.getTitle().equals(title)).findFirst().map(v -> {
            if (this.preamble.getPlutusVersion() == PlutusVersion.v1) {
                return PlutusBlueprintUtil.getPlutusScriptFromCompiledCode(v.getCompiledCode(), this.preamble.getPlutusVersion());
            }
            return PlutusBlueprintUtil.getPlutusScriptFromCompiledCode(v.getCompiledCode(), this.preamble.getPlutusVersion());
        }).orElse(null);
    }

    public Preamble getPreamble() {
        return this.preamble;
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public Map<String, BlueprintSchema> getDefinitions() {
        return this.definitions;
    }

    public void setPreamble(Preamble preamble) {
        this.preamble = preamble;
    }

    public void setValidators(List<Validator> validators) {
        this.validators = validators;
    }

    public void setDefinitions(Map<String, BlueprintSchema> definitions) {
        this.definitions = definitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlutusContractBlueprint)) {
            return false;
        }
        PlutusContractBlueprint other = (PlutusContractBlueprint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Preamble this$preamble = this.getPreamble();
        Preamble other$preamble = other.getPreamble();
        if (this$preamble == null ? other$preamble != null : !((Object)this$preamble).equals(other$preamble)) {
            return false;
        }
        List<Validator> this$validators = this.getValidators();
        List<Validator> other$validators = other.getValidators();
        if (this$validators == null ? other$validators != null : !((Object)this$validators).equals(other$validators)) {
            return false;
        }
        Map<String, BlueprintSchema> this$definitions = this.getDefinitions();
        Map<String, BlueprintSchema> other$definitions = other.getDefinitions();
        return !(this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlutusContractBlueprint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Preamble $preamble = this.getPreamble();
        result = result * 59 + ($preamble == null ? 43 : ((Object)$preamble).hashCode());
        List<Validator> $validators = this.getValidators();
        result = result * 59 + ($validators == null ? 43 : ((Object)$validators).hashCode());
        Map<String, BlueprintSchema> $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        return result;
    }

    public String toString() {
        return "PlutusContractBlueprint(preamble=" + this.getPreamble() + ", validators=" + this.getValidators() + ", definitions=" + this.getDefinitions() + ")";
    }

    public PlutusContractBlueprint() {
    }

    public PlutusContractBlueprint(Preamble preamble, List<Validator> validators, Map<String, BlueprintSchema> definitions) {
        this.preamble = preamble;
        this.validators = validators;
        this.definitions = definitions;
    }
}

