/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.serializers.MapDataJsonDeserializer;
import com.bloxbean.cardano.client.plutus.spec.serializers.MapDataJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonSerialize(using=MapDataJsonSerializer.class)
@JsonDeserialize(using=MapDataJsonDeserializer.class)
public class MapPlutusData
implements PlutusData {
    private java.util.Map<PlutusData, PlutusData> map;

    public static MapPlutusData deserialize(Map mapDI) throws CborDeserializationException {
        if (mapDI == null) {
            return null;
        }
        MapPlutusData mapPlutusData = new MapPlutusData();
        for (DataItem keyDI : mapDI.getKeys()) {
            PlutusData key = PlutusData.deserialize(keyDI);
            PlutusData value = PlutusData.deserialize(mapDI.get(keyDI));
            mapPlutusData.put(key, value);
        }
        return mapPlutusData;
    }

    public MapPlutusData put(PlutusData key, PlutusData value) {
        if (this.map == null) {
            this.map = new LinkedHashMap<PlutusData, PlutusData>();
        }
        this.map.put(key, value);
        return this;
    }

    @Override
    public DataItem serialize() throws CborSerializationException {
        if (this.map == null) {
            return null;
        }
        Map plutusDataMap = new Map();
        for (Map.Entry<PlutusData, PlutusData> entry : this.map.entrySet()) {
            DataItem key = entry.getKey().serialize();
            DataItem value = entry.getValue().serialize();
            if (key == null) {
                throw new CborSerializationException("Cbor serialization failed for PlutusData.  NULL serialized value found for key");
            }
            if (value == null) {
                throw new CborSerializationException("Cbor serialization failed for PlutusData.  NULL serialized value found for value");
            }
            plutusDataMap.put(key, value);
        }
        return plutusDataMap;
    }

    private static java.util.Map<PlutusData, PlutusData> $default$map() {
        return new LinkedHashMap<PlutusData, PlutusData>();
    }

    public static MapPlutusDataBuilder builder() {
        return new MapPlutusDataBuilder();
    }

    public java.util.Map<PlutusData, PlutusData> getMap() {
        return this.map;
    }

    public MapPlutusData(java.util.Map<PlutusData, PlutusData> map) {
        this.map = map;
    }

    public MapPlutusData() {
        this.map = MapPlutusData.$default$map();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapPlutusData)) {
            return false;
        }
        MapPlutusData other = (MapPlutusData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        java.util.Map<PlutusData, PlutusData> this$map = this.getMap();
        java.util.Map<PlutusData, PlutusData> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapPlutusData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        java.util.Map<PlutusData, PlutusData> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    public static class MapPlutusDataBuilder {
        private boolean map$set;
        private java.util.Map<PlutusData, PlutusData> map$value;

        MapPlutusDataBuilder() {
        }

        public MapPlutusDataBuilder map(java.util.Map<PlutusData, PlutusData> map) {
            this.map$value = map;
            this.map$set = true;
            return this;
        }

        public MapPlutusData build() {
            java.util.Map<PlutusData, PlutusData> map$value = this.map$value;
            if (!this.map$set) {
                map$value = MapPlutusData.$default$map();
            }
            return new MapPlutusData(map$value);
        }

        public String toString() {
            return "MapPlutusData.MapPlutusDataBuilder(map$value=" + this.map$value + ")";
        }
    }
}

