/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.Language;
import com.bloxbean.cardano.client.plutus.spec.PlutusV1Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV2Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV3Script;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;

public abstract class PlutusScript
implements Script {
    protected String type;
    protected String description;
    protected String cborHex;

    public ByteString serializeAsDataItem() throws CborSerializationException {
        byte[] bytes = HexUtil.decodeHexString((String)this.cborHex);
        if (bytes.length > 0) {
            try {
                List diList = CborDecoder.decode((byte[])bytes);
                if (diList == null || diList.size() == 0) {
                    throw new CborSerializationException("Serialization failed");
                }
                DataItem di = (DataItem)diList.get(0);
                return (ByteString)di;
            }
            catch (CborException e) {
                throw new CborSerializationException("Serialization failed", (Exception)((Object)e));
            }
        }
        return null;
    }

    public byte[] serializeScriptBody() throws CborSerializationException {
        return this.serializeAsDataItem().getBytes();
    }

    public byte[] scriptRefBytes() throws CborSerializationException {
        int type = this.getScriptType();
        byte[] serializedBytes = this.serializeScriptBody();
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger((long)type));
        array.add((DataItem)new ByteString(serializedBytes));
        try {
            return CborSerializationUtil.serialize((DataItem)array);
        }
        catch (CborException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
    }

    public static PlutusScript deserializeScriptRef(byte[] scriptRefBytes) {
        Array plutusScriptArray = (Array)CborSerializationUtil.deserialize((byte[])scriptRefBytes);
        List dataItemList = plutusScriptArray.getDataItems();
        if (dataItemList == null || dataItemList.size() == 0) {
            throw new CborRuntimeException("PlutusScript deserialization failed. Invalid no of DataItem");
        }
        int type = ((UnsignedInteger)dataItemList.get(0)).getValue().intValue();
        ByteString scriptBytes = (ByteString)dataItemList.get(1);
        try {
            if (type == 1) {
                return PlutusV1Script.deserialize(scriptBytes);
            }
            if (type == 2) {
                return PlutusV2Script.deserialize(scriptBytes);
            }
            if (type == 3) {
                return PlutusV3Script.deserialize(scriptBytes);
            }
            throw new CborRuntimeException("Invalid type : " + type);
        }
        catch (Exception e) {
            throw new CborRuntimeException("PlutusScript deserialization failed.", e);
        }
    }

    public abstract Language getLanguage();

    protected PlutusScript(PlutusScriptBuilder<?, ?> b) {
        this.type = b.type;
        this.description = b.description;
        this.cborHex = b.cborHex;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCborHex() {
        return this.cborHex;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCborHex(String cborHex) {
        this.cborHex = cborHex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlutusScript)) {
            return false;
        }
        PlutusScript other = (PlutusScript)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$cborHex = this.getCborHex();
        String other$cborHex = other.getCborHex();
        return !(this$cborHex == null ? other$cborHex != null : !this$cborHex.equals(other$cborHex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlutusScript;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $cborHex = this.getCborHex();
        result = result * 59 + ($cborHex == null ? 43 : $cborHex.hashCode());
        return result;
    }

    public String toString() {
        return "PlutusScript(type=" + this.getType() + ", description=" + this.getDescription() + ", cborHex=" + this.getCborHex() + ")";
    }

    public PlutusScript(String type, String description, String cborHex) {
        this.type = type;
        this.description = description;
        this.cborHex = cborHex;
    }

    public PlutusScript() {
    }

    public String getType() {
        return this.type;
    }

    public static abstract class PlutusScriptBuilder<C extends PlutusScript, B extends PlutusScriptBuilder<C, B>> {
        private String type;
        private String description;
        private String cborHex;

        public B type(String type) {
            this.type = type;
            return this.self();
        }

        public B description(String description) {
            this.description = description;
            return this.self();
        }

        public B cborHex(String cborHex) {
            this.cborHex = cborHex;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "PlutusScript.PlutusScriptBuilder(type=" + this.type + ", description=" + this.description + ", cborHex=" + this.cborHex + ")";
        }
    }
}

