/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.util;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.blueprint.model.PlutusVersion;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.plutus.spec.PlutusV1Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV2Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV3Script;
import com.bloxbean.cardano.client.util.HexUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;

public class PlutusUtil {
    public static boolean isDoubleEncoded(String scriptCode) {
        Objects.requireNonNull(scriptCode, "Script code is required");
        ByteString bs = (ByteString)CborSerializationUtil.deserialize((byte[])HexUtil.decodeHexString((String)scriptCode));
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bs.getBytes());
            CborDecoder decoder = new CborDecoder((InputStream)bais);
            DataItem di = decoder.decodeNext();
            return di instanceof ByteString;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Optional<PlutusScript> getPlutusScript(String scriptHash, String scriptCbor) {
        String cborHex;
        boolean doubleEncoded = PlutusUtil.isDoubleEncoded(scriptCbor);
        if (doubleEncoded) {
            cborHex = scriptCbor;
        } else {
            try {
                ByteString bs = new ByteString(HexUtil.decodeHexString((String)scriptCbor));
                cborHex = HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)bs));
            }
            catch (CborException e) {
                throw new CborRuntimeException("Error serializing script code", (Exception)((Object)e));
            }
        }
        try {
            PlutusVersion[] versions;
            for (PlutusVersion version : versions = new PlutusVersion[]{PlutusVersion.v1, PlutusVersion.v2, PlutusVersion.v3}) {
                PlutusScript plutusScript = PlutusUtil.getPlutusScript(cborHex, version);
                String calculatedScriptHash = HexUtil.encodeHexString((byte[])plutusScript.getScriptHash());
                if (!scriptHash.equals(calculatedScriptHash)) continue;
                return Optional.of(plutusScript);
            }
            return Optional.empty();
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
    }

    public static PlutusScript getPlutusScript(String cborHex, PlutusVersion plutusVersion) {
        switch (plutusVersion) {
            case v1: {
                return ((PlutusV1Script.PlutusV1ScriptBuilder)PlutusV1Script.builder().cborHex(cborHex)).build();
            }
            case v2: {
                return ((PlutusV2Script.PlutusV2ScriptBuilder)PlutusV2Script.builder().cborHex(cborHex)).build();
            }
            case v3: {
                return ((PlutusV3Script.PlutusV3ScriptBuilder)PlutusV3Script.builder().cborHex(cborHex)).build();
            }
        }
        throw new IllegalArgumentException("Invalid plutus version found " + plutusVersion);
    }
}

