/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation;

import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.BytesPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ConstrPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class BasePlutusDataConverter {
    protected ConstrPlutusData initConstr(long alternative) {
        return ConstrPlutusData.builder().alternative(alternative).data(ListPlutusData.builder().build()).build();
    }

    protected PlutusData toPlutusData(Long number) {
        return BigIntPlutusData.of(number);
    }

    protected PlutusData toPlutusData(BigInteger bi) {
        return BigIntPlutusData.of(bi);
    }

    protected PlutusData toPlutusData(Integer i) {
        return BigIntPlutusData.of(i);
    }

    protected PlutusData toPlutusData(byte[] bytes) {
        return BytesPlutusData.of(bytes);
    }

    protected PlutusData toPlutusData(String s) {
        if (s.startsWith("0x") || s.startsWith("0X")) {
            byte[] bytes = HexUtil.decodeHexString((String)s);
            return BytesPlutusData.of(bytes);
        }
        return BytesPlutusData.of(s);
    }

    protected PlutusData toPlutusData(Boolean b) {
        Objects.requireNonNull(b, "Boolean value cannot be null");
        if (b.booleanValue()) {
            return ConstrPlutusData.of(1L, new PlutusData[0]);
        }
        return ConstrPlutusData.of(0L, new PlutusData[0]);
    }

    protected Long plutusDataToLong(PlutusData data) {
        return ((BigIntPlutusData)data).getValue().longValue();
    }

    protected Integer plutusDataToInteger(PlutusData data) {
        return ((BigIntPlutusData)data).getValue().intValue();
    }

    protected BigInteger plutusDataToBigInteger(PlutusData data) {
        return ((BigIntPlutusData)data).getValue();
    }

    protected byte[] plutusDataToBytes(PlutusData data) {
        return ((BytesPlutusData)data).getValue();
    }

    protected String plutusDataToString(PlutusData data, String encoding) {
        return this.deserializeBytesToString(((BytesPlutusData)data).getValue(), encoding);
    }

    protected Boolean plutusDataToBoolean(PlutusData data) {
        return ((ConstrPlutusData)data).getAlternative() == 1L;
    }

    protected String deserializeBytesToString(byte[] bytes, String encoding) {
        if (encoding == null || encoding.isEmpty() || encoding.equalsIgnoreCase("utf-8")) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        if (encoding.equalsIgnoreCase("hex")) {
            return HexUtil.encodeHexString((byte[])bytes);
        }
        throw new IllegalArgumentException("Unsupported encoding: " + encoding);
    }
}

