/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.blueprint;

import com.bloxbean.cardano.client.plutus.blueprint.exception.PlutusBlueprintException;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintDatatype;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintSchema;
import com.bloxbean.cardano.client.plutus.blueprint.model.PlutusContractBlueprint;
import com.bloxbean.cardano.client.plutus.blueprint.model.Validator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlutusBlueprintLoader {
    public static PlutusContractBlueprint loadBlueprint(File file) {
        PlutusContractBlueprint plutusContractBlueprint;
        FileInputStream input = new FileInputStream(file);
        try {
            plutusContractBlueprint = PlutusBlueprintLoader.loadBlueprint(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new PlutusBlueprintException(ex);
            }
        }
        input.close();
        return plutusContractBlueprint;
    }

    public static PlutusContractBlueprint loadBlueprint(InputStream is) {
        ObjectMapper objectMapper = new ObjectMapper();
        PlutusContractBlueprint plutusContractBlueprint = null;
        try {
            plutusContractBlueprint = (PlutusContractBlueprint)objectMapper.readValue(is, PlutusContractBlueprint.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        plutusContractBlueprint = PlutusBlueprintLoader.resolveReferences(plutusContractBlueprint);
        return plutusContractBlueprint;
    }

    private static PlutusContractBlueprint resolveReferences(PlutusContractBlueprint plutusContractBlueprint) {
        Map<String, BlueprintSchema> definitions = plutusContractBlueprint.getDefinitions();
        List<Validator> validators = plutusContractBlueprint.getValidators();
        for (Validator validator : validators) {
            if (validator.getDatum() != null) {
                BlueprintSchema schema = validator.getDatum().getSchema();
                validator.getDatum().setSchema(PlutusBlueprintLoader.resolveDatum(definitions, schema));
            }
            if (validator.getRedeemer() != null) {
                validator.getRedeemer().setSchema(PlutusBlueprintLoader.resolveDatum(definitions, validator.getRedeemer().getSchema()));
            }
            if (validator.getParameters() == null) continue;
            for (int i = 0; i < validator.getParameters().size(); ++i) {
                BlueprintSchema parameterSchema = validator.getParameters().get(i).getSchema();
                validator.getParameters().get(i).setSchema(PlutusBlueprintLoader.resolveDatum(definitions, parameterSchema));
            }
        }
        return plutusContractBlueprint;
    }

    private static BlueprintSchema resolveDatum(Map<String, BlueprintSchema> definitions, BlueprintSchema schema) {
        BlueprintSchema blueprintSchema = schema;
        if (schema.getRef() != null) {
            String ref = PlutusBlueprintLoader.getAndPrepare(schema);
            BlueprintSchema refDatumSchema = definitions.get(ref);
            blueprintSchema.copyFrom(refDatumSchema);
            if (blueprintSchema.getDataType() == null && ref.startsWith("Option$")) {
                blueprintSchema.setDataType(BlueprintDatatype.option);
            }
        }
        blueprintSchema.setFields(PlutusBlueprintLoader.extracted(definitions, blueprintSchema.getFields()));
        blueprintSchema.setAnyOf(PlutusBlueprintLoader.extracted(definitions, blueprintSchema.getAnyOf()));
        if (blueprintSchema.getItems() != null) {
            blueprintSchema.setItems(PlutusBlueprintLoader.extracted(definitions, List.of(blueprintSchema.getItems())).get(0));
        }
        if (blueprintSchema.getKeys() != null) {
            blueprintSchema.setKeys(PlutusBlueprintLoader.extracted(definitions, List.of(blueprintSchema.getKeys())).get(0));
        }
        if (blueprintSchema.getValues() != null) {
            blueprintSchema.setValues(PlutusBlueprintLoader.extracted(definitions, List.of(blueprintSchema.getValues())).get(0));
        }
        if (blueprintSchema.getLeft() != null) {
            blueprintSchema.setLeft(PlutusBlueprintLoader.extracted(definitions, List.of(blueprintSchema.getLeft())).get(0));
        }
        if (blueprintSchema.getRight() != null) {
            blueprintSchema.setRight(PlutusBlueprintLoader.extracted(definitions, List.of(blueprintSchema.getRight())).get(0));
        }
        return blueprintSchema;
    }

    private static List<BlueprintSchema> extracted(Map<String, BlueprintSchema> definitions, List<BlueprintSchema> listInSchema) {
        ArrayList<BlueprintSchema> list = null;
        if (listInSchema != null) {
            list = new ArrayList<BlueprintSchema>(listInSchema);
            for (int i = 0; i < listInSchema.size(); ++i) {
                BlueprintSchema field = listInSchema.get(i);
                list.set(i, PlutusBlueprintLoader.resolveDatum(definitions, field));
            }
        }
        return list;
    }

    private static String getAndPrepare(BlueprintSchema schema) {
        String ref = schema.getRef();
        ref = ref.replace("#/definitions/", "");
        ref = ref.replace("~1", "/");
        return ref;
    }
}

