/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.blueprint;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.plutus.blueprint.model.PlutusVersion;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.plutus.spec.PlutusV1Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV2Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV3Script;
import com.bloxbean.cardano.client.util.HexUtil;

public class PlutusBlueprintUtil {
    public static PlutusScript getPlutusScriptFromCompiledCode(String compiledCode, PlutusVersion plutusVersion) {
        ByteString bs = new ByteString(HexUtil.decodeHexString((String)compiledCode));
        try {
            String cborHex = HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)bs));
            if (plutusVersion.equals((Object)PlutusVersion.v1)) {
                return ((PlutusV1Script.PlutusV1ScriptBuilder)PlutusV1Script.builder().cborHex(cborHex)).build();
            }
            if (plutusVersion.equals((Object)PlutusVersion.v2)) {
                return ((PlutusV2Script.PlutusV2ScriptBuilder)PlutusV2Script.builder().cborHex(cborHex)).build();
            }
            if (plutusVersion.equals((Object)PlutusVersion.v3)) {
                return ((PlutusV3Script.PlutusV3ScriptBuilder)PlutusV3Script.builder().cborHex(cborHex)).build();
            }
            throw new RuntimeException("Unsupported Plutus version" + plutusVersion);
        }
        catch (CborException e) {
            throw new RuntimeException(e);
        }
    }
}

