/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.Tag;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.custom.ChunkedByteString;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.serializers.BigIntDataJsonDeserializer;
import com.bloxbean.cardano.client.plutus.spec.serializers.BigIntDataJsonSerializer;
import com.bloxbean.cardano.client.plutus.util.Bytes;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.math.BigInteger;

@JsonSerialize(using=BigIntDataJsonSerializer.class)
@JsonDeserialize(using=BigIntDataJsonDeserializer.class)
public class BigIntPlutusData
implements PlutusData {
    private BigInteger value;

    public static BigIntPlutusData deserialize(Number numberDI) {
        if (numberDI == null) {
            return null;
        }
        return new BigIntPlutusData(numberDI.getValue());
    }

    public static BigIntPlutusData deserialize(ByteString byteString) {
        if (byteString == null) {
            return null;
        }
        Tag tag = byteString.getTag();
        if (tag != null) {
            switch ((int)tag.getValue()) {
                case 2: {
                    return BigIntPlutusData.of(new BigInteger(1, byteString.getBytes()));
                }
                case 3: {
                    return BigIntPlutusData.of(MINUS_ONE.subtract(new BigInteger(1, byteString.getBytes())));
                }
            }
            throw new IllegalArgumentException("Invalid tag for BigIntPlutusData");
        }
        throw new IllegalArgumentException("Missing tag for BigIntPlutusData");
    }

    public static BigIntPlutusData of(int i) {
        return new BigIntPlutusData(BigInteger.valueOf(i));
    }

    public static BigIntPlutusData of(long l) {
        return new BigIntPlutusData(BigInteger.valueOf(l));
    }

    public static BigIntPlutusData of(BigInteger b) {
        return new BigIntPlutusData(b);
    }

    @Override
    public DataItem serialize() throws CborSerializationException {
        Object di = null;
        if (this.value != null) {
            if (this.value.bitLength() <= 64) {
                di = this.value.signum() >= 0 ? new UnsignedInteger(this.value) : new NegativeInteger(this.value);
            } else {
                byte[] bytes = this.value.toByteArray();
                if (this.value.signum() < 0) {
                    bytes = this.negateBytes(bytes);
                    di = new ChunkedByteString(Bytes.getChunks(bytes, 64));
                    di.setTag(3L);
                } else {
                    di = new ChunkedByteString(Bytes.getChunks(bytes, 64));
                    di.setTag(2L);
                }
            }
        }
        return di;
    }

    private byte[] negateBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = ~bytes[i];
        }
        return bytes;
    }

    public static BigIntPlutusDataBuilder builder() {
        return new BigIntPlutusDataBuilder();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigIntPlutusData(BigInteger value) {
        this.value = value;
    }

    public BigIntPlutusData() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigIntPlutusData)) {
            return false;
        }
        BigIntPlutusData other = (BigIntPlutusData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BigIntPlutusData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public static class BigIntPlutusDataBuilder {
        private BigInteger value;

        BigIntPlutusDataBuilder() {
        }

        public BigIntPlutusDataBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        public BigIntPlutusData build() {
            return new BigIntPlutusData(this.value);
        }

        public String toString() {
            return "BigIntPlutusData.BigIntPlutusDataBuilder(value=" + this.value + ")";
        }
    }
}

