/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Tag;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.serializers.ConstrDataJsonDeserializer;
import com.bloxbean.cardano.client.plutus.spec.serializers.ConstrDataJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

@JsonSerialize(using=ConstrDataJsonSerializer.class)
@JsonDeserialize(using=ConstrDataJsonDeserializer.class)
public class ConstrPlutusData
implements PlutusData {
    private static final long GENERAL_FORM_TAG = 102L;
    private long alternative;
    private ListPlutusData data;

    public static ConstrPlutusData of(long alternative, PlutusData ... plutusDataList) {
        return ConstrPlutusData.builder().alternative(alternative).data(ListPlutusData.of(plutusDataList)).build();
    }

    public static ConstrPlutusData deserialize(DataItem di) throws CborDeserializationException {
        Tag tag = di.getTag();
        Long alternative = null;
        ListPlutusData data = null;
        if (102L == tag.getValue()) {
            Array constrArray = (Array)di;
            List dataItems = constrArray.getDataItems();
            if (dataItems.size() != 2) {
                throw new CborDeserializationException("Cbor deserialization failed. Expected 2 DataItem, found : " + dataItems.size());
            }
            alternative = ((UnsignedInteger)dataItems.get(0)).getValue().longValue();
            data = ListPlutusData.deserialize((Array)dataItems.get(1));
        } else {
            alternative = ConstrPlutusData.compactCborTagToAlternative(tag.getValue());
            data = ListPlutusData.deserialize((Array)di);
        }
        return ConstrPlutusData.builder().alternative(alternative).data(data).build();
    }

    private static Long alternativeToCompactCborTag(long alt) {
        if (alt <= 6L) {
            return 121L + alt;
        }
        if (alt >= 7L && alt <= 127L) {
            return 1273L + alt;
        }
        return null;
    }

    private static Long compactCborTagToAlternative(long cborTag) {
        if (cborTag >= 121L && cborTag <= 127L) {
            return cborTag - 121L;
        }
        if (cborTag >= 1280L && cborTag <= 1400L) {
            return cborTag - 1280L + 7L;
        }
        return null;
    }

    @Override
    public DataItem serialize() throws CborSerializationException {
        Long cborTag = ConstrPlutusData.alternativeToCompactCborTag(this.alternative);
        DataItem dataItem = null;
        if (cborTag != null) {
            dataItem = this.data.serialize();
            dataItem.setTag(cborTag.longValue());
        } else {
            Array constrArray = new Array();
            constrArray.add((DataItem)new UnsignedInteger(this.alternative));
            constrArray.add(this.data.serialize());
            dataItem = constrArray;
            dataItem.setTag(102L);
        }
        return dataItem;
    }

    public static ConstrPlutusDataBuilder builder() {
        return new ConstrPlutusDataBuilder();
    }

    public long getAlternative() {
        return this.alternative;
    }

    public ListPlutusData getData() {
        return this.data;
    }

    public ConstrPlutusData(long alternative, ListPlutusData data) {
        this.alternative = alternative;
        this.data = data;
    }

    public ConstrPlutusData() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstrPlutusData)) {
            return false;
        }
        ConstrPlutusData other = (ConstrPlutusData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAlternative() != other.getAlternative()) {
            return false;
        }
        ListPlutusData this$data = this.getData();
        ListPlutusData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConstrPlutusData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $alternative = this.getAlternative();
        result = result * 59 + (int)($alternative >>> 32 ^ $alternative);
        ListPlutusData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public static class ConstrPlutusDataBuilder {
        private long alternative;
        private ListPlutusData data;

        ConstrPlutusDataBuilder() {
        }

        public ConstrPlutusDataBuilder alternative(long alternative) {
            this.alternative = alternative;
            return this;
        }

        public ConstrPlutusDataBuilder data(ListPlutusData data) {
            this.data = data;
            return this;
        }

        public ConstrPlutusData build() {
            return new ConstrPlutusData(this.alternative, this.data);
        }

        public String toString() {
            return "ConstrPlutusData.ConstrPlutusDataBuilder(alternative=" + this.alternative + ", data=" + this.data + ")";
        }
    }
}

