/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.Tag;
import co.nstant.in.cbor.model.UnicodeString;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.BytesPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ConstrPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import lombok.NonNull;

public interface PlutusData {
    public static final int BIG_UINT_TAG = 2;
    public static final int BIG_NINT_TAG = 3;
    public static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    public static final int BYTES_LIMIT = 64;

    public static PlutusData unit() {
        return ConstrPlutusData.builder().data(ListPlutusData.of(new PlutusData[0])).build();
    }

    public DataItem serialize() throws CborSerializationException;

    public static PlutusData deserialize(DataItem dataItem) throws CborDeserializationException {
        if (dataItem == null) {
            return null;
        }
        if (dataItem instanceof Number) {
            return BigIntPlutusData.deserialize((Number)dataItem);
        }
        if (dataItem instanceof ByteString) {
            Tag tag = dataItem.getTag();
            if (tag != null && (tag.getValue() == 2L || tag.getValue() == 3L)) {
                return BigIntPlutusData.deserialize((ByteString)dataItem);
            }
            return BytesPlutusData.deserialize((ByteString)dataItem);
        }
        if (dataItem instanceof UnicodeString) {
            return BytesPlutusData.deserialize((UnicodeString)dataItem);
        }
        if (dataItem instanceof Array) {
            if (dataItem.getTag() == null) {
                return ListPlutusData.deserialize((Array)dataItem);
            }
            return ConstrPlutusData.deserialize(dataItem);
        }
        if (dataItem instanceof Map) {
            return MapPlutusData.deserialize((Map)dataItem);
        }
        throw new CborDeserializationException("Cbor deserialization failed. Invalid type. " + dataItem);
    }

    public static PlutusData deserialize(@NonNull byte[] serializedBytes) throws CborDeserializationException {
        if (serializedBytes == null) {
            throw new NullPointerException("serializedBytes is marked non-null but is null");
        }
        try {
            DataItem dataItem = (DataItem)CborDecoder.decode((byte[])serializedBytes).get(0);
            return PlutusData.deserialize(dataItem);
        }
        catch (CborException | CborDeserializationException e) {
            throw new CborDeserializationException("Cbor de-serialization error", (Exception)e);
        }
    }

    @JsonIgnore
    default public String getDatumHash() {
        return HexUtil.encodeHexString((byte[])this.getDatumHashAsBytes());
    }

    @JsonIgnore
    default public byte[] getDatumHashAsBytes() {
        try {
            return Blake2bUtil.blake2bHash256((byte[])CborSerializationUtil.serialize((DataItem)this.serialize()));
        }
        catch (CborException | CborSerializationException e) {
            throw new CborRuntimeException("Cbor serialization error", (Exception)e);
        }
    }

    default public String serializeToHex() {
        try {
            return HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)this.serialize()));
        }
        catch (Exception e) {
            throw new CborRuntimeException("Cbor serialization error", e);
        }
    }

    default public byte[] serializeToBytes() {
        try {
            return CborSerializationUtil.serialize((DataItem)this.serialize());
        }
        catch (Exception e) {
            throw new CborRuntimeException("Cbor serialization error", e);
        }
    }
}

