/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.plutus.spec.Language;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.util.HexUtil;

public class PlutusV2Script
extends PlutusScript {
    public PlutusV2Script() {
        this.type = "PlutusScriptV2";
    }

    public static PlutusV2Script deserialize(ByteString plutusScriptDI) throws CborDeserializationException {
        if (plutusScriptDI != null) {
            byte[] bytes;
            PlutusV2Script plutusScript = new PlutusV2Script();
            try {
                bytes = CborSerializationUtil.serialize((DataItem)plutusScriptDI);
            }
            catch (CborException e) {
                throw new CborDeserializationException("CBor deserialization error", (Exception)((Object)e));
            }
            plutusScript.setCborHex(HexUtil.encodeHexString((byte[])bytes));
            return plutusScript;
        }
        return null;
    }

    public byte[] getScriptTypeBytes() {
        return new byte[]{(byte)this.getScriptType()};
    }

    public int getScriptType() {
        return 2;
    }

    @Override
    public Language getLanguage() {
        return Language.PLUTUS_V2;
    }

    protected PlutusV2Script(PlutusV2ScriptBuilder<?, ?> b) {
        super(b);
    }

    public static PlutusV2ScriptBuilder<?, ?> builder() {
        return new PlutusV2ScriptBuilderImpl();
    }

    private static final class PlutusV2ScriptBuilderImpl
    extends PlutusV2ScriptBuilder<PlutusV2Script, PlutusV2ScriptBuilderImpl> {
        private PlutusV2ScriptBuilderImpl() {
        }

        @Override
        protected PlutusV2ScriptBuilderImpl self() {
            return this;
        }

        @Override
        public PlutusV2Script build() {
            return new PlutusV2Script(this);
        }
    }

    public static abstract class PlutusV2ScriptBuilder<C extends PlutusV2Script, B extends PlutusV2ScriptBuilder<C, B>>
    extends PlutusScript.PlutusScriptBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "PlutusV2Script.PlutusV2ScriptBuilder(super=" + super.toString() + ")";
        }
    }
}

