/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.ExUnits;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.RedeemerTag;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.List;

public class Redeemer {
    private RedeemerTag tag;
    private BigInteger index;
    private PlutusData data;
    private ExUnits exUnits;

    @Deprecated(forRemoval=true)
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    public void setIndex(int index) {
        this.index = BigInteger.valueOf(index);
    }

    public Array serializePreConway() throws CborSerializationException {
        Array redeemerArray = new Array();
        if (this.tag == null) {
            throw new CborSerializationException("Redeemer tag cannot be null");
        }
        redeemerArray.add((DataItem)new UnsignedInteger((long)this.tag.value));
        redeemerArray.add((DataItem)new UnsignedInteger(this.index));
        if (this.data == null) {
            throw new CborSerializationException("Redeemer data cannot be null");
        }
        redeemerArray.add(this.data.serialize());
        if (this.exUnits == null) {
            throw new CborSerializationException("Redeemer exUnits cannot be null");
        }
        redeemerArray.add((DataItem)this.exUnits.serialize());
        return redeemerArray;
    }

    public Tuple<Array, Array> serialize() throws CborSerializationException {
        Array keyArray = new Array();
        if (this.tag == null) {
            throw new CborSerializationException("Redeemer tag cannot be null");
        }
        keyArray.add((DataItem)new UnsignedInteger((long)this.tag.value));
        keyArray.add((DataItem)new UnsignedInteger(this.index));
        Array valueArray = new Array();
        if (this.data == null) {
            throw new CborSerializationException("Redeemer data cannot be null");
        }
        valueArray.add(this.data.serialize());
        if (this.exUnits == null) {
            throw new CborSerializationException("Redeemer exUnits cannot be null");
        }
        valueArray.add((DataItem)this.exUnits.serialize());
        return new Tuple((Object)keyArray, (Object)valueArray);
    }

    @Deprecated(forRemoval=true)
    public static Redeemer deserialize(Array redeemerDI) throws CborDeserializationException {
        return Redeemer.deserializePreConway(redeemerDI);
    }

    public static Redeemer deserializePreConway(Array redeemerDI) throws CborDeserializationException {
        List redeemerDIList = redeemerDI.getDataItems();
        if (redeemerDIList == null || redeemerDIList.size() != 4) {
            throw new CborDeserializationException("Redeemer deserialization error. Invalid no of DataItems");
        }
        DataItem tagDI = (DataItem)redeemerDIList.get(0);
        DataItem indexDI = (DataItem)redeemerDIList.get(1);
        DataItem dataDI = (DataItem)redeemerDIList.get(2);
        DataItem exUnitDI = (DataItem)redeemerDIList.get(3);
        Redeemer redeemer = new Redeemer();
        int tagValue = ((UnsignedInteger)tagDI).getValue().intValue();
        if (tagValue == 0) {
            redeemer.setTag(RedeemerTag.Spend);
        } else if (tagValue == 1) {
            redeemer.setTag(RedeemerTag.Mint);
        } else if (tagValue == 2) {
            redeemer.setTag(RedeemerTag.Cert);
        } else if (tagValue == 3) {
            redeemer.setTag(RedeemerTag.Reward);
        } else if (tagValue == 4) {
            redeemer.setTag(RedeemerTag.Voting);
        } else if (tagValue == 5) {
            redeemer.setTag(RedeemerTag.Proposing);
        }
        redeemer.setIndex(((UnsignedInteger)indexDI).getValue());
        redeemer.setData(PlutusData.deserialize(dataDI));
        redeemer.setExUnits(ExUnits.deserialize((Array)exUnitDI));
        return redeemer;
    }

    public static Redeemer deserialize(Array redeemerKey, Array redeemerValue) throws CborDeserializationException {
        List redeemerKeyDIList = redeemerKey.getDataItems();
        if (redeemerKeyDIList == null || redeemerKeyDIList.size() != 2) {
            throw new CborDeserializationException("Redeemer deserialization error. Invalid no of DataItems in key");
        }
        List redeemerValueDIList = redeemerValue.getDataItems();
        if (redeemerValueDIList == null || redeemerValueDIList.size() != 2) {
            throw new CborDeserializationException("Redeemer deserialization error. Invalid no of DataItems in value");
        }
        DataItem tagDI = (DataItem)redeemerKeyDIList.get(0);
        DataItem indexDI = (DataItem)redeemerKeyDIList.get(1);
        DataItem dataDI = (DataItem)redeemerValueDIList.get(0);
        DataItem exUnitDI = (DataItem)redeemerValueDIList.get(1);
        Redeemer redeemer = new Redeemer();
        int tagValue = ((UnsignedInteger)tagDI).getValue().intValue();
        if (tagValue == 0) {
            redeemer.setTag(RedeemerTag.Spend);
        } else if (tagValue == 1) {
            redeemer.setTag(RedeemerTag.Mint);
        } else if (tagValue == 2) {
            redeemer.setTag(RedeemerTag.Cert);
        } else if (tagValue == 3) {
            redeemer.setTag(RedeemerTag.Reward);
        } else if (tagValue == 4) {
            redeemer.setTag(RedeemerTag.Voting);
        } else if (tagValue == 5) {
            redeemer.setTag(RedeemerTag.Proposing);
        }
        redeemer.setIndex(((UnsignedInteger)indexDI).getValue().intValue());
        redeemer.setData(PlutusData.deserialize(dataDI));
        redeemer.setExUnits(ExUnits.deserialize((Array)exUnitDI));
        return redeemer;
    }

    public static RedeemerBuilder builder() {
        return new RedeemerBuilder();
    }

    public RedeemerTag getTag() {
        return this.tag;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    public PlutusData getData() {
        return this.data;
    }

    public ExUnits getExUnits() {
        return this.exUnits;
    }

    public void setTag(RedeemerTag tag) {
        this.tag = tag;
    }

    public void setData(PlutusData data) {
        this.data = data;
    }

    public void setExUnits(ExUnits exUnits) {
        this.exUnits = exUnits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Redeemer)) {
            return false;
        }
        Redeemer other = (Redeemer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedeemerTag this$tag = this.getTag();
        RedeemerTag other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)((Object)this$tag)).equals((Object)other$tag)) {
            return false;
        }
        BigInteger this$index = this.getIndex();
        BigInteger other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        PlutusData this$data = this.getData();
        PlutusData other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        ExUnits this$exUnits = this.getExUnits();
        ExUnits other$exUnits = other.getExUnits();
        return !(this$exUnits == null ? other$exUnits != null : !((Object)this$exUnits).equals(other$exUnits));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Redeemer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedeemerTag $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)((Object)$tag)).hashCode());
        BigInteger $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        PlutusData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        ExUnits $exUnits = this.getExUnits();
        result = result * 59 + ($exUnits == null ? 43 : ((Object)$exUnits).hashCode());
        return result;
    }

    public String toString() {
        return "Redeemer(tag=" + this.getTag() + ", index=" + this.getIndex() + ", data=" + this.getData() + ", exUnits=" + this.getExUnits() + ")";
    }

    public Redeemer(RedeemerTag tag, BigInteger index, PlutusData data, ExUnits exUnits) {
        this.tag = tag;
        this.index = index;
        this.data = data;
        this.exUnits = exUnits;
    }

    public Redeemer() {
    }

    public static class RedeemerBuilder {
        private RedeemerTag tag;
        private BigInteger index;
        private PlutusData data;
        private ExUnits exUnits;

        @Deprecated
        public RedeemerBuilder index(BigInteger index) {
            this.index = index;
            return this;
        }

        public RedeemerBuilder index(int index) {
            this.index = BigInteger.valueOf(index);
            return this;
        }

        RedeemerBuilder() {
        }

        public RedeemerBuilder tag(RedeemerTag tag) {
            this.tag = tag;
            return this;
        }

        public RedeemerBuilder data(PlutusData data) {
            this.data = data;
            return this;
        }

        public RedeemerBuilder exUnits(ExUnits exUnits) {
            this.exUnits = exUnits;
            return this;
        }

        public Redeemer build() {
            return new Redeemer(this.tag, this.index, this.data, this.exUnits);
        }

        public String toString() {
            return "Redeemer.RedeemerBuilder(tag=" + this.tag + ", index=" + this.index + ", data=" + this.data + ", exUnits=" + this.exUnits + ")";
        }
    }
}

