/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec.serializers;

import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.serializers.PlutusDataJsonConverter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;

public class ListDataJsonDeserializer
extends StdDeserializer<ListPlutusData> {
    public ListDataJsonDeserializer() {
        this(null);
    }

    public ListDataJsonDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public ListPlutusData deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (!node.has("list")) {
            throw new IllegalArgumentException("Invalid json for ListPlutusData : " + node);
        }
        ArrayNode arrayNode = (ArrayNode)node.get("list");
        ArrayList<PlutusData> plutusDataList = new ArrayList<PlutusData>();
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode itemNode = arrayNode.get(i);
            plutusDataList.add(PlutusDataJsonConverter.toPlutusData(itemNode));
        }
        return ListPlutusData.of(plutusDataList.toArray(new PlutusData[0]));
    }
}

