/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.spec.serializers;

import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.BytesPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ConstrPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.NonNull;

public class PlutusDataJsonConverter {
    private static ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public static PlutusData toPlutusData(@NonNull String json) throws JsonProcessingException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        JsonNode jsonNode = mapper.readTree(json);
        return PlutusDataJsonConverter.toPlutusData(jsonNode);
    }

    public static PlutusData toPlutusData(@NonNull JsonNode jsonNode) throws JsonProcessingException {
        if (jsonNode == null) {
            throw new NullPointerException("jsonNode is marked non-null but is null");
        }
        if (jsonNode instanceof ObjectNode) {
            if (jsonNode.has("constructor")) {
                return (PlutusData)mapper.readValue(jsonNode.toString(), ConstrPlutusData.class);
            }
            if (jsonNode.has("int")) {
                return (PlutusData)mapper.readValue(jsonNode.toString(), BigIntPlutusData.class);
            }
            if (jsonNode.has("bytes")) {
                return (PlutusData)mapper.readValue(jsonNode.toString(), BytesPlutusData.class);
            }
            if (jsonNode.has("list")) {
                return (PlutusData)mapper.readValue(jsonNode.toString(), ListPlutusData.class);
            }
            if (jsonNode.has("map")) {
                return (PlutusData)mapper.readValue(jsonNode.toString(), MapPlutusData.class);
            }
        }
        throw new IllegalArgumentException("Json parsing failed. " + jsonNode);
    }

    public static String toJson(PlutusData plutusData) throws JsonProcessingException {
        return mapper.writeValueAsString((Object)plutusData);
    }
}

