/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.util;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.Tag;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;

public class PlutusDataPrettyPrinter {
    private static ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public static String toJson(PlutusData plutusData) {
        DataItem serializedPlutusData = plutusData.serialize();
        Object o = PlutusDataPrettyPrinter.parseItem(serializedPlutusData);
        return mapper.writeValueAsString(o);
    }

    private static Object parseItem(DataItem item) {
        Object value = "";
        switch (item.getMajorType()) {
            case BYTE_STRING: {
                value = PlutusDataPrettyPrinter.bytestringItemToString((ByteString)item);
                break;
            }
            case ARRAY: {
                value = PlutusDataPrettyPrinter.dataItemArrayToString((Array)item);
                break;
            }
            case MAP: {
                value = PlutusDataPrettyPrinter.parseDataItemMap((Map)item);
                break;
            }
            case UNSIGNED_INTEGER: {
                value = ((UnsignedInteger)item).getValue();
                break;
            }
            case NEGATIVE_INTEGER: {
                value = ((NegativeInteger)item).getValue();
                break;
            }
            case UNICODE_STRING: {
                value = ((UnicodeString)item).getString();
                break;
            }
            case TAG: {
                value = ((Tag)item).getValue();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unkown type. Not implemented");
            }
        }
        return value;
    }

    private static String bytestringItemToString(ByteString item) {
        String value = "";
        byte[] bytes = item.getBytes();
        value = PlutusDataPrettyPrinter.isUtf8String(bytes) ? new String(bytes) : HexUtil.encodeHexString((byte[])bytes, (boolean)true);
        return value;
    }

    private static Object dataItemArrayToString(Array array) {
        ArrayList<Object> decodedItemList = new ArrayList<Object>();
        for (DataItem dataItem : array.getDataItems()) {
            if (dataItem.getMajorType().equals((Object)MajorType.SPECIAL)) continue;
            decodedItemList.add(PlutusDataPrettyPrinter.parseItem(dataItem));
        }
        return decodedItemList.stream().toArray(Object[]::new);
    }

    private static HashMap<String, Object> parseDataItemMap(Map m) {
        HashMap<String, Object> decodedMap = new HashMap<String, Object>();
        for (DataItem keyItem : m.getKeys()) {
            String keyString = (String)PlutusDataPrettyPrinter.parseItem(keyItem);
            Object valueString = PlutusDataPrettyPrinter.parseItem(m.get(keyItem));
            decodedMap.put(keyString, valueString);
        }
        return decodedMap;
    }

    private static boolean isUtf8String(byte[] bytes) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException ex) {
            return false;
        }
        return true;
    }
}

